/*
 * Decompiled with CFR 0.152.
 */
package backpack.gui;

import backpack.gui.parts.GuiPart;
import backpack.gui.parts.GuiPartScrolling;
import backpack.handler.KeyHandlerBackpack;
import backpack.handler.PacketHandlerBackpack;
import backpack.inventory.container.ContainerAdvanced;
import backpack.misc.ConfigurationBackpack;
import backpack.misc.Constants;
import cpw.mods.fml.relauncher.Side;
import cpw.mods.fml.relauncher.SideOnly;
import java.util.List;
import net.minecraft.client.gui.GuiButton;
import net.minecraft.client.gui.inventory.GuiContainer;
import net.minecraft.inventory.Container;
import org.lwjgl.input.Mouse;
import org.lwjgl.opengl.GL11;

@SideOnly(value=Side.CLIENT)
public abstract class GuiAdvanced<T extends ContainerAdvanced>
extends GuiContainer {
    protected static final int TOPSPACING = 16;
    protected static final int BOTTOMSPACING = 7;
    protected T container;
    protected boolean close = false;

    public GuiAdvanced(Container container) {
        super(container);
    }

    public void func_73866_w_() {
        super.func_73866_w_();
        for (GuiPart guiPart : ((ContainerAdvanced)((Object)this.container)).parts) {
            guiPart.initGui(this.field_74198_m, this.field_74197_n);
        }
    }

    protected void func_74185_a(float f, int x, int y) {
        this.drawTopBorder();
        this.drawBottomBorder();
        for (GuiPart guiPart : ((ContainerAdvanced)((Object)this.container)).parts) {
            guiPart.drawBackgroundLayer(f, x, y);
        }
    }

    protected void func_73875_a(GuiButton guiButton) {
        for (GuiPart guiPart : ((ContainerAdvanced)((Object)this.container)).parts) {
            guiPart.actionPerformed(guiButton);
        }
    }

    protected void func_73864_a(int x, int y, int button) {
        super.func_73864_a(x, y, button);
        for (GuiPart guiPart : ((ContainerAdvanced)((Object)this.container)).parts) {
            if (!(guiPart instanceof GuiPartScrolling)) continue;
            ((GuiPartScrolling)guiPart).mouseClicked(x, y);
        }
    }

    protected void func_85041_a(int x, int y, int button, long timeSinceClicked) {
        super.func_85041_a(x, y, button, timeSinceClicked);
        for (GuiPart guiPart : ((ContainerAdvanced)((Object)this.container)).parts) {
            if (!(guiPart instanceof GuiPartScrolling)) continue;
            ((GuiPartScrolling)guiPart).mouseClickMove(x, y);
        }
    }

    protected void func_73879_b(int x, int y, int button) {
        super.func_73879_b(x, y, button);
        for (GuiPart guiPart : ((ContainerAdvanced)((Object)this.container)).parts) {
            if (!(guiPart instanceof GuiPartScrolling)) continue;
            ((GuiPartScrolling)guiPart).mouseReleased(x, y);
        }
    }

    public void func_73867_d() {
        super.func_73867_d();
        int mouseX = Mouse.getEventX() * this.field_73880_f / this.field_73882_e.field_71443_c;
        int mouseY = this.field_73881_g - Mouse.getEventY() * this.field_73881_g / this.field_73882_e.field_71440_d - 1;
        int mouseWheelDirection = Mouse.getEventDWheel();
        if (mouseWheelDirection > 0) {
            mouseWheelDirection = 1;
        }
        if (mouseWheelDirection < 0) {
            mouseWheelDirection = -1;
        }
        for (GuiPart guiPart : ((ContainerAdvanced)((Object)this.container)).parts) {
            if (!(guiPart instanceof GuiPartScrolling)) continue;
            if (ConfigurationBackpack.NEISupport) {
                if (!((GuiPartScrolling)guiPart).getScrollbar().isInRectangle(mouseX, mouseY)) continue;
                ((GuiPartScrolling)guiPart).mouseScrollWheel(mouseWheelDirection);
                continue;
            }
            if (!guiPart.isInRactangle(mouseX, mouseY)) continue;
            ((GuiPartScrolling)guiPart).mouseScrollWheel(mouseWheelDirection);
        }
    }

    protected void func_73869_a(char charTyped, int keyCode) {
        super.func_73869_a(charTyped, keyCode);
        if (keyCode == KeyHandlerBackpack.openBackpack.field_74512_d) {
            PacketHandlerBackpack.sendGuiOpenCloseToServer(3);
            this.close = true;
        }
    }

    protected void drawTopBorder() {
        GL11.glColor4f((float)1.0f, (float)1.0f, (float)1.0f, (float)1.0f);
        this.field_73882_e.func_110434_K().func_110577_a(Constants.guiCombined);
        this.func_73729_b(this.field_74198_m, this.field_74197_n, 0, 0, this.field_74194_b, 16);
    }

    protected void drawBottomBorder() {
        GL11.glColor4f((float)1.0f, (float)1.0f, (float)1.0f, (float)1.0f);
        this.field_73882_e.func_110434_K().func_110577_a(Constants.guiCombined);
        this.func_73729_b(this.field_74198_m, this.field_74197_n + this.field_74195_c - 7, 0, 160, this.field_74194_b, 7);
    }

    public List<GuiButton> getButtonList() {
        return this.field_73887_h;
    }

    public void closeGui() {
        if (this.close) {
            this.field_73882_e.field_71439_g.func_71053_j();
            this.close = false;
        }
    }
}

