/*
 * Decompiled with CFR 0.152.
 */
package backpack.handler;

import backpack.Backpack;
import backpack.inventory.InventoryBackpack;
import backpack.inventory.container.ContainerAdvanced;
import backpack.inventory.container.ContainerWorkbenchBackpack;
import backpack.item.ItemBackpackBase;
import backpack.item.ItemWorkbenchBackpack;
import backpack.item.Items;
import backpack.util.NBTUtil;
import com.google.common.io.ByteArrayDataInput;
import com.google.common.io.ByteStreams;
import cpw.mods.fml.common.FMLLog;
import cpw.mods.fml.common.network.IPacketHandler;
import cpw.mods.fml.common.network.PacketDispatcher;
import cpw.mods.fml.common.network.Player;
import java.io.ByteArrayOutputStream;
import java.io.DataOutputStream;
import java.io.IOException;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.inventory.Container;
import net.minecraft.item.ItemStack;
import net.minecraft.network.INetworkManager;
import net.minecraft.network.packet.Packet;
import net.minecraft.network.packet.Packet250CustomPayload;

public class PacketHandlerBackpack
implements IPacketHandler {
    public void onPacketData(INetworkManager manager, Packet250CustomPayload packet, Player playerObj) {
        ByteArrayDataInput reader = ByteStreams.newDataInput((byte[])packet.field_73629_c);
        EntityPlayer player = (EntityPlayer)playerObj;
        byte packetId = reader.readByte();
        switch (packetId) {
            case 0: {
                ItemStack is;
                String name = reader.readUTF().trim();
                if (player.func_71045_bC() == null || !((is = player.func_71045_bC()).func_77973_b() instanceof ItemBackpackBase)) break;
                InventoryBackpack inv = new InventoryBackpack(player, is);
                inv.setInvName(name);
                inv.saveInventory();
                break;
            }
            case 1: {
                ItemStack backpack;
                if (player.field_70170_p.field_72995_K || (backpack = Backpack.playerHandler.getBackpack(player)) == null) break;
                NBTUtil.setBoolean(backpack, "wornBackpackOpen", true);
                Backpack.playerHandler.setBackpack(player, backpack);
                if (backpack.field_77993_c == Items.backpack.field_77779_bT) {
                    player.openGui((Object)Backpack.instance, 2, null, 0, 0, 0);
                    break;
                }
                if (backpack.field_77993_c != Items.workbenchBackpack.field_77779_bT) break;
                player.openGui((Object)Backpack.instance, 4, null, 0, 0, 0);
                break;
            }
            case 2: {
                player.openGui((Object)Backpack.instance, 6, null, 0, 0, 0);
                break;
            }
            case 3: {
                player.field_71070_bA.func_75134_a(player);
                break;
            }
            case 4: {
                Container container;
                if (player.field_70170_p.field_72995_K || (container = player.field_71070_bA) == null || !(container instanceof ContainerAdvanced)) break;
                ((ContainerAdvanced)container).updateSlots(reader.readByte(), reader.readByte(), true);
                break;
            }
            case 5: {
                if (!player.field_70170_p.field_72995_K) break;
                int itemId = reader.readInt();
                ItemStack backpack = null;
                if (itemId > 0) {
                    backpack = new ItemStack(itemId, 1, reader.readInt());
                    NBTUtil.setString(backpack, "backpack-UID", reader.readUTF());
                    NBTUtil.setString(backpack, "Name", reader.readUTF());
                    if (backpack.func_77973_b() instanceof ItemWorkbenchBackpack) {
                        NBTUtil.setBoolean(backpack, "intelligent", reader.readBoolean());
                    }
                }
                Backpack.playerHandler.setClientBackpack(backpack);
                break;
            }
            case 6: {
                Container openContainer;
                if (player.field_70170_p.field_72995_K) break;
                String command = reader.readUTF();
                if (command.equals("clear")) {
                    Container openContainer2 = player.field_71070_bA;
                    if (!(openContainer2 instanceof ContainerWorkbenchBackpack)) break;
                    ((ContainerWorkbenchBackpack)openContainer2).clearCraftMatrix();
                    break;
                }
                if (!command.equals("save") || !((openContainer = player.field_71070_bA) instanceof ContainerWorkbenchBackpack)) break;
                ((ContainerWorkbenchBackpack)openContainer).setSaveMode();
            }
        }
    }

    public static void sendBackpackNameToServer(String name) {
        ByteArrayOutputStream byteStream = new ByteArrayOutputStream();
        DataOutputStream dataStream = new DataOutputStream(byteStream);
        try {
            dataStream.writeByte(0);
            dataStream.writeUTF(name.trim());
            PacketDispatcher.sendPacketToServer((Packet)PacketDispatcher.getPacket((String)"BackpackChannel", (byte[])byteStream.toByteArray()));
        }
        catch (IOException e) {
            FMLLog.warning((String)"[Backpack] Failed to send new backpack name to server.", (Object[])new Object[0]);
        }
    }

    public static void sendScrollbarPositionToServer(int guiPart, int position) {
        ByteArrayOutputStream byteStream = new ByteArrayOutputStream();
        DataOutputStream dataStream = new DataOutputStream(byteStream);
        try {
            dataStream.writeByte(4);
            dataStream.writeByte(guiPart);
            dataStream.writeByte(position);
            PacketDispatcher.sendPacketToServer((Packet)PacketDispatcher.getPacket((String)"BackpackChannel", (byte[])byteStream.toByteArray()));
        }
        catch (IOException e) {
            FMLLog.warning((String)"[Backpack] Failed to send scrollbar position to server.", (Object[])new Object[0]);
        }
    }

    public static void sendGuiOpenCloseToServer(int package_id) {
        ByteArrayOutputStream byteStream = new ByteArrayOutputStream();
        DataOutputStream dataStream = new DataOutputStream(byteStream);
        try {
            dataStream.writeByte(package_id);
            PacketDispatcher.sendPacketToServer((Packet)PacketDispatcher.getPacket((String)"BackpackChannel", (byte[])byteStream.toByteArray()));
        }
        catch (IOException e) {
            String message;
            switch (package_id) {
                case 1: {
                    message = "open backpack request";
                    break;
                }
                case 2: {
                    message = "open backpack slot request";
                    break;
                }
                case 3: {
                    message = "closing gui command";
                    break;
                }
                default: {
                    message = "package";
                }
            }
            FMLLog.warning((String)("[Backpack] Failed to send " + message + " to server."), (Object[])new Object[0]);
        }
    }

    public static void sendWornBackpackDataToClient(EntityPlayer player) {
        ByteArrayOutputStream byteStream = new ByteArrayOutputStream();
        DataOutputStream dataStream = new DataOutputStream(byteStream);
        try {
            dataStream.writeByte(5);
            ItemStack backpack = Backpack.playerHandler.getBackpack(player);
            if (backpack == null) {
                dataStream.writeInt(-1);
            } else {
                dataStream.writeInt(backpack.field_77993_c);
                dataStream.writeInt(backpack.func_77960_j());
                dataStream.writeUTF(NBTUtil.getString(backpack, "backpack-UID"));
                dataStream.writeUTF(NBTUtil.getString(backpack, "Name"));
                if (backpack.func_77973_b() instanceof ItemWorkbenchBackpack) {
                    dataStream.writeBoolean(NBTUtil.getBoolean(backpack, "intelligent"));
                }
            }
            PacketDispatcher.sendPacketToPlayer((Packet)PacketDispatcher.getPacket((String)"BackpackChannel", (byte[])byteStream.toByteArray()), (Player)((Player)player));
        }
        catch (IOException e) {
            FMLLog.warning((String)"[Backpack] Failed to send backpack data to client.", (Object[])new Object[0]);
        }
    }

    public static void sendGuiCommandToServer(String command) {
        ByteArrayOutputStream byteStream = new ByteArrayOutputStream();
        DataOutputStream dataStream = new DataOutputStream(byteStream);
        try {
            dataStream.writeByte(6);
            dataStream.writeUTF(command);
            PacketDispatcher.sendPacketToServer((Packet)PacketDispatcher.getPacket((String)"BackpackChannel", (byte[])byteStream.toByteArray()));
        }
        catch (IOException e) {
            FMLLog.warning((String)"[Backpack] Failed to send gui command to server.", (Object[])new Object[0]);
        }
    }
}

