/*
 * Decompiled with CFR 0.152.
 */
package backpack.inventory;

import backpack.Backpack;
import backpack.inventory.IInventoryBackpack;
import backpack.item.ItemBackpackBase;
import backpack.util.BackpackUtil;
import backpack.util.InventoryUtil;
import backpack.util.NBTUtil;
import java.util.UUID;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.inventory.InventoryBasic;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.NBTBase;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.nbt.NBTTagList;

public class InventoryBackpack
extends InventoryBasic
implements IInventoryBackpack {
    protected String field_70483_a;
    protected EntityPlayer playerEntity;
    protected ItemStack originalIS;
    protected boolean reading = false;

    public InventoryBackpack(EntityPlayer player, ItemStack is) {
        super("", false, BackpackUtil.getInventorySize(is));
        this.playerEntity = player;
        this.originalIS = is.func_77946_l();
        if (!this.hasInventory()) {
            this.createInventory();
            is.func_77982_d(this.originalIS.func_77978_p());
        }
        if (NBTUtil.hasTag(this.originalIS, "UID")) {
            NBTUtil.setString(this.originalIS, "backpack-UID", NBTUtil.getString(this.originalIS, "UID"));
            NBTUtil.removeTag(this.originalIS, "UID");
        }
        if (!NBTUtil.hasTag(this.originalIS, "backpack-UID") || NBTUtil.getString(this.originalIS, "backpack-UID").isEmpty()) {
            NBTUtil.setString(this.originalIS, "backpack-UID", UUID.randomUUID().toString());
        }
        this.loadInventory();
    }

    public void func_70296_d() {
        super.func_70296_d();
        if (!this.reading) {
            this.saveInventory();
        }
    }

    public void func_70295_k_() {
        this.loadInventory();
    }

    public void func_70305_f() {
        this.saveInventory();
    }

    public String func_70303_b() {
        return this.field_70483_a;
    }

    protected boolean hasInventory() {
        return NBTUtil.hasTag(this.originalIS, "Inventory");
    }

    protected void createInventory() {
        this.setInvName(this.originalIS.func_82833_r());
        NBTUtil.setString(this.originalIS, "backpack-UID", UUID.randomUUID().toString());
        this.writeToNBT();
    }

    public void setInvName(String name) {
        this.field_70483_a = name;
    }

    protected void setNBT() {
        if (!NBTUtil.getBoolean(this.originalIS, "wornBackpackOpen").booleanValue()) {
            ItemStack current = this.playerEntity.func_71045_bC();
            if (BackpackUtil.UUIDEquals(current, this.originalIS)) {
                current.func_77982_d(this.originalIS.func_77978_p());
                return;
            }
            for (ItemStack itemStack : this.playerEntity.field_71071_by.field_70462_a) {
                if (itemStack == null || !(itemStack.func_77973_b() instanceof ItemBackpackBase) || !BackpackUtil.UUIDEquals(itemStack, this.originalIS)) continue;
                itemStack.func_77982_d(this.originalIS.func_77978_p());
                break;
            }
        } else {
            Backpack.playerHandler.setBackpack(this.playerEntity, this.originalIS);
        }
    }

    public void loadInventory() {
        this.reading = true;
        this.readFromNBT();
        this.reading = false;
    }

    public void saveInventory() {
        this.writeToNBT();
        this.setNBT();
    }

    protected void writeToNBT() {
        NBTUtil.setString(this.originalIS, "Name", this.func_70303_b());
        NBTTagList itemList = new NBTTagList();
        for (int i = 0; i < this.func_70302_i_(); ++i) {
            if (this.func_70301_a(i) == null) continue;
            NBTTagCompound slotEntry = new NBTTagCompound();
            slotEntry.func_74774_a("Slot", (byte)i);
            this.func_70301_a(i).func_77955_b(slotEntry);
            itemList.func_74742_a((NBTBase)slotEntry);
        }
        NBTTagCompound inventory = new NBTTagCompound();
        inventory.func_74782_a("Items", (NBTBase)itemList);
        NBTUtil.setCompoundTag(this.originalIS, "Inventory", inventory);
    }

    protected void readFromNBT() {
        if (NBTUtil.hasTag(this.originalIS, "display")) {
            this.setInvName(NBTUtil.getCompoundTag(this.originalIS, "display").func_74779_i("Name"));
            NBTUtil.removeTag(this.originalIS, "display");
            NBTUtil.setString(this.originalIS, "Name", this.func_70303_b());
        } else {
            this.setInvName(NBTUtil.getString(this.originalIS, "Name"));
        }
        InventoryUtil.readInventory(this.field_70482_c, "Inventory", this.originalIS);
    }
}

