/*
 * Decompiled with CFR 0.152.
 */
package backpack.inventory.container;

import backpack.Backpack;
import backpack.gui.parts.GuiPart;
import backpack.handler.PacketHandlerBackpack;
import backpack.inventory.IInventoryBackpack;
import backpack.inventory.slot.SlotPhantom;
import backpack.inventory.slot.SlotScrolling;
import backpack.util.BackpackUtil;
import backpack.util.NBTUtil;
import cpw.mods.fml.relauncher.Side;
import cpw.mods.fml.relauncher.SideOnly;
import java.util.ArrayList;
import java.util.List;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.inventory.Container;
import net.minecraft.inventory.ICrafting;
import net.minecraft.inventory.IInventory;
import net.minecraft.inventory.InventoryBasic;
import net.minecraft.inventory.InventoryEnderChest;
import net.minecraft.inventory.Slot;
import net.minecraft.item.ItemStack;

public abstract class ContainerAdvanced
extends Container {
    protected final ItemStack openedBackpack;
    protected final IInventory lowerInventory;
    protected final IInventory upperInventory;
    public final int upperInventoryRows;
    public final int lowerInventoryRows;
    public ArrayList<GuiPart> parts = new ArrayList();

    public ContainerAdvanced(IInventory inventoryLower, IInventory inventoryUpper, ItemStack backpack) {
        if (inventoryLower != null) {
            this.lowerInventory = inventoryLower;
            this.lowerInventory.func_70295_k_();
            this.lowerInventoryRows = BackpackUtil.getInventoryRows(this.lowerInventory);
        } else {
            this.lowerInventory = new InventoryBasic("placebo", false, 128);
            this.lowerInventoryRows = 0;
        }
        if (inventoryUpper != null) {
            this.upperInventory = inventoryUpper;
            this.upperInventory.func_70295_k_();
            this.upperInventoryRows = BackpackUtil.getInventoryRows(this.upperInventory);
        } else {
            this.upperInventory = new InventoryBasic("placebo", false, 128);
            this.upperInventoryRows = 0;
        }
        this.openedBackpack = this.lowerInventory instanceof IInventoryBackpack || this.lowerInventory instanceof InventoryEnderChest ? backpack : (this.upperInventory instanceof IInventoryBackpack || this.upperInventory instanceof InventoryEnderChest ? backpack : null);
    }

    public boolean func_75145_c(EntityPlayer player) {
        ItemStack itemStack = null;
        if (this.openedBackpack != null && NBTUtil.getBoolean(this.openedBackpack, "wornBackpackOpen").booleanValue()) {
            itemStack = Backpack.playerHandler.getBackpack(player);
        } else if (player.func_71045_bC() != null) {
            itemStack = player.func_71045_bC();
        }
        return BackpackUtil.UUIDEquals(itemStack, this.openedBackpack) || BackpackUtil.isEnderBackpack(itemStack);
    }

    public void func_75134_a(EntityPlayer player) {
        ItemStack itemStack;
        super.func_75134_a(player);
        this.lowerInventory.func_70305_f();
        this.upperInventory.func_70305_f();
        if (!player.field_70170_p.field_72995_K && (itemStack = Backpack.playerHandler.getBackpack(player)) != null && NBTUtil.hasTag(itemStack, "wornBackpackOpen")) {
            NBTUtil.removeTag(itemStack, "wornBackpackOpen");
            Backpack.playerHandler.setBackpack(player, itemStack);
        }
    }

    protected boolean func_75135_a(ItemStack sourceStack, int firstSlot, int lastSlot, boolean backwards) {
        ItemStack slotStack;
        Slot slot;
        boolean result = false;
        int currentSlotIndex = firstSlot;
        if (backwards) {
            currentSlotIndex = lastSlot - 1;
        }
        if (sourceStack.func_77985_e()) {
            while (sourceStack.field_77994_a > 0 && (!backwards && currentSlotIndex < lastSlot || backwards && currentSlotIndex >= firstSlot)) {
                slot = (Slot)this.field_75151_b.get(currentSlotIndex);
                if (!(slot instanceof SlotScrolling && ((SlotScrolling)slot).isDisabled() || !slot.func_75214_a(sourceStack) || (slotStack = slot.func_75211_c()) == null || slotStack.field_77993_c != sourceStack.field_77993_c || sourceStack.func_77981_g() && sourceStack.func_77960_j() != slotStack.func_77960_j() || !ItemStack.func_77970_a((ItemStack)sourceStack, (ItemStack)slotStack))) {
                    int l = slotStack.field_77994_a + sourceStack.field_77994_a;
                    if (l <= sourceStack.func_77976_d()) {
                        sourceStack.field_77994_a = 0;
                        slotStack.field_77994_a = l;
                        slot.func_75218_e();
                        result = true;
                    } else if (slotStack.field_77994_a < sourceStack.func_77976_d()) {
                        sourceStack.field_77994_a -= sourceStack.func_77976_d() - slotStack.field_77994_a;
                        slotStack.field_77994_a = sourceStack.func_77976_d();
                        slot.func_75218_e();
                        result = true;
                    }
                }
                if (backwards) {
                    --currentSlotIndex;
                    continue;
                }
                ++currentSlotIndex;
            }
        }
        if (sourceStack.field_77994_a > 0) {
            currentSlotIndex = backwards ? lastSlot - 1 : firstSlot;
            while (!backwards && currentSlotIndex < lastSlot || backwards && currentSlotIndex >= firstSlot) {
                slot = (Slot)this.field_75151_b.get(currentSlotIndex);
                if (!(slot instanceof SlotScrolling && ((SlotScrolling)slot).isDisabled() || !slot.func_75214_a(sourceStack) || (slotStack = slot.func_75211_c()) != null)) {
                    slot.func_75215_d(sourceStack.func_77946_l());
                    slot.func_75218_e();
                    sourceStack.field_77994_a = 0;
                    result = true;
                    break;
                }
                if (backwards) {
                    --currentSlotIndex;
                    continue;
                }
                ++currentSlotIndex;
            }
        }
        return result;
    }

    public ItemStack func_75144_a(int slotIndex, int mouseButton, int modifier, EntityPlayer player) {
        Slot slot;
        Slot slot2 = slot = slotIndex < 0 ? null : (Slot)this.field_75151_b.get(slotIndex);
        if (slot instanceof SlotPhantom) {
            this.slotPhantomClick(slot, mouseButton, modifier, player.field_71071_by.func_70445_o());
            return null;
        }
        return super.func_75144_a(slotIndex, mouseButton, modifier, player);
    }

    protected void slotPhantomClick(Slot slot, int mouseButton, int modifier, ItemStack stackHeld) {
        if (((SlotPhantom)slot).canChangeStack()) {
            if (mouseButton == 2) {
                slot.func_75215_d(null);
            } else {
                ItemStack phantomStack = null;
                if (stackHeld != null) {
                    phantomStack = stackHeld.func_77946_l();
                    phantomStack.field_77994_a = 1;
                }
                slot.func_75215_d(phantomStack);
            }
            slot.func_75218_e();
        }
    }

    public void addSlot(Slot slot) {
        this.func_75146_a(slot);
    }

    public List<ICrafting> getCrafters() {
        return this.field_75149_d;
    }

    @SideOnly(value=Side.CLIENT)
    public void sendScrollbarToServer(GuiPart guiPart, int offset) {
        for (int i = 0; i < this.parts.size(); ++i) {
            if (this.parts.get(i) != guiPart) continue;
            PacketHandlerBackpack.sendScrollbarPositionToServer(i, offset);
            this.updateSlots(i, offset, false);
            break;
        }
    }

    public void updateSlots(int guiPartIndex, int offset, boolean isServer) {
        int slotNumber = this.parts.get((int)guiPartIndex).firstSlot;
        int inventoryRows = this.parts.get((int)guiPartIndex).inventoryRows;
        int inventoryCols = this.parts.get((int)guiPartIndex).inventoryCols;
        for (int row = 0; row < inventoryRows; ++row) {
            for (int col = 0; col < inventoryCols; ++col) {
                int slotIndex = col + (row + offset) * inventoryCols;
                SlotScrolling slot = (SlotScrolling)((Object)this.field_75151_b.get(slotNumber));
                if (slotIndex < slot.field_75224_c.func_70302_i_()) {
                    if (isServer) {
                        slot.setSlotIndex(slotIndex);
                    }
                    slot.setDisabled(false);
                } else {
                    slot.setDisabled(true);
                }
                ++slotNumber;
            }
        }
        if (isServer) {
            this.func_75142_b();
        }
    }

    public int calculatePartHeight() {
        int height = 0;
        for (GuiPart guiPart : this.parts) {
            height += guiPart.ySize;
        }
        return height;
    }
}

