/*
 * Decompiled with CFR 0.152.
 */
package backpack.inventory.container;

import backpack.gui.parts.GuiPart;
import backpack.gui.parts.GuiPartBackpack;
import backpack.gui.parts.GuiPartPlayerInventory;
import backpack.gui.parts.GuiPartWorkbench;
import backpack.inventory.InventoryCraftingAdvanced;
import backpack.inventory.InventoryRecipes;
import backpack.inventory.container.ContainerAdvanced;
import backpack.inventory.slot.SlotPhantom;
import backpack.item.ItemBackpackBase;
import backpack.util.NBTUtil;
import cpw.mods.fml.common.FMLCommonHandler;
import cpw.mods.fml.relauncher.Side;
import invtweaks.api.container.ChestContainer;
import invtweaks.api.container.ContainerSection;
import invtweaks.api.container.ContainerSectionCallback;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.entity.player.InventoryPlayer;
import net.minecraft.inventory.IInventory;
import net.minecraft.inventory.InventoryCraftResult;
import net.minecraft.inventory.InventoryCrafting;
import net.minecraft.inventory.Slot;
import net.minecraft.item.ItemStack;
import net.minecraft.item.crafting.CraftingManager;
import net.minecraft.world.World;

@ChestContainer
public class ContainerWorkbenchBackpack
extends ContainerAdvanced {
    public InventoryRecipes recipes = null;
    public InventoryCraftingAdvanced craftMatrix = null;
    public IInventory craftResult = new InventoryCraftResult();
    private World worldObj;
    public boolean intelligent = false;
    public boolean saveMode = false;

    public ContainerWorkbenchBackpack(InventoryPlayer playerInventory, IInventory backpackInventory, ItemStack backpackIS) {
        super((IInventory)playerInventory, backpackInventory, backpackIS);
        this.worldObj = ((InventoryPlayer)this.lowerInventory).field_70458_d.field_70170_p;
        this.craftMatrix = new InventoryCraftingAdvanced(this, this.upperInventory);
        this.craftMatrix.loadContent();
        if (backpackIS != null && NBTUtil.hasTag(backpackIS, "intelligent")) {
            this.intelligent = true;
            this.recipes = new InventoryRecipes(this.upperInventory);
        }
        GuiPartWorkbench workbench = new GuiPartWorkbench((ContainerAdvanced)this, this.upperInventory, (InventoryPlayer)this.lowerInventory);
        GuiPartBackpack backpack = new GuiPartBackpack((ContainerAdvanced)this, this.upperInventory, this.upperInventoryRows, false);
        GuiPartPlayerInventory player = new GuiPartPlayerInventory((ContainerAdvanced)this, this.lowerInventory, false);
        GuiPartPlayerInventory hotbar = new GuiPartPlayerInventory((ContainerAdvanced)this, this.lowerInventory, true);
        backpack.setSpacings(6, 0);
        player.setSpacings(13, 6);
        int offset = 16;
        workbench.setOffsetY(offset);
        backpack.setOffsetY(offset += workbench.ySize);
        player.setOffsetY(offset += backpack.ySize);
        hotbar.setOffsetY(offset += player.ySize);
        ((GuiPart)workbench).addSlots();
        ((GuiPart)player).addSlots();
        ((GuiPart)hotbar).addSlots();
        ((GuiPart)backpack).addSlots();
        this.parts.add(workbench);
        this.parts.add(backpack);
        this.parts.add(player);
        this.parts.add(hotbar);
        this.func_75130_a((IInventory)this.craftMatrix);
    }

    @Override
    public ItemStack func_75144_a(int slotIndex, int mouseButton, int modifier, EntityPlayer player) {
        Slot slot;
        Slot slot2 = slot = slotIndex < 0 ? null : (Slot)this.field_75151_b.get(slotIndex);
        if (slot instanceof SlotPhantom) {
            if (slot.field_75224_c == this.recipes) {
                if (FMLCommonHandler.instance().getEffectiveSide() == Side.SERVER) {
                    if (this.saveMode) {
                        this.saveMode = false;
                        if (this.func_75139_a(0).func_75211_c() != null) {
                            this.recipes.func_70299_a(slotIndex - 10, this.func_75139_a(0).func_75211_c().func_77946_l());
                            this.func_75142_b();
                        }
                    } else {
                        this.craftMatrix.loadRecipe(slotIndex - 10);
                    }
                }
            } else {
                this.slotPhantomClick(slot, mouseButton, modifier, player.field_71071_by.func_70445_o());
            }
            return null;
        }
        return super.func_75144_a(slotIndex, mouseButton, modifier, player);
    }

    public void func_75130_a(IInventory par1IInventory) {
        this.craftResult.func_70299_a(0, CraftingManager.func_77594_a().func_82787_a((InventoryCrafting)this.craftMatrix, this.worldObj));
        this.func_75142_b();
    }

    public ItemStack func_82846_b(EntityPlayer par1EntityPlayer, int slotPos) {
        ItemStack returnStack = null;
        Slot slot = (Slot)this.field_75151_b.get(slotPos);
        if (slot != null && slot.func_75216_d()) {
            ItemStack itemStack = slot.func_75211_c();
            returnStack = itemStack.func_77946_l();
            if (slotPos == 0) {
                if (!(this.mergeItemStackWithBackpack(itemStack) || this.func_75135_a(itemStack, 37, 46, true) || this.func_75135_a(itemStack, 10, 37, false))) {
                    return null;
                }
                slot.func_75220_a(itemStack, returnStack);
            } else {
                if (slotPos >= 1 && slotPos < 10) {
                    return null;
                }
                if (slotPos >= ((GuiPart)this.parts.get((int)2)).firstSlot && slotPos < ((GuiPart)this.parts.get((int)2)).lastSlot ? !this.mergeItemStackWithBackpack(itemStack) && !this.func_75135_a(itemStack, ((GuiPart)this.parts.get((int)3)).firstSlot, ((GuiPart)this.parts.get((int)3)).lastSlot, true) : (slotPos >= ((GuiPart)this.parts.get((int)3)).firstSlot && slotPos < ((GuiPart)this.parts.get((int)3)).lastSlot ? !this.mergeItemStackWithBackpack(itemStack) && !this.func_75135_a(itemStack, ((GuiPart)this.parts.get((int)2)).firstSlot, ((GuiPart)this.parts.get((int)2)).lastSlot, false) : (this.upperInventoryRows > 0 && slotPos >= ((GuiPart)this.parts.get((int)1)).firstSlot && slotPos < ((GuiPart)this.parts.get((int)1)).lastSlot ? !this.func_75135_a(itemStack, ((GuiPart)this.parts.get((int)3)).firstSlot, ((GuiPart)this.parts.get((int)3)).lastSlot, true) && !this.func_75135_a(itemStack, ((GuiPart)this.parts.get((int)2)).firstSlot, ((GuiPart)this.parts.get((int)2)).lastSlot, false) : !this.func_75135_a(itemStack, 10, 45, false)))) {
                    return null;
                }
            }
            if (itemStack.field_77994_a == 0) {
                slot.func_75215_d((ItemStack)null);
            } else {
                slot.func_75218_e();
            }
            if (itemStack.field_77994_a == returnStack.field_77994_a) {
                return null;
            }
            slot.func_82870_a(par1EntityPlayer, itemStack);
        }
        return returnStack;
    }

    protected boolean mergeItemStackWithBackpack(ItemStack itemStack) {
        if (this.upperInventoryRows > 0 && !(itemStack.func_77973_b() instanceof ItemBackpackBase)) {
            return this.func_75135_a(itemStack, ((GuiPart)this.parts.get((int)1)).firstSlot, ((GuiPart)this.parts.get((int)1)).lastSlot, false);
        }
        return false;
    }

    @ContainerSectionCallback
    public Map<ContainerSection, List<Slot>> getContainerSections() {
        HashMap<ContainerSection, List<Slot>> slotRefs = new HashMap<ContainerSection, List<Slot>>();
        slotRefs.put(ContainerSection.CRAFTING_OUT, this.field_75151_b.subList(0, 1));
        slotRefs.put(ContainerSection.CRAFTING_IN_PERSISTENT, this.field_75151_b.subList(1, 10));
        slotRefs.put(ContainerSection.INVENTORY, this.field_75151_b.subList(((GuiPart)this.parts.get((int)2)).firstSlot, ((GuiPart)this.parts.get((int)3)).lastSlot));
        slotRefs.put(ContainerSection.INVENTORY_NOT_HOTBAR, this.field_75151_b.subList(((GuiPart)this.parts.get((int)2)).firstSlot, ((GuiPart)this.parts.get((int)2)).lastSlot));
        slotRefs.put(ContainerSection.INVENTORY_HOTBAR, this.field_75151_b.subList(((GuiPart)this.parts.get((int)3)).firstSlot, ((GuiPart)this.parts.get((int)3)).lastSlot));
        if (this.upperInventoryRows > 0) {
            slotRefs.put(ContainerSection.CHEST, this.field_75151_b.subList(((GuiPart)this.parts.get((int)1)).firstSlot, ((GuiPart)this.parts.get((int)1)).lastSlot));
        }
        return slotRefs;
    }

    public boolean func_94530_a(ItemStack par1ItemStack, Slot par2Slot) {
        return par2Slot.field_75224_c != this.craftResult && super.func_94530_a(par1ItemStack, par2Slot);
    }

    public void clearCraftMatrix() {
        for (int i = 1; i < 10; ++i) {
            this.func_75141_a(i, null);
        }
    }

    public void setSaveMode() {
        Slot slot = this.func_75139_a(0);
        if (slot.func_75216_d()) {
            this.saveMode = true;
        }
    }
}

