/*
 * Decompiled with CFR 0.152.
 */
package backpack.nei;

import backpack.inventory.InventoryWorkbenchBackpack;
import backpack.util.InventoryUtil;
import codechicken.nei.FastTransferManager;
import codechicken.nei.PositionedStack;
import codechicken.nei.recipe.DefaultOverlayHandler;
import codechicken.nei.recipe.IRecipeHandler;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.LinkedList;
import java.util.List;
import net.minecraft.client.gui.inventory.GuiContainer;
import net.minecraft.entity.player.InventoryPlayer;
import net.minecraft.inventory.Slot;
import net.minecraft.item.ItemStack;

public class OverlayHandlerBackpack
extends DefaultOverlayHandler {
    public void overlayRecipe(GuiContainer gui, IRecipeHandler recipe, int recipeIndex, boolean shift) {
        List ingredients = recipe.getIngredientStacks(recipeIndex);
        List<DefaultOverlayHandler.DistributedIngred> ingredStacks = this.getPermutationIngredients(ingredients);
        this.findInventoryQuantities(gui, ingredStacks);
        List<DefaultOverlayHandler.IngredientDistribution> assignedIngredients = this.assignIngredients(ingredients, ingredStacks);
        if (assignedIngredients == null) {
            return;
        }
        this.assignIngredSlots(gui, ingredients, assignedIngredients);
        int quantity = this.calculateRecipeQuantity(assignedIngredients);
        if (quantity != 0) {
            this.moveIngredients(gui, assignedIngredients, quantity);
        }
    }

    private List<DefaultOverlayHandler.DistributedIngred> getPermutationIngredients(List<PositionedStack> ingredients) {
        ArrayList<DefaultOverlayHandler.DistributedIngred> ingredStacks = new ArrayList<DefaultOverlayHandler.DistributedIngred>();
        for (PositionedStack posstack : ingredients) {
            for (ItemStack pstack : posstack.items) {
                DefaultOverlayHandler.DistributedIngred istack = this.findIngred(ingredStacks, pstack);
                if (istack == null) {
                    istack = new DefaultOverlayHandler.DistributedIngred(pstack);
                    ingredStacks.add(istack);
                }
                istack.recipeAmount += pstack.field_77994_a;
            }
        }
        return ingredStacks;
    }

    private List<DefaultOverlayHandler.IngredientDistribution> assignIngredients(List<PositionedStack> ingredients, List<DefaultOverlayHandler.DistributedIngred> ingredStacks) {
        ArrayList<DefaultOverlayHandler.IngredientDistribution> assignedIngredients = new ArrayList<DefaultOverlayHandler.IngredientDistribution>();
        for (PositionedStack posstack : ingredients) {
            DefaultOverlayHandler.DistributedIngred biggestIngred = null;
            ItemStack permutation = null;
            int biggestSize = 0;
            block1: for (ItemStack pstack : posstack.items) {
                for (int j = 0; j < ingredStacks.size(); ++j) {
                    int relsize;
                    DefaultOverlayHandler.DistributedIngred istack = ingredStacks.get(j);
                    if (!InventoryUtil.canStack(pstack, istack.stack) || istack.invAmount - istack.distributed < pstack.field_77994_a || (relsize = (istack.invAmount - istack.invAmount / istack.recipeAmount * istack.distributed) / pstack.field_77994_a) <= biggestSize) continue;
                    biggestSize = relsize;
                    biggestIngred = istack;
                    permutation = pstack;
                    continue block1;
                }
            }
            if (biggestIngred == null) {
                return null;
            }
            biggestIngred.distributed += permutation.field_77994_a;
            assignedIngredients.add(new DefaultOverlayHandler.IngredientDistribution(biggestIngred, permutation));
        }
        return assignedIngredients;
    }

    private Slot[][] assignIngredSlots(GuiContainer gui, List<PositionedStack> ingredients, List<DefaultOverlayHandler.IngredientDistribution> assignedIngredients) {
        Slot[][] recipeSlots = this.mapIngredSlots(gui, ingredients);
        HashMap<Slot, Integer> distribution = new HashMap<Slot, Integer>();
        for (int i = 0; i < recipeSlots.length; ++i) {
            for (Slot slot : recipeSlots[i]) {
                if (distribution.containsKey(slot)) continue;
                distribution.put(slot, -1);
            }
        }
        HashSet avaliableSlots = new HashSet(distribution.keySet());
        HashSet<Integer> remainingIngreds = new HashSet<Integer>();
        ArrayList assignedSlots = new ArrayList();
        for (int i = 0; i < ingredients.size(); ++i) {
            remainingIngreds.add(i);
            assignedSlots.add(new LinkedList());
        }
        while (avaliableSlots.size() > 0 && remainingIngreds.size() > 0) {
            Iterator iterator = remainingIngreds.iterator();
            while (iterator.hasNext()) {
                int i = (Integer)iterator.next();
                boolean assigned = false;
                DefaultOverlayHandler.DistributedIngred istack = assignedIngredients.get((int)i).distrib;
                for (Slot slot : recipeSlots[i]) {
                    if (!avaliableSlots.contains(slot)) continue;
                    avaliableSlots.remove(slot);
                    if (slot.func_75216_d()) continue;
                    ++istack.numSlots;
                    ((LinkedList)assignedSlots.get(i)).add(slot);
                    assigned = true;
                    break;
                }
                if (assigned && istack.numSlots * istack.stack.func_77976_d() < istack.invAmount) continue;
                iterator.remove();
            }
        }
        for (int i = 0; i < ingredients.size(); ++i) {
            assignedIngredients.get((int)i).slots = ((LinkedList)assignedSlots.get(i)).toArray(new Slot[0]);
        }
        return recipeSlots;
    }

    private int calculateRecipeQuantity(List<DefaultOverlayHandler.IngredientDistribution> assignedIngredients) {
        int quantity = Integer.MAX_VALUE;
        for (DefaultOverlayHandler.IngredientDistribution distrib : assignedIngredients) {
            DefaultOverlayHandler.DistributedIngred istack = distrib.distrib;
            if (istack.numSlots == 0) {
                return 0;
            }
            int allSlots = istack.invAmount;
            if (allSlots / istack.numSlots > istack.stack.func_77976_d()) {
                allSlots = istack.numSlots * istack.stack.func_77976_d();
            }
            quantity = Math.min(quantity, allSlots / istack.distributed);
        }
        return quantity;
    }

    private void moveIngredients(GuiContainer gui, List<DefaultOverlayHandler.IngredientDistribution> assignedIngredients, int quantity) {
        block0: for (DefaultOverlayHandler.IngredientDistribution distrib : assignedIngredients) {
            ItemStack pstack = distrib.permutation;
            int transferCap = quantity * pstack.field_77994_a;
            int transferred = 0;
            int destSlotIndex = 0;
            Slot dest = distrib.slots[0];
            int slotTransferred = 0;
            int slotTransferCap = pstack.func_77976_d();
            for (Slot slot : gui.field_74193_d.field_75151_b) {
                ItemStack stack;
                if (!slot.func_75216_d() || !(slot.field_75224_c instanceof InventoryPlayer) && !(slot.field_75224_c instanceof InventoryWorkbenchBackpack) || !InventoryUtil.canStack(stack = slot.func_75211_c(), pstack)) continue;
                FastTransferManager.clickSlot((GuiContainer)gui, (int)slot.field_75222_d);
                int amount = Math.min(transferCap - transferred, stack.field_77994_a);
                for (int c = 0; c < amount; ++c) {
                    FastTransferManager.clickSlot((GuiContainer)gui, (int)dest.field_75222_d, (int)1);
                    ++transferred;
                    if (++slotTransferred < slotTransferCap) continue;
                    if (++destSlotIndex == distrib.slots.length) {
                        dest = null;
                        break;
                    }
                    dest = distrib.slots[destSlotIndex];
                    slotTransferred = 0;
                }
                FastTransferManager.clickSlot((GuiContainer)gui, (int)slot.field_75222_d);
                if (transferred < transferCap && dest != null) continue;
                continue block0;
            }
        }
    }

    private void findInventoryQuantities(GuiContainer gui, List<DefaultOverlayHandler.DistributedIngred> ingredStacks) {
        for (Slot slot : gui.field_74193_d.field_75151_b) {
            ItemStack pstack;
            DefaultOverlayHandler.DistributedIngred istack;
            if (!slot.func_75216_d() || !(slot.field_75224_c instanceof InventoryPlayer) && !(slot.field_75224_c instanceof InventoryWorkbenchBackpack) || (istack = this.findIngred(ingredStacks, pstack = slot.func_75211_c())) == null) continue;
            istack.invAmount += pstack.field_77994_a;
        }
    }
}

