/*
 * Decompiled with CFR 0.152.
 */
package backpack.proxy;

import backpack.Backpack;
import backpack.gui.GuiBackpack;
import backpack.gui.GuiBackpackAlt;
import backpack.gui.GuiBackpackCombined;
import backpack.gui.GuiBackpackSlot;
import backpack.gui.GuiWorkbenchBackpack;
import backpack.handler.EventHandlerRenderPlayer;
import backpack.handler.KeyHandlerBackpack;
import backpack.inventory.InventoryBackpackSlot;
import backpack.misc.ConfigurationBackpack;
import backpack.nei.OverlayHandlerBackpack;
import backpack.proxy.CommonProxy;
import backpack.util.BackpackUtil;
import cpw.mods.fml.client.registry.KeyBindingRegistry;
import cpw.mods.fml.common.FMLLog;
import java.lang.reflect.Method;
import net.minecraft.block.Block;
import net.minecraft.block.BlockChest;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.inventory.IInventory;
import net.minecraft.item.ItemStack;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.tileentity.TileEntityChest;
import net.minecraft.tileentity.TileEntityEnderChest;
import net.minecraft.world.World;
import net.minecraftforge.common.MinecraftForge;

public class ClientProxy
extends CommonProxy {
    @Override
    public Object getClientGuiElement(int ID, EntityPlayer player, World world, int x, int y, int z) {
        ItemStack backpack = ID % 2 == 0 ? Backpack.playerHandler.getClientBackpack() : player.func_71045_bC();
        Object inventory = BackpackUtil.getBackpackInv(backpack, player);
        switch (ID) {
            case 0: {
                return new GuiBackpackAlt();
            }
            case 1: 
            case 2: {
                return new GuiBackpack((IInventory)player.field_71071_by, (IInventory)inventory);
            }
            case 3: 
            case 4: {
                return new GuiWorkbenchBackpack(player.field_71071_by, (IInventory)inventory, backpack);
            }
            case 5: {
                int id;
                TileEntity te = world.func_72796_p(x, y, z);
                Object teInventory = te instanceof TileEntityEnderChest ? player.func_71005_bN() : (te instanceof TileEntityChest ? ((id = world.func_72798_a(x, y, z)) == Block.field_94347_ck.field_71990_ca ? ((BlockChest)Block.field_94347_ck).func_94442_h_(world, x, y, z) : Block.field_72077_au.func_94442_h_(world, x, y, z)) : (IInventory)te);
                return new GuiBackpackCombined((IInventory)player.field_71071_by, (IInventory)teInventory, (IInventory)inventory);
            }
            case 6: {
                inventory = new InventoryBackpackSlot();
                return new GuiBackpackSlot((IInventory)player.field_71071_by, (IInventory)inventory);
            }
        }
        return null;
    }

    @Override
    public void registerHandler() {
        super.registerHandler();
        KeyBindingRegistry.registerKeyBinding((KeyBindingRegistry.KeyHandler)new KeyHandlerBackpack());
        if (ConfigurationBackpack.RENDER_BACKPACK_MODEL) {
            MinecraftForge.EVENT_BUS.register((Object)new EventHandlerRenderPlayer());
        }
    }

    @Override
    public void addNeiSupport() {
        try {
            Class<?> API = Class.forName("codechicken.nei.api.API");
            Class<?> IOverlayHandler = Class.forName("codechicken.nei.api.IOverlayHandler");
            Method registerGuiOverlay = API.getDeclaredMethod("registerGuiOverlay", Class.class, String.class);
            Method registerGuiOverlayHandler = API.getDeclaredMethod("registerGuiOverlayHandler", Class.class, IOverlayHandler, String.class);
            registerGuiOverlay.invoke(API, GuiWorkbenchBackpack.class, "crafting");
            registerGuiOverlayHandler.invoke(API, new Object[]{GuiWorkbenchBackpack.class, new OverlayHandlerBackpack(), "crafting"});
            ConfigurationBackpack.NEISupport = true;
            FMLLog.info((String)"[Backpacks] NEI Support enabled", (Object[])new Object[0]);
        }
        catch (Exception e) {
            FMLLog.info((String)"[Backpacks] NEI Support couldn't be enabled", (Object[])new Object[0]);
        }
    }
}

