/*
 * Decompiled with CFR 0.152.
 */
package backpack.util;

import backpack.Backpack;
import backpack.inventory.InventoryBackpack;
import backpack.inventory.InventoryWorkbenchBackpack;
import backpack.item.ItemBackpack;
import backpack.item.ItemBackpackBase;
import backpack.item.ItemWorkbenchBackpack;
import backpack.misc.ConfigurationBackpack;
import backpack.util.NBTUtil;
import java.util.UUID;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.inventory.IInventory;
import net.minecraft.item.ItemStack;
import net.minecraftforge.oredict.OreDictionary;

public class BackpackUtil {
    public static IInventory getBackpackInv(EntityPlayer player, boolean worn) {
        ItemStack backpack = worn ? Backpack.playerHandler.getBackpack(player) : player.func_71045_bC();
        return BackpackUtil.getBackpackInv(backpack, player);
    }

    public static IInventory getBackpackInv(ItemStack backpack, EntityPlayer player) {
        if (backpack != null) {
            if (backpack.func_77973_b() instanceof ItemWorkbenchBackpack) {
                return new InventoryWorkbenchBackpack(player, backpack);
            }
            if (backpack.func_77973_b() instanceof ItemBackpack) {
                if (BackpackUtil.isEnderBackpack(backpack)) {
                    return player.func_71005_bN();
                }
                return new InventoryBackpack(player, backpack);
            }
        }
        return null;
    }

    public static int getInventorySize(ItemStack is) {
        if (is == null) {
            return -1;
        }
        if (is.func_77973_b() instanceof ItemBackpack) {
            return is.func_77960_j() > 17 ? ConfigurationBackpack.BACKPACK_SLOTS_L : ConfigurationBackpack.BACKPACK_SLOTS_S;
        }
        return 9 * (is.func_77960_j() == 18 ? 1 : 2);
    }

    public static int getInventoryRows(IInventory inventory) {
        return BackpackUtil.getInventoryRows(inventory, 9.0f);
    }

    public static int getInventoryRows(IInventory inventory, float cols) {
        return (int)Math.ceil((float)inventory.func_70302_i_() / cols);
    }

    public static boolean UUIDEquals(ItemStack suspicious, ItemStack original) {
        if (suspicious != null && original != null && NBTUtil.hasTag(suspicious, "backpack-UID") && NBTUtil.hasTag(original, "backpack-UID")) {
            try {
                UUID UIDsuspicious = UUID.fromString(NBTUtil.getString(suspicious, "backpack-UID"));
                UUID UIDoriginal = UUID.fromString(NBTUtil.getString(original, "backpack-UID"));
                return UIDsuspicious.equals(UIDoriginal);
            }
            catch (IllegalArgumentException e) {
                return false;
            }
        }
        return false;
    }

    public static boolean isEnderBackpack(ItemStack backpack) {
        return backpack != null && backpack.func_77973_b() instanceof ItemBackpackBase && backpack.func_77960_j() == 31999;
    }

    public static boolean areStacksEqual(ItemStack firstStack, ItemStack secondStack) {
        return BackpackUtil.areStacksEqual(firstStack, secondStack, false);
    }

    public static boolean areStacksEqual(ItemStack firstStack, ItemStack secondStack, boolean useOreDictionary) {
        if (firstStack == null || secondStack == null) {
            return false;
        }
        if (firstStack.func_77969_a(secondStack)) {
            return true;
        }
        if (!firstStack.func_77981_g() && !secondStack.func_77981_g() && firstStack.field_77993_c == secondStack.field_77993_c) {
            return true;
        }
        return useOreDictionary && BackpackUtil.areStacksEqualByOD(firstStack, secondStack);
    }

    public static boolean areStacksEqualByOD(ItemStack firstStack, ItemStack secondStack) {
        int oreIdSecond;
        if (firstStack == null || secondStack == null) {
            return false;
        }
        int oreIdFirst = OreDictionary.getOreID((ItemStack)firstStack);
        return oreIdFirst == (oreIdSecond = OreDictionary.getOreID((ItemStack)secondStack)) && oreIdFirst != -1;
    }
}

