/*
 * Decompiled with CFR 0.152.
 */
package backpack.gui.parts;

import backpack.gui.parts.GuiPart;
import backpack.inventory.container.ContainerAdvanced;
import cpw.mods.fml.relauncher.Side;
import cpw.mods.fml.relauncher.SideOnly;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.inventory.Container;
import net.minecraft.inventory.ICrafting;
import net.minecraft.inventory.IInventory;
import net.minecraft.inventory.Slot;
import net.minecraft.inventory.SlotFurnace;
import net.minecraft.tileentity.TileEntityFurnace;

public class GuiPartFurnace
extends GuiPart {
    private int lastCookTime;
    private int lastBurnTime;
    private int lastItemBurnTime;
    private TileEntityFurnace furnace;
    private EntityPlayer player;

    public GuiPartFurnace(ContainerAdvanced container, EntityPlayer player, IInventory inventory, int inventoryRows) {
        super(container, inventory, inventoryRows);
        this.ySize = 54;
        this.furnace = (TileEntityFurnace)inventory;
        this.player = player;
    }

    @Override
    public void addSlots() {
        int offset = this.offsetY + this.topSpacing + 1;
        this.firstSlot = this.container.field_75151_b.size();
        this.container.addSlot(new Slot(this.inventory, 0, 56, offset));
        this.container.addSlot(new Slot(this.inventory, 1, 56, offset + 36));
        this.container.addSlot((Slot)new SlotFurnace(this.player, this.inventory, 2, 116, offset + 18));
        this.lastSlot = this.container.field_75151_b.size();
    }

    @Override
    public void drawBackgroundLayer(float f, int x, int y) {
        int barWidth;
        super.drawBackgroundLayer(f, x, y);
        this.drawTexturedModalRect(this.guiLeft + 57, this.guiTop + 37, 0, 224, 13, 13);
        this.drawTexturedModalRect(this.guiLeft + 80, this.guiTop + 35, 0, 238, 22, 15);
        for (int i = this.firstSlot; i < this.lastSlot; ++i) {
            Slot slot = (Slot)this.container.field_75151_b.get(i);
            if (slot instanceof SlotFurnace) {
                this.drawTexturedModalRect(this.guiLeft + slot.field_75223_e - 5, this.guiTop + slot.field_75221_f - 5, 201, 18, 26, 26);
                continue;
            }
            this.drawTexturedModalRect(this.guiLeft + slot.field_75223_e - 1, this.guiTop + slot.field_75221_f - 1, 201, 0, 18, 18);
        }
        if (this.furnace.func_70400_i()) {
            barWidth = this.furnace.func_70403_d(12);
            this.drawTexturedModalRect(this.guiLeft + 57, this.guiTop + 48 - barWidth, 13, 236 - barWidth, 14, barWidth + 2);
        }
        barWidth = this.furnace.func_70397_c(24);
        this.drawTexturedModalRect(this.guiLeft + 80, this.guiTop + 34, 22, 238, barWidth, 16);
    }

    @Override
    public void addCraftingToCrafters(ICrafting player) {
        player.func_71112_a((Container)this.container, 0, this.furnace.field_70406_c);
        player.func_71112_a((Container)this.container, 1, this.furnace.field_70407_a);
        player.func_71112_a((Container)this.container, 2, this.furnace.field_70405_b);
    }

    @Override
    public void detectAndSendChanges() {
        for (int i = 0; i < this.container.getCrafters().size(); ++i) {
            ICrafting icrafting = this.container.getCrafters().get(i);
            if (this.lastCookTime != this.furnace.field_70406_c) {
                icrafting.func_71112_a((Container)this.container, 0, this.furnace.field_70406_c);
            }
            if (this.lastBurnTime != this.furnace.field_70407_a) {
                icrafting.func_71112_a((Container)this.container, 1, this.furnace.field_70407_a);
            }
            if (this.lastItemBurnTime == this.furnace.field_70405_b) continue;
            icrafting.func_71112_a((Container)this.container, 2, this.furnace.field_70405_b);
        }
        this.lastCookTime = this.furnace.field_70406_c;
        this.lastBurnTime = this.furnace.field_70407_a;
        this.lastItemBurnTime = this.furnace.field_70405_b;
    }

    @Override
    @SideOnly(value=Side.CLIENT)
    public void updateProgressBar(int id, int value) {
        if (id == 0) {
            this.furnace.field_70406_c = value;
        }
        if (id == 1) {
            this.furnace.field_70407_a = value;
        }
        if (id == 2) {
            this.furnace.field_70405_b = value;
        }
    }
}

