/*
 * Decompiled with CFR 0.152.
 */
package backpack.handler;

import backpack.handler.PacketHandlerBackpack;
import backpack.inventory.container.ContainerPickup;
import backpack.util.BackpackUtil;
import backpack.util.InventoryUtil;
import backpack.util.NBTUtil;
import backpack.util.PlayerSave;
import cpw.mods.fml.relauncher.Side;
import cpw.mods.fml.relauncher.SideOnly;
import java.io.File;
import java.util.UUID;
import java.util.concurrent.ConcurrentHashMap;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraftforge.common.DimensionManager;

public class PlayerHandlerBackpack {
    protected ConcurrentHashMap<String, PlayerSave> playerSaves = new ConcurrentHashMap();
    protected File worldSaveDir = null;
    protected ItemStack clientBackpack;

    public void loadPlayer(EntityPlayer player) {
        PlayerSave playerSave = this.getPlayerSave(player.field_71092_bJ);
        NBTTagCompound playerData = player.getEntityData();
        if (playerData.func_74764_b("backpack")) {
            ItemStack backpack = ItemStack.func_77949_a((NBTTagCompound)playerData.func_74775_l("backpack"));
            NBTUtil.setString(backpack, "backpack-UID", UUID.randomUUID().toString());
            playerSave.setWornBackpack(backpack);
            playerData.func_82580_o("backpack");
        }
        PacketHandlerBackpack.sendWornBackpackDataToClient(player);
    }

    public void unloadPlayer(EntityPlayer player) {
        this.savePlayer(player);
        this.playerSaves.remove(player.field_71092_bJ);
    }

    public void savePlayer(EntityPlayer player) {
        this.getPlayerSave(player.field_71092_bJ).save();
    }

    protected void saveAllPlayerData() {
        for (String username : this.playerSaves.keySet()) {
            this.playerSaves.remove(username).save(true);
        }
    }

    public ItemStack getBackpack(EntityPlayer player) {
        return this.getPlayerSave(player.field_71092_bJ).getWornBackpack();
    }

    public void setBackpack(EntityPlayer player, ItemStack backpack) {
        this.getPlayerSave(player.field_71092_bJ).setWornBackpack(backpack);
        this.savePlayer(player);
    }

    @SideOnly(value=Side.CLIENT)
    public ItemStack getClientBackpack() {
        return this.clientBackpack;
    }

    @SideOnly(value=Side.CLIENT)
    public void setClientBackpack(ItemStack backpack) {
        this.clientBackpack = backpack;
    }

    public String getLatestSeenVersion(EntityPlayer player) {
        return this.getPlayerSave(player.field_71092_bJ).getLatestSeenVersion();
    }

    public void setLatestSeenVersion(EntityPlayer player, String latestVersion) {
        this.getPlayerSave(player.field_71092_bJ).setLatestSeenVersion(latestVersion);
        this.savePlayer(player);
    }

    public void pickupItem(EntityPlayer player, ItemStack itemStack) {
        ItemStack backpack = this.getBackpack(player);
        if (backpack != null) {
            ItemStack[] inventory = new ItemStack[10];
            InventoryUtil.readInventory(inventory, "Pickups", backpack);
            for (int i = 1; i < inventory.length; ++i) {
                ItemStack pickupItemStack = inventory[i];
                if (!BackpackUtil.areStacksEqual(itemStack, pickupItemStack, true)) continue;
                NBTUtil.setBoolean(backpack, "wornBackpackOpen", true);
                ContainerPickup container = new ContainerPickup(BackpackUtil.getBackpackInv(backpack, player));
                container.pickupItem(itemStack);
                container.func_75134_a(player);
            }
        }
    }

    protected PlayerSave getPlayerSave(String username) {
        PlayerSave playerSave = this.playerSaves.get(username);
        if (playerSave == null) {
            playerSave = new PlayerSave(username, new File(this.getWorldSaveDir(), "backpacks/players"));
            this.playerSaves.put(username, playerSave);
        }
        return playerSave;
    }

    protected File getWorldSaveDir() {
        return DimensionManager.getCurrentSaveRootDirectory();
    }

    public void unloadWorld() {
        this.saveAllPlayerData();
        this.worldSaveDir = null;
    }
}

