/*
 * Decompiled with CFR 0.152.
 */
package de.eydamos.backpack.data;

import de.eydamos.backpack.Backpack;
import de.eydamos.backpack.misc.Constants;
import de.eydamos.backpack.util.GeneralUtil;
import de.eydamos.backpack.util.NBTUtil;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.inventory.IInventory;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.util.ChatComponentTranslation;
import net.minecraft.util.IChatComponent;
import net.minecraft.world.World;
import net.minecraft.world.WorldSavedData;
import net.minecraft.world.storage.MapStorage;

public class PlayerSave
extends WorldSavedData
implements IInventory {
    private EntityPlayer player;
    private ItemStack[] inventory;

    public PlayerSave() {
        super(Constants.PLAYERS_PATH + "DUMMY");
    }

    public PlayerSave(String name) {
        super(name);
    }

    public void func_76184_a(NBTTagCompound nbt) {
        this.inventory = new ItemStack[2];
        if (NBTUtil.hasTag(nbt, "backpack")) {
            NBTTagCompound backpack = NBTUtil.getCompoundTag(nbt, "backpack");
            this.inventory[0] = ItemStack.func_77949_a((NBTTagCompound)backpack);
        }
    }

    public void func_76187_b(NBTTagCompound nbt) {
        if (this.inventory != null && this.inventory[0] != null) {
            NBTTagCompound backpack = new NBTTagCompound();
            this.inventory[0].func_77955_b(backpack);
            NBTUtil.setCompoundTag(nbt, "backpack", backpack);
        }
    }

    private void initialize(EntityPlayer player) {
        this.player = player;
        if (this.inventory == null) {
            this.inventory = new ItemStack[2];
        }
    }

    public ItemStack getBackpack() {
        if (this.inventory != null) {
            return this.inventory[0];
        }
        return null;
    }

    public static PlayerSave loadPlayer(World world, EntityPlayer player) {
        String UUID = GeneralUtil.getPlayerUUID(player);
        MapStorage storage = world.func_175693_T();
        PlayerSave instance = (PlayerSave)storage.func_75742_a(PlayerSave.class, Constants.PLAYERS_PATH + UUID);
        if (instance == null) {
            instance = new PlayerSave(Constants.PLAYERS_PATH + UUID);
            storage.func_75745_a(Constants.PLAYERS_PATH + UUID, (WorldSavedData)instance);
        }
        instance.initialize(player);
        return instance;
    }

    public int func_70302_i_() {
        return this.inventory.length;
    }

    public ItemStack func_70301_a(int index) {
        if (this.inventory != null && index >= 0 && index < this.inventory.length) {
            return this.inventory[index];
        }
        return null;
    }

    public ItemStack func_70298_a(int index, int amount) {
        ItemStack itemstack = this.func_70301_a(index);
        if (itemstack != null) {
            if (itemstack.field_77994_a <= amount) {
                this.func_70299_a(index, null);
            } else {
                itemstack = itemstack.func_77979_a(amount);
                if (this.func_70301_a((int)index).field_77994_a == 0) {
                    this.func_70299_a(index, null);
                } else {
                    this.func_70296_d();
                }
            }
        }
        return itemstack;
    }

    public ItemStack func_70304_b(int index) {
        ItemStack itemstack = null;
        if (this.func_70301_a(index) != null) {
            itemstack = this.func_70301_a(index);
            this.func_70299_a(index, null);
        }
        return itemstack;
    }

    public void func_70299_a(int index, ItemStack newContent) {
        if (this.inventory != null && index >= 0 && index < this.inventory.length) {
            this.inventory[index] = newContent;
            if (newContent != null && newContent.field_77994_a > this.func_70297_j_()) {
                newContent.field_77994_a = this.func_70297_j_();
            }
            this.func_70296_d();
            if (index == 0 && GeneralUtil.isServerSide(this.player.field_70170_p)) {
                Backpack.packetHandler.propagateCarriedBackpack(this.player);
            }
        }
    }

    public int func_70297_j_() {
        return 64;
    }

    public boolean func_70300_a(EntityPlayer player) {
        return true;
    }

    public void func_174889_b(EntityPlayer player) {
    }

    public void func_174886_c(EntityPlayer player) {
    }

    public boolean func_94041_b(int index, ItemStack stack) {
        return true;
    }

    public int func_174887_a_(int id) {
        return 0;
    }

    public void func_174885_b(int id, int value) {
    }

    public int func_174890_g() {
        return 0;
    }

    public void func_174888_l() {
        if (this.inventory != null) {
            for (int i = 0; i < this.inventory.length; ++i) {
                this.inventory[i] = null;
            }
        }
    }

    public String func_70005_c_() {
        return "text.backpack.gui.title.special_slots";
    }

    public boolean func_145818_k_() {
        return false;
    }

    public IChatComponent func_145748_c_() {
        return new ChatComponentTranslation(this.func_70005_c_(), new Object[0]);
    }

    public void func_70296_d() {
        super.func_76185_a();
    }
}

