/*
 * Decompiled with CFR 0.152.
 */
package de.eydamos.backpack.tier;

import com.mojang.realmsclient.gui.ChatFormatting;
import de.eydamos.backpack.item.EFrame;
import de.eydamos.backpack.misc.BackpackItems;
import de.eydamos.backpack.util.NBTItemStackUtil;
import java.util.List;
import net.minecraft.item.Item;
import net.minecraft.item.ItemStack;
import net.minecraft.util.StatCollector;

public enum TierFrame {
    I(EFrame.WOOD.getDamage()),
    II(EFrame.STONE.getDamage()),
    III(EFrame.IRON.getDamage());

    private final Item item = BackpackItems.backpack_frame;
    private final int damage;

    private TierFrame(int damage) {
        this.damage = damage;
    }

    public Item getItem() {
        return this.item;
    }

    public int getDamage() {
        return this.damage;
    }

    public void setTier(ItemStack itemStack) {
        NBTItemStackUtil.setString(itemStack, "frame_tier", this.name());
    }

    public static TierFrame getTierByItemStack(ItemStack itemStack) {
        String tierName = NBTItemStackUtil.getString(itemStack, "frame_tier");
        if (!tierName.isEmpty()) {
            return TierFrame.valueOf(tierName);
        }
        Item item = itemStack.func_77973_b();
        for (TierFrame tier : TierFrame.values()) {
            if (tier.item != item || itemStack.func_77952_i() != tier.damage) continue;
            return tier;
        }
        return null;
    }

    public static void setTier(ItemStack target, ItemStack source) {
        TierFrame tier = TierFrame.getTierByItemStack(source);
        if (tier != null) {
            tier.setTier(target);
        }
    }

    public static boolean itemStackTierEquals(ItemStack itemStackA, ItemStack itemStackB) {
        TierFrame tierA = TierFrame.getTierByItemStack(itemStackA);
        TierFrame tierB = TierFrame.getTierByItemStack(itemStackB);
        return tierA != null && tierA.equals((Object)tierB);
    }

    public static void addTooltip(ItemStack itemStack, List<String> tooltip) {
        TierFrame tier = TierFrame.getTierByItemStack(itemStack);
        if (tier != null) {
            String label = ChatFormatting.BLUE + StatCollector.func_74838_a((String)"tooltip.tier_frame");
            String tierName = ChatFormatting.YELLOW + tier.name() + ChatFormatting.RESET;
            tooltip.add(label.trim() + ' ' + tierName);
        }
    }
}

