/*
 * Decompiled with CFR 0.152.
 */
package de.eydamos.backpack.handler;

import de.eydamos.backpack.data.PlayerSave;
import de.eydamos.backpack.misc.Constants;
import java.io.File;
import net.minecraft.entity.item.EntityItem;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.item.ItemStack;
import net.minecraftforge.common.DimensionManager;
import net.minecraftforge.event.entity.player.PlayerDropsEvent;
import net.minecraftforge.event.world.WorldEvent;
import net.minecraftforge.fml.common.FMLLog;
import net.minecraftforge.fml.common.eventhandler.SubscribeEvent;

public class HandlerCommonEvents {
    @SubscribeEvent
    public void onWorldLoad(WorldEvent.Load event) {
        try {
            File playersDir;
            File dataDir = new File(DimensionManager.getCurrentSaveRootDirectory(), "data");
            File backpackDir = new File(dataDir, Constants.INVENTORIES_PATH);
            if (!backpackDir.exists() && !backpackDir.mkdirs()) {
                FMLLog.warning((String)"Unable to create backpack/inventory folder. Saving backpack inventory will fail!", (Object[])new Object[0]);
            }
            if (!(playersDir = new File(dataDir, Constants.PLAYERS_PATH)).exists() && !playersDir.mkdirs()) {
                FMLLog.warning((String)"Unable to create backpack/player folder. Saving player specific backpack data will fail!", (Object[])new Object[0]);
            }
        }
        catch (Exception e) {
            FMLLog.info((String)"Unable to check if backpack folders are present. If you are a client connecting to a server ignore this info.", (Object[])new Object[0]);
        }
    }

    @SubscribeEvent
    public void playerDies(PlayerDropsEvent event) {
        EntityPlayer player = event.entityPlayer;
        PlayerSave playerSave = PlayerSave.loadPlayer(player.field_70170_p, player);
        ItemStack backpack = playerSave.getBackpack();
        if (backpack != null) {
            event.drops.add(new EntityItem(player.field_70170_p, player.field_70165_t, player.field_70163_u, player.field_70161_v, backpack));
            playerSave.func_70299_a(0, null);
        }
    }
}

