/*
 * Decompiled with CFR 0.152.
 */
package de.eydamos.backpack.recipe;

import de.eydamos.backpack.item.EBackpack;
import de.eydamos.backpack.misc.EItem;
import de.eydamos.backpack.recipe.AbstractRecipe;
import de.eydamos.backpack.recipe.ECategory;
import de.eydamos.backpack.recipe.RecipeBackpackBig;
import de.eydamos.backpack.recipe.RecipeBackpackMedium;
import de.eydamos.backpack.recipe.RecipeBackpackPieceBottom;
import de.eydamos.backpack.recipe.RecipeBackpackPieceMiddle;
import de.eydamos.backpack.recipe.RecipeBackpackPieceTop;
import de.eydamos.backpack.recipe.RecipeBackpackSmall;
import de.eydamos.backpack.recipe.RecipeRecolorBackpack;
import net.minecraft.init.Items;
import net.minecraft.item.ItemStack;
import net.minecraft.item.crafting.IRecipe;
import net.minecraftforge.fml.common.registry.GameRegistry;
import net.minecraftforge.oredict.ShapedOreRecipe;
import net.minecraftforge.oredict.ShapelessOreRecipe;

public enum ERecipe {
    STICK_STONE(EItem.STICK_STONE.getItemStack(4), ECategory.SHAPED_OREDICT, "S", "S", Character.valueOf('S'), "stone"),
    STICK_IRON(EItem.STICK_IRON.getItemStack(2), ECategory.SHAPED_OREDICT, "S", "S", Character.valueOf('S'), "ingotIron"),
    LEATHER_BOUND(EItem.BOUND_LEATHER.getItemStack(2), ECategory.SHAPED, "SSS", "LSL", "SSS", Character.valueOf('S'), Items.field_151007_F, Character.valueOf('L'), Items.field_151116_aA),
    LEATHER_TANNED(EItem.TANNED_LEATHER.getItemStack(1), ECategory.FURNACE, EItem.BOUND_LEATHER.getItemStack(1), Float.valueOf(0.1f)),
    FRAME_WOOD(EItem.FRAME_WOOD.getItemStack(1), ECategory.SHAPED, "WSW", "S S", "WSW", Character.valueOf('W'), Items.field_151055_y, Character.valueOf('S'), Items.field_151007_F),
    FRAME_WOOD2(EItem.FRAME_WOOD.getItemStack(1), ECategory.SHAPED, "SWS", "W W", "SWS", Character.valueOf('W'), Items.field_151055_y, Character.valueOf('S'), Items.field_151007_F),
    FRAME_STONE(EItem.FRAME_STONE.getItemStack(1), ECategory.SHAPED, "WSW", "S S", "WSW", Character.valueOf('W'), EItem.STICK_STONE.getItemStack(1), Character.valueOf('S'), Items.field_151007_F),
    FRAME_STONE2(EItem.FRAME_STONE.getItemStack(1), ECategory.SHAPED, "SWS", "W W", "SWS", Character.valueOf('W'), EItem.STICK_STONE.getItemStack(1), Character.valueOf('S'), Items.field_151007_F),
    FRAME_IRON(EItem.FRAME_IRON.getItemStack(1), ECategory.SHAPED, "WSW", "S S", "WSW", Character.valueOf('W'), EItem.STICK_IRON.getItemStack(1), Character.valueOf('S'), Items.field_151007_F),
    FRAME_IRON2(EItem.FRAME_IRON.getItemStack(1), ECategory.SHAPED, "SWS", "W W", "SWS", Character.valueOf('W'), EItem.STICK_IRON.getItemStack(1), Character.valueOf('S'), Items.field_151007_F),
    BACKPACK_PICE_TOP(null, ECategory.CUSTOM, new RecipeBackpackPieceTop(EItem.BACKPACK_PICE_TOP.getItemStack(1))),
    BACKPACK_PICE_MIDDLE(null, ECategory.CUSTOM, new RecipeBackpackPieceMiddle(EItem.BACKPACK_PICE_MIDDLE.getItemStack(1))),
    BACKPACK_PICE_BOTTOM(null, ECategory.CUSTOM, new RecipeBackpackPieceBottom(EItem.BACKPACK_PICE_BOTTOM.getItemStack(1))),
    BACKPACK_SMALL(null, ECategory.CUSTOM, new RecipeBackpackSmall(EBackpack.SMALL.getItemStack())),
    BACKPACK_MEDIUM(null, ECategory.CUSTOM, new RecipeBackpackMedium(EBackpack.MEDIUM.getItemStack())),
    BACKPACK_BIG(null, ECategory.CUSTOM, new RecipeBackpackBig(EBackpack.BIG.getItemStack())),
    RECOLOR_BACKPACK(null, ECategory.CUSTOM, new RecipeRecolorBackpack());

    protected ItemStack result;
    protected ECategory category;
    protected Object[] recipeDefinition;

    private ERecipe(ItemStack result, ECategory category, Object ... recipeDefinition) {
        this.result = result;
        this.category = category;
        this.recipeDefinition = recipeDefinition;
    }

    public void registerRecipe() {
        switch (this.category) {
            case SHAPED: {
                GameRegistry.addShapedRecipe((ItemStack)this.result, (Object[])this.recipeDefinition);
                break;
            }
            case SHAPED_OREDICT: {
                GameRegistry.addRecipe((IRecipe)new ShapedOreRecipe(this.result, this.recipeDefinition));
                break;
            }
            case SHAPELESS: {
                GameRegistry.addShapelessRecipe((ItemStack)this.result, (Object[])this.recipeDefinition);
                break;
            }
            case SHAPELESS_OREDICT: {
                GameRegistry.addRecipe((IRecipe)new ShapelessOreRecipe(this.result, this.recipeDefinition));
                break;
            }
            case FURNACE: {
                GameRegistry.addSmelting((ItemStack)((ItemStack)this.recipeDefinition[0]), (ItemStack)this.result, (float)((Float)this.recipeDefinition[1]).floatValue());
                break;
            }
            case CUSTOM: {
                AbstractRecipe recipe = (AbstractRecipe)this.recipeDefinition[0];
                GameRegistry.addRecipe((IRecipe)recipe);
                recipe.registerAtRecipeSorter();
            }
        }
    }

    public static void registerRecipes() {
        for (ERecipe recipe : ERecipe.values()) {
            recipe.registerRecipe();
        }
    }
}

