/*
 * Decompiled with CFR 0.152.
 */
package de.eydamos.backpack.data;

import de.eydamos.backpack.helper.BackpackHelper;
import de.eydamos.backpack.misc.Constants;
import java.util.Hashtable;
import java.util.Map;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.inventory.IInventory;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.NBTBase;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.nbt.NBTTagList;
import net.minecraft.util.text.ITextComponent;
import net.minecraft.util.text.TextComponentString;
import net.minecraft.util.text.TextComponentTranslation;
import net.minecraft.world.World;
import net.minecraft.world.WorldSavedData;
import net.minecraft.world.storage.MapStorage;

public class BackpackSave
extends WorldSavedData
implements IInventory {
    private ItemStack[] currentInventory;
    private Hashtable<String, ItemStack[]> inventories = new Hashtable();
    private ItemStack backpack;
    private boolean heldItem;
    private EntityPlayer player;

    public BackpackSave() {
        super(Constants.INVENTORIES_PATH + "DUMMY");
    }

    public BackpackSave(String name) {
        super(name);
    }

    public void func_76184_a(NBTTagCompound nbt) {
        for (String identifier : nbt.func_150296_c()) {
            NBTTagList inventoryList = nbt.func_150295_c(identifier, 10);
            ItemStack[] inventory = new ItemStack[inventoryList.func_74745_c()];
            for (int i = 0; i < inventoryList.func_74745_c(); ++i) {
                NBTTagCompound slotEntry = inventoryList.func_150305_b(i);
                int slot = slotEntry.func_74771_c("slot") & 0xFF;
                if (slot < 0 || slot >= inventory.length || !slotEntry.func_74764_b("id")) continue;
                inventory[slot] = ItemStack.func_77949_a((NBTTagCompound)slotEntry);
            }
            if (this.currentInventory == null) {
                this.currentInventory = inventory;
            }
            this.inventories.put(identifier, inventory);
        }
    }

    public NBTTagCompound func_189551_b(NBTTagCompound nbt) {
        for (Map.Entry<String, ItemStack[]> inventoryEntry : this.inventories.entrySet()) {
            String identifier = inventoryEntry.getKey();
            ItemStack[] inventory = inventoryEntry.getValue();
            NBTTagList inventoryList = new NBTTagList();
            for (int i = 0; i < inventory.length; ++i) {
                NBTTagCompound slotEntry = new NBTTagCompound();
                slotEntry.func_74774_a("slot", (byte)i);
                if (inventory[i] != null) {
                    inventory[i].func_77955_b(slotEntry);
                }
                inventoryList.func_74742_a((NBTBase)slotEntry);
            }
            nbt.func_74782_a(identifier, (NBTBase)inventoryList);
        }
        return nbt;
    }

    private void initialize(ItemStack backpack, EntityPlayer player, boolean heldItem) {
        this.backpack = backpack;
        this.player = player;
        this.heldItem = heldItem;
        if (this.currentInventory == null) {
            int slots = BackpackHelper.getSlots(backpack);
            ItemStack[] inventory = new ItemStack[slots];
            this.inventories.put("backpack", inventory);
            this.currentInventory = inventory;
        }
    }

    public static BackpackSave loadBackpack(World world, ItemStack backpack, EntityPlayer player, boolean heldItem) {
        String UUID = BackpackHelper.getUUID(backpack);
        MapStorage storage = world.func_175693_T();
        BackpackSave instance = (BackpackSave)storage.func_75742_a(BackpackSave.class, Constants.INVENTORIES_PATH + UUID);
        if (instance == null) {
            instance = new BackpackSave(Constants.INVENTORIES_PATH + UUID);
            storage.func_75745_a(Constants.INVENTORIES_PATH + UUID, (WorldSavedData)instance);
        }
        instance.initialize(backpack, player, heldItem);
        return instance;
    }

    public int func_70302_i_() {
        return this.currentInventory.length;
    }

    public ItemStack func_70301_a(int index) {
        if (this.currentInventory != null && index >= 0 && index < this.currentInventory.length) {
            return this.currentInventory[index];
        }
        return null;
    }

    public ItemStack func_70298_a(int index, int amount) {
        ItemStack itemstack = this.func_70301_a(index);
        if (itemstack != null) {
            if (itemstack.field_77994_a <= amount) {
                this.func_70299_a(index, null);
            } else {
                itemstack = itemstack.func_77979_a(amount);
                if (this.func_70301_a((int)index).field_77994_a == 0) {
                    this.func_70299_a(index, null);
                } else {
                    this.func_70296_d();
                }
            }
        }
        return itemstack;
    }

    public ItemStack func_70304_b(int index) {
        ItemStack itemstack = null;
        if (this.func_70301_a(index) != null) {
            itemstack = this.func_70301_a(index);
            this.func_70299_a(index, null);
        }
        return itemstack;
    }

    public void func_70299_a(int index, ItemStack newContent) {
        if (this.currentInventory != null && index >= 0 && index < this.currentInventory.length) {
            this.currentInventory[index] = newContent;
            if (newContent != null && newContent.field_77994_a > this.func_70297_j_()) {
                newContent.field_77994_a = this.func_70297_j_();
            }
            this.updateUsedSlots();
            this.func_70296_d();
        }
    }

    public int func_70297_j_() {
        return 64;
    }

    public boolean func_70300_a(EntityPlayer player) {
        return true;
    }

    public void func_174889_b(EntityPlayer player) {
    }

    public void func_174886_c(EntityPlayer player) {
    }

    public boolean func_94041_b(int index, ItemStack stack) {
        return true;
    }

    public int func_174887_a_(int id) {
        return 0;
    }

    public void func_174885_b(int id, int value) {
    }

    public int func_174890_g() {
        return 0;
    }

    public void func_174888_l() {
        if (this.currentInventory != null) {
            for (int i = 0; i < this.currentInventory.length; ++i) {
                this.currentInventory[i] = null;
            }
        }
    }

    public String func_70005_c_() {
        return this.func_145818_k_() ? this.backpack.func_82833_r() : this.backpack.func_77977_a() + ".name";
    }

    public boolean func_145818_k_() {
        return this.backpack.func_82837_s();
    }

    public ITextComponent func_145748_c_() {
        Object component = this.func_145818_k_() ? new TextComponentString(this.backpack.func_82833_r()) : new TextComponentTranslation(this.backpack.func_77977_a(), new Object[0]);
        return component;
    }

    public void func_70296_d() {
        super.func_76185_a();
    }

    private void updateUsedSlots() {
        int slotsUsed = 0;
        for (ItemStack itemStack : this.currentInventory) {
            if (itemStack == null) continue;
            ++slotsUsed;
        }
        BackpackHelper.setSlotsUsed(BackpackHelper.getBackpackFromPlayer(this.player, this.heldItem), slotsUsed);
    }
}

