/*
 * Decompiled with CFR 0.152.
 */
package de.eydamos.backpack.network.message;

import de.eydamos.backpack.Backpack;
import de.eydamos.backpack.helper.BackpackHelper;
import de.eydamos.backpack.misc.BackpackItems;
import de.eydamos.backpack.util.GeneralUtil;
import de.eydamos.backpack.util.NBTItemStackUtil;
import io.netty.buffer.ByteBuf;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.item.ItemStack;
import net.minecraftforge.fml.common.network.ByteBufUtils;
import net.minecraftforge.fml.common.network.simpleimpl.IMessage;
import net.minecraftforge.fml.common.network.simpleimpl.IMessageHandler;
import net.minecraftforge.fml.common.network.simpleimpl.MessageContext;

public class MessageBackpackData
implements IMessage,
IMessageHandler<MessageBackpackData, IMessage> {
    private int slots;
    private int slotsPerRow;
    private int damage;
    private String playerUUID;
    private String backpackUUID;
    private String customName;

    public MessageBackpackData() {
    }

    public MessageBackpackData(EntityPlayer player, ItemStack itemStack) {
        this.slots = BackpackHelper.getSlots(itemStack);
        this.slotsPerRow = BackpackHelper.getSlotsPerRow(itemStack);
        this.damage = itemStack != null ? itemStack.func_77952_i() : -1;
        this.playerUUID = GeneralUtil.getPlayerUUID(player);
        this.backpackUUID = BackpackHelper.getUUID(itemStack);
        this.customName = itemStack != null && itemStack.func_82837_s() ? itemStack.func_82833_r() : "";
    }

    public void fromBytes(ByteBuf buffer) {
        this.slots = buffer.readInt();
        this.slotsPerRow = buffer.readInt();
        this.damage = buffer.readInt();
        this.playerUUID = ByteBufUtils.readUTF8String((ByteBuf)buffer);
        this.backpackUUID = ByteBufUtils.readUTF8String((ByteBuf)buffer);
        this.customName = ByteBufUtils.readUTF8String((ByteBuf)buffer);
    }

    public void toBytes(ByteBuf buffer) {
        buffer.writeInt(this.slots);
        buffer.writeInt(this.slotsPerRow);
        buffer.writeInt(this.damage);
        ByteBufUtils.writeUTF8String((ByteBuf)buffer, (String)this.playerUUID);
        ByteBufUtils.writeUTF8String((ByteBuf)buffer, (String)this.backpackUUID);
        ByteBufUtils.writeUTF8String((ByteBuf)buffer, (String)this.customName);
    }

    public IMessage onMessage(MessageBackpackData message, MessageContext ctx) {
        if (message.damage >= 0) {
            ItemStack backpack = new ItemStack(BackpackItems.backpack, 1, message.damage);
            NBTItemStackUtil.setInteger(backpack, "slots", message.slots);
            NBTItemStackUtil.setInteger(backpack, "slots_per_row", message.slotsPerRow);
            NBTItemStackUtil.setString(backpack, "backpack-UID", message.backpackUUID);
            if (!message.customName.isEmpty()) {
                backpack.func_151001_c(message.customName);
            }
            Backpack.proxy.setBackpackData(message.playerUUID, backpack);
        } else {
            Backpack.proxy.setBackpackData(message.playerUUID, null);
        }
        return null;
    }
}

