/*
 * Decompiled with CFR 0.152.
 */
package cubex2.mods.wholetreeaxe;

import com.google.common.collect.Sets;
import cpw.mods.fml.relauncher.Side;
import cpw.mods.fml.relauncher.SideOnly;
import cubex2.mods.wholetreeaxe.WholeTreeAxe;
import java.util.ArrayList;
import java.util.List;
import java.util.Set;
import java.util.Stack;
import net.minecraft.block.Block;
import net.minecraft.client.renderer.texture.IIconRegister;
import net.minecraft.creativetab.CreativeTabs;
import net.minecraft.entity.EntityLivingBase;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.init.Blocks;
import net.minecraft.item.Item;
import net.minecraft.item.ItemStack;
import net.minecraft.item.ItemTool;
import net.minecraft.util.IIcon;
import net.minecraft.world.World;
import net.minecraftforge.common.util.ForgeDirection;

public class ItemWholeTreeAxe
extends ItemTool {
    private static final Set set = Sets.newHashSet((Object[])new Block[]{Blocks.field_150344_f, Blocks.field_150342_X, Blocks.field_150364_r, Blocks.field_150363_s, Blocks.field_150486_ae, Blocks.field_150423_aK, Blocks.field_150428_aP});

    public ItemWholeTreeAxe(float damage, Item.ToolMaterial toolMaterial) {
        super(damage, toolMaterial, set);
        this.func_77655_b("wholetreeaxe");
        this.func_77637_a(CreativeTabs.field_78040_i);
        this.func_111206_d("wta");
    }

    public boolean onBlockStartBreak(ItemStack stack, int x, int y, int z, EntityPlayer player) {
        World world = player.field_70170_p;
        WTAPosition pos1 = new WTAPosition(x, y, z);
        if (this.isValidWoodBlock(world, pos1)) {
            List<WTAPosition> woodBlocks = this.getConnectedWoodBlocks(world, x, y, z);
            for (WTAPosition pos : woodBlocks) {
                if (pos.equals(pos1)) continue;
                Block block = world.func_147439_a(pos.x, pos.y, pos.z);
                int meta = world.func_72805_g(pos.x, pos.y, pos.z);
                world.func_147468_f(pos.x, pos.y, pos.z);
                block.func_149697_b(world, pos.x, pos.y, pos.z, meta, 0);
            }
            stack.func_77972_a(1, (EntityLivingBase)player);
        }
        return false;
    }

    public boolean func_150894_a(ItemStack stack, World world, Block block, int x, int y, int z, EntityLivingBase living) {
        return true;
    }

    private List<WTAPosition> getConnectedWoodBlocks(World world, int x, int y, int z) {
        ArrayList<WTAPosition> res = new ArrayList<WTAPosition>();
        Stack<WTAPosition> positions = new Stack<WTAPosition>();
        positions.push(new WTAPosition(x, y, z));
        do {
            WTAPosition pos = (WTAPosition)positions.pop();
            for (int i = 0; i < 6; ++i) {
                ForgeDirection dir = ForgeDirection.getOrientation((int)i);
                WTAPosition newPos = new WTAPosition(pos.x + dir.offsetX, pos.y + dir.offsetY, pos.z + dir.offsetZ);
                if (!this.isValidWoodBlock(world, newPos) || positions.contains(newPos) || res.contains(newPos)) continue;
                positions.push(newPos);
            }
            res.add(pos);
        } while (!positions.empty());
        return res;
    }

    private boolean isValidWoodBlock(World world, WTAPosition pos) {
        for (int i = 0; i < WholeTreeAxe.woodBlocks.length; ++i) {
            if (world.func_147439_a(pos.x, pos.y, pos.z) != WholeTreeAxe.woodBlocks[i]) continue;
            return true;
        }
        return false;
    }

    @SideOnly(value=Side.CLIENT)
    public IIcon func_77617_a(int par1) {
        return this.field_77791_bV;
    }

    @SideOnly(value=Side.CLIENT)
    public void func_94581_a(IIconRegister iconRegister) {
        this.field_77791_bV = iconRegister.func_94245_a("wholetreeaxe:wta");
    }

    private static class WTAPosition {
        public int x;
        public int y;
        public int z;

        public WTAPosition(int x, int y, int z) {
            this.x = x;
            this.y = y;
            this.z = z;
        }

        public boolean equals(Object obj) {
            if (!(obj instanceof WTAPosition)) {
                return false;
            }
            WTAPosition pos = (WTAPosition)obj;
            return pos.x == this.x && pos.y == this.y && pos.z == this.z;
        }
    }
}

