/*
 * Decompiled with CFR 0.152.
 */
package cubex2.mods.wholetreeaxe;

import com.google.common.collect.Sets;
import cubex2.mods.wholetreeaxe.WholeTreeAxe;
import java.util.ArrayList;
import java.util.List;
import java.util.Set;
import java.util.Stack;
import net.minecraft.block.Block;
import net.minecraft.block.state.IBlockState;
import net.minecraft.creativetab.CreativeTabs;
import net.minecraft.entity.EntityLivingBase;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.init.Blocks;
import net.minecraft.item.Item;
import net.minecraft.item.ItemStack;
import net.minecraft.item.ItemTool;
import net.minecraft.util.BlockPos;
import net.minecraft.util.EnumFacing;
import net.minecraft.world.World;

public class ItemWholeTreeAxe
extends ItemTool {
    private static final Set<Block> set = Sets.newHashSet((Object[])new Block[]{Blocks.field_150344_f, Blocks.field_150342_X, Blocks.field_150364_r, Blocks.field_150363_s, Blocks.field_150486_ae, Blocks.field_150423_aK, Blocks.field_150428_aP});

    public ItemWholeTreeAxe(float damage, Item.ToolMaterial toolMaterial) {
        super(damage, toolMaterial, set);
        this.func_77655_b("wholetreeaxe");
        this.func_77637_a(CreativeTabs.field_78040_i);
    }

    public boolean onBlockStartBreak(ItemStack stack, BlockPos blockPos, EntityPlayer player) {
        World world = player.field_70170_p;
        if (this.isValidWoodBlock(world, blockPos)) {
            List<BlockPos> woodBlocks = this.getConnectedWoodBlocks(world, blockPos);
            for (BlockPos pos : woodBlocks) {
                if (pos.equals((Object)blockPos)) continue;
                IBlockState block = world.func_180495_p(pos);
                world.func_175698_g(pos);
                block.func_177230_c().func_176226_b(world, pos, block, 0);
            }
            stack.func_77972_a(1, (EntityLivingBase)player);
        }
        return false;
    }

    public boolean func_179218_a(ItemStack stack, World world, Block block, BlockPos pos, EntityLivingBase living) {
        return true;
    }

    private List<BlockPos> getConnectedWoodBlocks(World world, BlockPos blockPos) {
        ArrayList<BlockPos> res = new ArrayList<BlockPos>();
        Stack<BlockPos> positions = new Stack<BlockPos>();
        positions.push(blockPos);
        do {
            BlockPos pos = (BlockPos)positions.pop();
            for (int i = 0; i < 6; ++i) {
                EnumFacing dir = EnumFacing.func_82600_a((int)i);
                BlockPos newPos = pos.func_177982_a(dir.func_176730_m().func_177958_n(), dir.func_176730_m().func_177956_o(), dir.func_176730_m().func_177952_p());
                if (!this.isValidWoodBlock(world, newPos) || positions.contains(newPos) || res.contains(newPos)) continue;
                positions.push(newPos);
            }
            res.add(pos);
        } while (!positions.empty());
        return res;
    }

    private boolean isValidWoodBlock(World world, BlockPos pos) {
        for (int i = 0; i < WholeTreeAxe.woodBlocks.length; ++i) {
            if (world.func_180495_p(pos).func_177230_c() != WholeTreeAxe.woodBlocks[i]) continue;
            return true;
        }
        return false;
    }
}

