/*
 * Decompiled with CFR 0.152.
 */
package cubex2.mods.wholetreeaxe;

import com.google.common.collect.Sets;
import cubex2.mods.wholetreeaxe.WholeTreeAxe;
import java.util.ArrayList;
import java.util.List;
import java.util.Set;
import java.util.Stack;
import javax.annotation.ParametersAreNonnullByDefault;
import mcp.MethodsReturnNonnullByDefault;
import net.minecraft.block.Block;
import net.minecraft.block.material.Material;
import net.minecraft.block.state.IBlockState;
import net.minecraft.creativetab.CreativeTabs;
import net.minecraft.entity.EntityLivingBase;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.init.Blocks;
import net.minecraft.item.Item;
import net.minecraft.item.ItemStack;
import net.minecraft.item.ItemTool;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.math.Vec3i;
import net.minecraft.world.IBlockAccess;
import net.minecraft.world.World;
import org.apache.commons.lang3.ArrayUtils;

@ParametersAreNonnullByDefault
@MethodsReturnNonnullByDefault
public class ItemWholeTreeAxe
extends ItemTool {
    private static final Set<Block> EFFECTIVE_ON = Sets.newHashSet((Object[])new Block[]{Blocks.field_150344_f, Blocks.field_150342_X, Blocks.field_150364_r, Blocks.field_150363_s, Blocks.field_150486_ae, Blocks.field_150423_aK, Blocks.field_150428_aP, Blocks.field_150440_ba, Blocks.field_150468_ap, Blocks.field_150471_bO, Blocks.field_150452_aw});

    ItemWholeTreeAxe(float damage, float attackSpeed, Item.ToolMaterial toolMaterial) {
        super(damage, attackSpeed, toolMaterial, EFFECTIVE_ON);
        this.func_77655_b("wholetreeaxe");
        this.func_77637_a(CreativeTabs.field_78040_i);
        this.setHarvestLevel("axe", 3);
    }

    public boolean onBlockStartBreak(ItemStack stack, BlockPos blockPos, EntityPlayer player) {
        World world = player.field_70170_p;
        if (this.isTreeBase(world, blockPos)) {
            List<BlockPos> woodBlocks = this.getConnectedWoodBlocks(world, blockPos);
            for (BlockPos pos : woodBlocks) {
                if (pos.equals((Object)blockPos) || this.isLeaveBlock(world, pos)) continue;
                IBlockState block = world.func_180495_p(pos);
                world.func_175698_g(pos);
                block.func_177230_c().func_176226_b(world, pos, block, 0);
            }
            stack.func_77972_a(1, (EntityLivingBase)player);
        }
        return false;
    }

    public boolean func_179218_a(ItemStack stack, World worldIn, IBlockState state, BlockPos pos, EntityLivingBase entityLiving) {
        return true;
    }

    private List<BlockPos> getConnectedWoodBlocks(World world, BlockPos blockPos) {
        ArrayList<BlockPos> res = new ArrayList<BlockPos>();
        Stack<BlockPos> positions = new Stack<BlockPos>();
        positions.push(blockPos);
        IBlockState start = world.func_180495_p(blockPos);
        Block startBlock = start.func_177230_c();
        do {
            BlockPos pos = (BlockPos)positions.pop();
            res.add(pos);
            if (!(pos.func_177951_i((Vec3i)blockPos) < 4900.0)) continue;
            for (BlockPos newPos : BlockPos.func_177980_a((BlockPos)new BlockPos(pos.func_177958_n() - 1, pos.func_177956_o(), pos.func_177952_p() - 1), (BlockPos)new BlockPos(pos.func_177958_n() + 1, pos.func_177956_o() + 1, pos.func_177952_p() + 1))) {
                boolean isWood = this.isValidWoodBlock(world, newPos, startBlock);
                if (!isWood || positions.contains(newPos) || res.contains(newPos)) continue;
                positions.push(newPos);
            }
        } while (!positions.empty());
        return res;
    }

    private boolean isTreeBase(World world, BlockPos pos) {
        BlockPos down = pos.func_177977_b();
        return this.isValidWoodBlock(world, pos, Blocks.field_150350_a) && !world.func_175623_d(down) && !this.isValidWoodBlock(world, down, Blocks.field_150350_a) && !this.isLeaveBlock(world, down) && world.func_175665_u(down);
    }

    private boolean isValidWoodBlock(World world, BlockPos pos, Block start) {
        IBlockState state = world.func_180495_p(pos);
        Block block = state.func_177230_c();
        if (start != Blocks.field_150350_a) {
            return block == start;
        }
        return block != Blocks.field_150350_a && (block.isWood((IBlockAccess)world, pos) || ArrayUtils.contains((Object[])WholeTreeAxe.woodBlocks, (Object)block));
    }

    private boolean isLeaveBlock(World world, BlockPos pos) {
        IBlockState state = world.func_180495_p(pos);
        Block block = state.func_177230_c();
        return block != Blocks.field_150350_a && block.isLeaves(state, (IBlockAccess)world, pos);
    }

    public float func_150893_a(ItemStack stack, IBlockState state) {
        Material material = state.func_185904_a();
        return material != Material.field_151575_d && material != Material.field_151585_k && material != Material.field_151582_l ? super.func_150893_a(stack, state) : this.field_77864_a;
    }
}

