package atomicstryker.findercompass.client;

import java.util.ArrayList;
import java.util.List;

import net.minecraft.block.Block;
import net.minecraft.client.Minecraft;
import net.minecraft.util.ChunkCoordinates;

/**
 * Runnable worker class for finding Blocks
 * 
 * @author AtomicStryker
 */

public class AS_CompassWorker extends Thread
{
	private Minecraft mcinstance;
	private AS_FinderCompass boss;
	private boolean isRunning = false;
	
	public AS_CompassWorker(Minecraft mc, AS_FinderCompass creator)
	{
		mcinstance = mc;
		boss = creator;
	}
	
	private int[] intArray;
	
	public void setupValues(int[] configInts)
	{
		intArray = configInts;
	}
	
	public boolean isWorking()
	{
		return isRunning;
	}

	@Override
	public void run()
	{
		isRunning = true;
		
		// search!
		ChunkCoordinates result = findNearestBlockChunkOfIDInRange(intArray[0], intArray[1], intArray[2], intArray[3], intArray[4], intArray[5], intArray[6], intArray[7], intArray[8]);
		
		if (result != null)
		{
			boss.onFoundChunkCoordinates(result, intArray);
		}
		
		isRunning = false;
	}
	
    ChunkCoordinates findNearestBlockChunkOfIDInRange(int blockID, int meta, int playerX, int playerY, int playerZ, int xzRange, int yRange, int minY, int maxY)
    {
        List var9 = this.findBlocksOfIDInRange(blockID, meta, playerX, playerY, playerZ, xzRange, yRange, minY, maxY);
        ChunkCoordinates var10 = new ChunkCoordinates(playerX, playerY, playerZ);
        ChunkCoordinates var11 = new ChunkCoordinates(0, 0, 0);
        double var12 = 9999.0D;

        for (int var14 = 0; var14 < var9.size(); ++var14)
        {
            ChunkCoordinates var15 = (ChunkCoordinates)var9.get(var14);
            double var16 = this.GetDistanceBetweenChunks(var10, var15);
            if (var16 < var12)
            {
                var11 = var15;
                var12 = var16;
            }
        }

        ChunkCoordinates var18 = new ChunkCoordinates(var11.posX, var11.posY, var11.posZ);
        return var18;
    }

    List findBlocksOfIDInRange(int blockID, int meta, int playerX, int playerY, int playerZ, int xzRange, int yRange, int minY, int maxY)
    {
        ArrayList resultList = new ArrayList();

        for (int yIter = playerY - yRange - 1; yIter <= playerY + yRange; ++yIter)
        {
            if (yIter >= minY && yIter <= maxY)
            {
                for (int zIter = playerZ - xzRange; zIter <= playerZ + xzRange; ++zIter)
                {
                    for (int xIter = playerX - xzRange; xIter <= playerX + xzRange; ++xIter)
                    {
                        if (this.mcinstance.theWorld.getBlockId(xIter, yIter, zIter) == blockID)
                        {
                            if (meta != 0)
                            {
                                int blockmeta = mcinstance.theWorld.getBlockMetadata(xIter, yIter, zIter);
                                int damage = Block.blocksList[blockID].getDamageValue(mcinstance.theWorld, xIter, yIter, zIter);
                                if (damage != meta)
                                {
                                    continue;
                                }
                            }
                            
                            ChunkCoordinates var13 = new ChunkCoordinates(xIter, yIter, zIter);
                            resultList.add(var13);
                        }
                        this.yield();
                    }
                }
            }
        }

        return resultList;
    }
    
    double GetDistanceBetweenChunks(ChunkCoordinates var1, ChunkCoordinates var2)
    {
        int var3 = Math.abs(var1.posX - var2.posX);
        int var4 = Math.abs(var1.posY - var2.posY);
        int var5 = Math.abs(var1.posZ - var2.posZ);
        return Math.sqrt(Math.pow((double)var3, 2.0D) + Math.pow((double)var4, 2.0D) + Math.pow((double)var5, 2.0D));
    }
}