/*
 * Decompiled with CFR 0.152.
 */
package aroma1997.core.version;

import aroma1997.core.config.Config;
import aroma1997.core.version.VersionStates;
import aroma1997.core.xml.XMLParser;
import java.net.URL;
import java.util.HashMap;
import java.util.Map;
import org.w3c.dom.Node;

public class VersionCheck {
    private static HashMap mods;

    public static VersionStates checkUpdates(String url, String compareVersion, String compareModID) {
        try {
            XMLParser xml = new XMLParser(new URL("http://rmprivate.rm.funpic.de/aroma1997core/version.xml").openStream());
            for (Map.Entry entry : xml.getAll().entrySet()) {
                if (((String)entry.getKey()).split("\\.").length != 2) continue;
                String mod = ((String)entry.getKey()).split("\\.")[0];
                String mcversion = ((String)entry.getKey()).split("\\.")[1];
                if (!mod.equalsIgnoreCase(compareModID) || !mcversion.equalsIgnoreCase("MC" + "1.5.2".replace(".", ""))) continue;
                if (((Node)entry.getValue()).getTextContent().equalsIgnoreCase(compareVersion)) {
                    return VersionStates.LATEST;
                }
                return VersionStates.OUTDATED;
            }
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        return VersionStates.FAILED;
    }

    public static VersionStates checkUpdates(String compareVersion, String compareModID) {
        return VersionCheck.checkUpdates("http://rmprivate.rm.funpic.de/aroma1997core/version.xml", compareVersion, compareModID);
    }

    public static void registerVersionChecker(String compareModID, String compareVersion) {
        if (mods == null) {
            mods = new HashMap();
        }
        if (compareModID.contains(".b")) {
            return;
        }
        mods.put(compareModID, compareVersion);
    }

    public static String[] getUpdateMessages() {
        if (!Config.checkVersion) {
            return new String[1];
        }
        String[] messages = new String[mods.size()];
        int i = 0;
        for (Map.Entry entry : mods.entrySet()) {
            VersionStates state = VersionCheck.checkUpdates((String)entry.getValue(), (String)entry.getKey());
            if (state != VersionStates.OUTDATED) continue;
            messages[i++] = "The mod " + (String)entry.getKey() + " is outdated. Please update it from http://tinyurl.com/aroma1997";
        }
        return messages;
    }
}

