/*
 * Decompiled with CFR 0.152.
 */
package aroma1997.core.client;

import aroma1997.core.client.util.Colors;
import aroma1997.core.log.LogHelper;
import aroma1997.core.util.Aroma1997Exception;
import aroma1997.core.web.xml.XMLParser;
import cpw.mods.fml.relauncher.Side;
import cpw.mods.fml.relauncher.SideOnly;
import java.net.URL;
import java.util.HashMap;
import java.util.Map;
import org.w3c.dom.Node;

@SideOnly(value=Side.CLIENT)
public class MiscStuff {
    private static HashMap<String, String> cape = new HashMap();
    private static HashMap<String, Colors> colors = new HashMap();

    public static void init() {
        try {
            XMLParser xml = new XMLParser(new URL("http://rmprivate.rm.funpic.de/aroma1997core/info.xml").openStream());
            for (Map.Entry<String, Node> entry : xml.getAll().entrySet()) {
                if (entry.getKey().split("\\.").length != 2) continue;
                String username = entry.getKey().split("\\.")[0];
                String part = entry.getKey().split("\\.")[1];
                if (part.equalsIgnoreCase("cape") && !entry.getValue().getTextContent().isEmpty()) {
                    MiscStuff.setCape(username, entry.getValue().getTextContent());
                }
                if (!part.equalsIgnoreCase("color") || entry.getValue().getTextContent().isEmpty()) continue;
                MiscStuff.setColor(username, Colors.valueOf(entry.getValue().getTextContent()));
            }
        }
        catch (Exception e) {
            LogHelper.logException("Failed to setup Capes.", new Aroma1997Exception(e));
        }
    }

    public static void setCape(String player, String url) {
        cape.put(player.toLowerCase(), url);
        LogHelper.debugLog("Adding Cape for " + player);
    }

    public static String getCape(String player) {
        return cape.get(player.toLowerCase());
    }

    public static void setColor(String player, Colors color) {
        colors.put(player.toLowerCase(), color);
        LogHelper.debugLog("Adding Render Color for " + player);
    }

    public static Colors getColor(String player) {
        Colors color = colors.get(player.toLowerCase());
        if (color == null) {
            return Colors.WHITE;
        }
        return color;
    }
}

