/*
 * Decompiled with CFR 0.152.
 */
package aroma1997.core;

import aroma1997.core.config.Conf;
import aroma1997.core.events.EventListener;
import aroma1997.core.inventories.AromaContainer;
import aroma1997.core.inventories.ISpecialInventory;
import aroma1997.core.inventories.ISpecialInventoryProvider;
import aroma1997.core.inventories.Inventories;
import aroma1997.core.log.LogHelper;
import cpw.mods.fml.common.network.IGuiHandler;
import java.io.BufferedReader;
import java.io.File;
import java.io.FileInputStream;
import java.io.InputStreamReader;
import java.util.logging.Level;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.world.World;

public class CommonProxy
implements IGuiHandler {
    public void init() {
        File file = Conf.getConfigFile("xmsmCommands");
        if (file.exists()) {
            LogHelper.logServer(Level.INFO, "Enabling compatibility with Xathz' Server Manager.");
            try {
                String line;
                FileInputStream fis = new FileInputStream(file);
                BufferedReader is = new BufferedReader(new InputStreamReader(fis));
                while ((line = is.readLine()) != null) {
                    if (line.startsWith("#")) continue;
                    String command = line.replaceFirst("!", "");
                    if (!EventListener.blacklist.contains(command)) {
                        EventListener.blacklist.add(command);
                    }
                    LogHelper.log(Level.INFO, "Disabling Command: " + command);
                }
                is.close();
            }
            catch (Exception e) {
                LogHelper.logException("Failed to enable compatibility with Xathz Server Manager.", e);
            }
        }
    }

    public Object getServerGuiElement(int ID, EntityPlayer player, World world, int x, int y, int z) {
        if (ID == Inventories.ID_GUI_BLOCK || ID == Inventories.ID_GUI_BLOCK_SECOND) {
            TileEntity te = world.func_72796_p(x, y, z);
            if (te != null && te instanceof ISpecialInventoryProvider) {
                ISpecialInventoryProvider inv = (ISpecialInventoryProvider)te;
                return inv.getInventory(player, ID).getContainer(player, ID);
            }
            if (te != null && te instanceof ISpecialInventory) {
                AromaContainer cont = ((ISpecialInventory)te).getContainer(player, ID);
                return cont;
            }
        } else {
            ItemStack item = null;
            try {
                item = player.field_71071_by.func_70301_a(ID);
            }
            catch (ArrayIndexOutOfBoundsException e) {
                LogHelper.logException("Incorrect GUI ID!", e);
                return null;
            }
            if (item != null && item.func_77973_b() instanceof ISpecialInventoryProvider) {
                ISpecialInventoryProvider gi = (ISpecialInventoryProvider)item.func_77973_b();
                ISpecialInventory inv = gi.getInventory(player, ID);
                NBTTagCompound nbt = item.func_77978_p();
                if (nbt == null) {
                    nbt = new NBTTagCompound();
                }
                AromaContainer cont = inv.getContainer(player, ID);
                return cont;
            }
        }
        return null;
    }

    public Object getClientGuiElement(int ID, EntityPlayer player, World world, int x, int y, int z) {
        return null;
    }
}

