/*
 * Decompiled with CFR 0.152.
 */
package aroma1997.core.command;

import aroma1997.core.client.util.Colors;
import aroma1997.core.command.AromaBaseCommand;
import aroma1997.core.log.LogHelper;
import aroma1997.core.util.ServerUtil;
import aroma1997.core.util.Util;
import java.io.File;
import java.io.IOException;
import net.minecraft.command.ICommand;
import net.minecraft.command.ICommandSender;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.entity.player.EntityPlayerMP;
import net.minecraft.nbt.CompressedStreamTools;
import net.minecraft.nbt.NBTBase;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.nbt.NBTTagList;
import net.minecraft.server.MinecraftServer;
import net.minecraft.tileentity.TileEntityCommandBlock;

public class MailCommand
extends AromaBaseCommand {
    private static MailCommand instance;
    private final MinecraftServer server;
    private NBTTagCompound messages = new NBTTagCompound();

    public MailCommand(MinecraftServer server) {
        try {
            this.read();
        }
        catch (IOException e) {
            LogHelper.logException("Failed to read Mail File!", e);
        }
        instance = this;
        this.server = server;
    }

    public String func_71517_b() {
        return "mail";
    }

    @Override
    public String getUsage(ICommandSender sender) {
        return "/mail read OR /mail send <target> <message>";
    }

    @Override
    public void processCommandPlayer(EntityPlayerMP sender, String[] args) {
        if (args == null || args.length <= 0 || args[0] == null) {
            sender.func_70006_a(ServerUtil.getChatForString(this.getUsage((ICommandSender)sender)));
        } else if (args[0].equalsIgnoreCase("read")) {
            this.sendFirstMessageToPlayer((EntityPlayer)sender);
        } else if (args[0].equalsIgnoreCase("send") || args[0].equalsIgnoreCase("write")) {
            String receiver = args[1];
            String str = "";
            for (int i = 2; i < args.length; ++i) {
                str = str + args[i] + " ";
            }
            this.addmsg(sender.field_71092_bJ, receiver, str);
        } else {
            ServerUtil.printCommandUsage((ICommandSender)sender, (ICommand)this);
        }
    }

    @Override
    public void processCommandBlock(TileEntityCommandBlock sender, String[] args) {
    }

    @Override
    public void processCommandConsole(ICommandSender sender, String[] args) {
    }

    @Override
    public boolean canUnknownSenderuseCommand(ICommandSender sender) {
        return false;
    }

    @Override
    public boolean canConsoleUseCommand() {
        return false;
    }

    @Override
    public boolean canCommandBlockUseCommand(TileEntityCommandBlock sender) {
        return false;
    }

    @Override
    public boolean canPlayerUseCommand(EntityPlayerMP sender) {
        return true;
    }

    private File getFile() {
        return new File(new File(Util.getWorldFolder(), "aroma1997"), "mails.dat");
    }

    public void save() throws IOException {
        File file = this.getFile();
        if (!file.exists()) {
            file.createNewFile();
        }
        CompressedStreamTools.func_74795_b((NBTTagCompound)this.messages, (File)file);
    }

    public void read() throws IOException {
        File file = this.getFile();
        if (!file.exists()) {
            this.messages = new NBTTagCompound();
            this.messages.func_74782_a("list", (NBTBase)new NBTTagCompound());
            return;
        }
        this.messages = CompressedStreamTools.func_74797_a((File)file);
    }

    private NBTTagCompound getList() {
        return (NBTTagCompound)this.messages.func_74781_a("list");
    }

    private NBTTagList getPlayer(String player) {
        if (!this.getList().func_74764_b(player)) {
            this.getList().func_74782_a(player, (NBTBase)new NBTTagList());
        }
        NBTTagList nbt = this.getList().func_74761_m(player);
        return nbt;
    }

    private void addmsg(String sender, String receiver, String message) {
        NBTTagList list = this.getPlayer(receiver);
        NBTTagCompound nbtmessage = new NBTTagCompound();
        nbtmessage.func_74778_a("sender", sender);
        nbtmessage.func_74778_a("message", message);
        list.func_74742_a((NBTBase)nbtmessage);
        this.doSave();
        EntityPlayerMP player = this.server.func_71203_ab().func_72361_f(receiver);
        EntityPlayerMP player1 = this.server.func_71203_ab().func_72361_f(sender);
        if (player != null) {
            player.func_71035_c((Object)((Object)Colors.GRAY) + "You just received a new message from " + sender + ".");
        }
        if (player1 != null) {
            player1.func_71035_c((Object)((Object)Colors.GRAY) + "Mail delivered.");
        }
    }

    private NBTTagCompound getFirstMessage(String player, boolean shouldKeep) {
        NBTTagList list = this.getPlayer(player);
        if (list.func_74745_c() == 0) {
            return null;
        }
        NBTTagCompound message = (NBTTagCompound)list.func_74743_b(0);
        if (!shouldKeep) {
            list.func_74744_a(0);
            this.doSave();
        }
        return message;
    }

    private void sendFirstMessageToPlayer(EntityPlayer player) {
        NBTTagCompound message = this.getFirstMessage(player.field_71092_bJ, false);
        if (message == null) {
            player.func_71035_c((Object)((Object)Colors.GRAY) + "No messages available.");
            return;
        }
        player.func_71035_c(Colors.GRAY.toString() + (Object)((Object)Colors.ITALIC) + message.func_74779_i("sender") + " wrote:");
        player.func_71035_c((Object)((Object)Colors.GRAY) + message.func_74779_i("message"));
    }

    public boolean hasPlayerMessages(String player) {
        return this.getFirstMessage(player, true) != null;
    }

    public static MailCommand getInstance() {
        return instance;
    }

    private void doSave() {
        try {
            this.save();
            this.read();
        }
        catch (IOException e) {
            LogHelper.logException("Failed to save Mail File.", e);
        }
    }
}

