/*
 * Decompiled with CFR 0.152.
 */
package aroma1997.core;

import aroma1997.core.CommonProxy;
import aroma1997.core.command.AromaCommand;
import aroma1997.core.command.MailCommand;
import aroma1997.core.command.Sleeping;
import aroma1997.core.config.Conf;
import aroma1997.core.config.Config;
import aroma1997.core.events.EventListener;
import aroma1997.core.events.PlayerTracker;
import aroma1997.core.helper.Aroma1997CoreHelper;
import aroma1997.core.log.LogHelper;
import aroma1997.core.util.Util;
import aroma1997.core.version.VersionCheck;
import com.google.common.eventbus.EventBus;
import com.google.common.eventbus.Subscribe;
import cpw.mods.fml.common.DummyModContainer;
import cpw.mods.fml.common.LoadController;
import cpw.mods.fml.common.Mod;
import cpw.mods.fml.common.ModMetadata;
import cpw.mods.fml.common.SidedProxy;
import cpw.mods.fml.common.discovery.ASMDataTable;
import cpw.mods.fml.common.event.FMLConstructionEvent;
import cpw.mods.fml.common.event.FMLInitializationEvent;
import cpw.mods.fml.common.event.FMLPreInitializationEvent;
import cpw.mods.fml.common.event.FMLServerStartedEvent;
import cpw.mods.fml.common.event.FMLServerStartingEvent;
import java.io.File;
import java.util.Arrays;
import java.util.logging.Level;
import net.minecraft.command.ICommand;

public class Aroma1997Core
extends DummyModContainer {
    public static Aroma1997Core instance;
    @Mod.Instance(value="Aroma1997CoreHelper")
    public static Aroma1997CoreHelper helper;
    @SidedProxy(clientSide="aroma1997.core.client.ClientProxy", serverSide="aroma1997.core.CommonProxy")
    public static CommonProxy proxy;
    private ASMDataTable asm;

    public Aroma1997Core() {
        super(new ModMetadata());
        ModMetadata md = super.getMetadata();
        md.authorList = Arrays.asList("Aroma1997", "Schillaa");
        md.version = "1.0.1.5";
        md.name = "Aroma1997Core";
        md.modId = "Aroma1997Core";
        md.autogenerated = false;
        md.description = "This is basically a library that most of my mods are using.";
        md.useDependencyInformation = false;
        md.url = "http://www.minecraftforum.net/topic/1679684-";
        md.credits = "Code by Aroma1997, Textures by Schillaa";
        instance = this;
    }

    public boolean registerBus(EventBus bus, LoadController controller) {
        bus.register((Object)this);
        return true;
    }

    @Subscribe
    public void construct(FMLConstructionEvent event) {
        this.asm = event.getASMHarvestedData();
    }

    @Subscribe
    public void preInit(FMLPreInitializationEvent event) {
        LogHelper.init();
        Conf.init(event.getModConfigurationDirectory());
        Config.init();
        LogHelper.logServer(Level.INFO, "Finished Pre-initialization.");
    }

    @Subscribe
    public void init(FMLInitializationEvent event) {
        proxy.init();
        PlayerTracker.init();
        LogHelper.logServer(Level.INFO, "Finished Initialization.");
    }

    @Subscribe
    public void postInit(FMLInitializationEvent event) {
        VersionCheck.registerVersionChecker("Aroma1997Core", "1.0.1.5");
        VersionCheck.doVersionCheck();
        new EventListener();
        LogHelper.logServer(Level.INFO, "Finished Post-Initialization.");
    }

    @Subscribe
    public void serverStartup(FMLServerStartingEvent event) {
        LogHelper.logServer(Level.INFO, "Starting up server.");
        File file = new File(Util.getWorldFolder(), "aroma1997");
        if (!file.exists()) {
            file.mkdir();
        }
        event.registerServerCommand((ICommand)new Sleeping(event.getServer()));
        event.registerServerCommand((ICommand)new AromaCommand());
        event.registerServerCommand((ICommand)new MailCommand(event.getServer()));
    }

    @Subscribe
    public void serverStartedUp(FMLServerStartedEvent event) {
        LogHelper.logServer(Level.INFO, "Started up server.");
    }
}

