/*
 * Decompiled with CFR 0.152.
 */
package aroma1997.core.recipes;

import aroma1997.core.log.LogHelper;
import aroma1997.core.recipes.RecipePart;
import aroma1997.core.util.ItemUtil;
import java.util.ArrayList;
import java.util.Iterator;
import net.minecraft.inventory.InventoryCrafting;
import net.minecraft.item.ItemStack;
import net.minecraft.item.crafting.IRecipe;
import net.minecraft.world.World;
import net.minecraftforge.oredict.OreDictionary;

public class ShapelessAromicRecipe
implements IRecipe {
    private ItemStack output = null;
    private ArrayList input = new ArrayList();
    private boolean hidden;

    public ShapelessAromicRecipe(ItemStack result, boolean hidden, Object ... recipe) {
        this.hidden = hidden;
        this.output = result.func_77946_l();
        for (Object in : recipe) {
            if (in instanceof ItemStack) {
                this.input.add(((ItemStack)in).func_77946_l());
                String name = OreDictionary.getOreName((int)OreDictionary.getOreID((ItemStack)((ItemStack)in)));
                if (name == null || name.equalsIgnoreCase("Unknown")) continue;
                LogHelper.debugLog("Using " + in.toString() + " as a recipe ingredient. You could also have used: " + name);
                continue;
            }
            if (in instanceof String) {
                this.input.add(OreDictionary.getOres((String)((String)in)));
                continue;
            }
            if (in instanceof Class) {
                this.input.add(ItemUtil.getItemsFromClass((Class)in));
                continue;
            }
            if (in instanceof RecipePart) {
                this.input.add(in);
                continue;
            }
            String ret = "Invalid shapeless aromic recipe: ";
            for (Object tmp : recipe) {
                ret = ret + tmp + ", ";
            }
            ret = ret + this.output;
            throw new RuntimeException(ret);
        }
    }

    public int func_77570_a() {
        return this.input.size();
    }

    public ItemStack func_77571_b() {
        return this.output;
    }

    public ItemStack func_77572_b(InventoryCrafting var1) {
        return this.output.func_77946_l();
    }

    public boolean func_77569_a(InventoryCrafting var1, World world) {
        ArrayList required = new ArrayList(this.input);
        for (int x = 0; x < var1.func_70302_i_(); ++x) {
            ItemStack slot = var1.func_70301_a(x);
            if (slot == null) continue;
            boolean inRecipe = false;
            Iterator req = required.iterator();
            while (req.hasNext()) {
                boolean match = false;
                Object next = req.next();
                if (next instanceof ItemStack) {
                    match = this.checkItemEquals((ItemStack)next, slot);
                } else if (next instanceof ArrayList) {
                    for (ItemStack item : (ArrayList)next) {
                        match = match || this.checkItemEquals(item, slot);
                    }
                } else if (next instanceof RecipePart) {
                    match = ((RecipePart)next).doesItemMatch(slot);
                }
                if (!match) continue;
                inRecipe = true;
                required.remove(next);
                break;
            }
            if (inRecipe) continue;
            return false;
        }
        return required.isEmpty();
    }

    private boolean checkItemEquals(ItemStack target, ItemStack input) {
        return target.field_77993_c == input.field_77993_c && (target.func_77960_j() == Short.MAX_VALUE || target.func_77960_j() == input.func_77960_j());
    }

    public ArrayList getInput() {
        return this.input;
    }

    public boolean isHidden() {
        return this.hidden;
    }
}

