/*
 * Decompiled with CFR 0.152.
 */
package aroma1997.core.version;

import aroma1997.core.log.LogHelper;
import aroma1997.core.util.Aroma1997Exception;
import aroma1997.core.util.Util;
import aroma1997.core.version.ThreadVersionChecking;
import aroma1997.core.version.VersionInfo;
import aroma1997.core.version.VersionStates;
import aroma1997.core.web.xml.XMLParser;
import java.net.URL;
import java.util.HashSet;
import java.util.Map;
import java.util.logging.Level;
import net.minecraft.command.ICommandSender;
import org.w3c.dom.Node;

public class VersionCheck {
    private static boolean hasLoogedError = false;
    private static HashSet<VersionInfo> mods = new HashSet();

    public static VersionStates checkUpdates(String url, String compareVersion, String compareModID) {
        block4: {
            try {
                XMLParser xml = new XMLParser(new URL(url).openStream());
                for (Map.Entry<String, Node> entry : xml.getAll().entrySet()) {
                    if (entry.getKey().split("\\.").length != 2) continue;
                    String mod = entry.getKey().split("\\.")[0];
                    String mcversion = entry.getKey().split("\\.")[1];
                    if (!mod.equalsIgnoreCase(compareModID) || !mcversion.equalsIgnoreCase("MC" + "1.6.4".replace(".", ""))) continue;
                    if (entry.getValue().getTextContent().equalsIgnoreCase(compareVersion)) {
                        return VersionStates.LATEST;
                    }
                    return VersionStates.OUTDATED;
                }
            }
            catch (Exception e) {
                if (hasLoogedError) break block4;
                LogHelper.log(Level.SEVERE, "Failed to do VersionChecking. Check your network connection.");
                hasLoogedError = true;
            }
        }
        return VersionStates.FAILED;
    }

    public static void registerVersionChecker(String compareModID, String compareVersion) {
        if (compareModID.contains("b")) {
            return;
        }
        mods.add(new VersionInfo(compareModID, compareVersion));
    }

    public static void registerVersionChecker(String compareModID, String compareVersion, String xmlFile, String updateURL) {
        if (compareModID.contains("b")) {
            return;
        }
        mods.add(new VersionInfo(compareModID, compareVersion, updateURL, xmlFile));
    }

    static HashSet<String> getUpdateMessages() {
        HashSet<String> messages = new HashSet<String>();
        if (Util.isDev()) {
            messages.add("Skipping VersionChecking...");
            return messages;
        }
        int i = 0;
        for (Object info : mods.toArray()) {
            if (!(info instanceof VersionInfo)) {
                LogHelper.logException("Failed to do VersionChecking.", new Aroma1997Exception("Failed to do versionChecking"));
                return null;
            }
            VersionInfo versInfo = (VersionInfo)info;
            VersionStates state = VersionCheck.checkUpdates(versInfo.getXMLURL(), versInfo.getVersion(), versInfo.getModID());
            if (state == VersionStates.OUTDATED) {
                messages.add("The mod " + versInfo.getModID() + " is outdated. Please update it from " + versInfo.updateURL());
                continue;
            }
            if (state != VersionStates.FAILED) continue;
            ++i;
        }
        if (i == mods.size() && mods.size() != 0) {
            messages.add("Aroma1997Core failed to do VersionChecking. Either there is something wrong with your network connection or with my server.");
        }
        return messages;
    }

    public static void doVersionCheck(ICommandSender sender) {
        new ThreadVersionChecking(sender);
    }

    public static void doVersionCheck() {
        new ThreadVersionChecking(LogHelper.getSpecialLogger());
    }
}

