/*
 * Decompiled with CFR 0.152.
 */
package aroma1997.core;

import aroma1997.core.CommonProxy;
import aroma1997.core.Reference;
import aroma1997.core.command.AromaCommand;
import aroma1997.core.command.MailCommand;
import aroma1997.core.command.Sleeping;
import aroma1997.core.config.Conf;
import aroma1997.core.config.Config;
import aroma1997.core.events.EventListener;
import aroma1997.core.helper.Aroma1997CoreHelper;
import aroma1997.core.items.ItemsMain;
import aroma1997.core.log.LogHelperPre;
import aroma1997.core.network.NetworkHelper;
import aroma1997.core.network.packets.CapePacket;
import aroma1997.core.recipes.ShapedAromicRecipe;
import aroma1997.core.recipes.ShapelessAromicRecipe;
import aroma1997.core.util.AromaRegistry;
import aroma1997.core.util.Util;
import aroma1997.core.version.VersionCheck;
import com.google.common.eventbus.EventBus;
import com.google.common.eventbus.Subscribe;
import cpw.mods.fml.common.DummyModContainer;
import cpw.mods.fml.common.LoadController;
import cpw.mods.fml.common.Mod;
import cpw.mods.fml.common.ModMetadata;
import cpw.mods.fml.common.SidedProxy;
import cpw.mods.fml.common.discovery.ASMDataTable;
import cpw.mods.fml.common.event.FMLConstructionEvent;
import cpw.mods.fml.common.event.FMLInitializationEvent;
import cpw.mods.fml.common.event.FMLPostInitializationEvent;
import cpw.mods.fml.common.event.FMLPreInitializationEvent;
import cpw.mods.fml.common.event.FMLServerStartingEvent;
import cpw.mods.fml.common.network.NetworkCheckHandler;
import cpw.mods.fml.relauncher.Side;
import java.io.File;
import java.util.Arrays;
import java.util.Map;
import net.minecraft.command.ICommand;
import net.minecraftforge.oredict.RecipeSorter;
import org.apache.logging.log4j.Level;

public class Aroma1997Core
extends DummyModContainer {
    public static Aroma1997Core instance;
    @Mod.Instance(value="Aroma1997CoreHelper")
    public static Aroma1997CoreHelper helper;
    @SidedProxy(clientSide="aroma1997.core.client.ClientProxy", serverSide="aroma1997.core.CommonProxy")
    public static CommonProxy proxy;
    private ASMDataTable asm;

    public Aroma1997Core() {
        super(new ModMetadata());
        ModMetadata md = super.getMetadata();
        md.authorList = Arrays.asList("Aroma1997", "Schillaa");
        md.version = Reference.VERSION;
        md.name = "Aroma1997Core";
        md.modId = "Aroma1997Core";
        md.autogenerated = false;
        md.description = "This is basically a library that most of my mods are using.";
        md.useDependencyInformation = false;
        md.url = "http://www.minecraftforum.net/topic/1679684-";
        md.credits = "Code by Aroma1997, Textures by Schillaa";
        instance = this;
    }

    public boolean registerBus(EventBus bus, LoadController controller) {
        bus.register((Object)this);
        return true;
    }

    @Subscribe
    public void construct(FMLConstructionEvent event) {
        this.asm = event.getASMHarvestedData();
    }

    @Subscribe
    public void preInit(FMLPreInitializationEvent event) {
        LogHelperPre.init();
        LogHelperPre.debugLog("Loading Aroma1997Core version " + Reference.VERSION + " for MC " + Reference.MCVERSION);
        Conf.init(event.getModConfigurationDirectory());
        Config.init();
        AromaRegistry.register(ItemsMain.class);
        RecipeSorter.register((String)"aroma1997core:shaped", ShapedAromicRecipe.class, (RecipeSorter.Category)RecipeSorter.Category.SHAPED, (String)"after:minecraft:shaped before:minecraft:shapeless");
        RecipeSorter.register((String)"aroma1997core:shapeless", ShapelessAromicRecipe.class, (RecipeSorter.Category)RecipeSorter.Category.SHAPELESS, (String)"after:minecraft:shapeless");
        NetworkHelper.getCorePacketHandler();
        LogHelperPre.log(Level.INFO, "Finished Pre-initialization.");
    }

    @Subscribe
    public void init(FMLInitializationEvent event) {
        proxy.init();
        NetworkHelper.getCorePacketHandler().registerMessage(CapePacket.class, CapePacket.class, 0, Side.CLIENT);
        LogHelperPre.log(Level.INFO, "Finished Initialization.");
    }

    @Subscribe
    public void postInit(FMLPostInitializationEvent event) {
        VersionCheck.registerVersionChecker("Aroma1997Core", Reference.VERSION);
        VersionCheck.doVersionCheck();
        new EventListener();
        LogHelperPre.log(Level.INFO, "Finished Post-Initialization.");
    }

    @Subscribe
    public void serverStartup(FMLServerStartingEvent event) {
        File file = new File(Util.getWorldFolder(), "aroma1997");
        if (!file.exists()) {
            file.mkdir();
        }
        event.registerServerCommand((ICommand)new Sleeping(event.getServer()));
        event.registerServerCommand((ICommand)new AromaCommand());
        event.registerServerCommand((ICommand)new MailCommand(event.getServer()));
    }

    @NetworkCheckHandler
    public boolean checkModLists(Map<String, String> modList, Side side) {
        return true;
    }
}

