/*
 * Decompiled with CFR 0.152.
 */
package aroma1997.core.util;

import aroma1997.core.util.ItemUtil;
import net.minecraft.inventory.IInventory;
import net.minecraft.inventory.ISidedInventory;
import net.minecraft.item.ItemStack;
import net.minecraftforge.common.util.ForgeDirection;

public class InvUtil {
    public static ItemStack putIntoFirstSlot(IInventory inv, ItemStack item, boolean simulate) {
        return InvUtil.putIntoFirstSlot(inv, item, simulate, null);
    }

    public static ItemStack putIntoFirstSlot(IInventory inv, ItemStack item, boolean simulate, ForgeDirection side) {
        ItemStack itemtmp;
        int i;
        if (item == null) {
            return null;
        }
        if (inv == null) {
            return item;
        }
        ItemStack item1 = item.func_77946_l();
        int[] slots = InvUtil.getAccessibleSlots(inv, side);
        for (i = 0; i < slots.length; ++i) {
            itemtmp = inv.func_70301_a(slots[i]);
            if (itemtmp == null || (item1 = InvUtil.mergeItems(itemtmp, item1, simulate)) != null) continue;
            if (!simulate) {
                inv.func_70296_d();
            }
            return null;
        }
        for (i = 0; i < slots.length; ++i) {
            itemtmp = inv.func_70301_a(slots[i]);
            if (itemtmp != null || !InvUtil.canInsert(inv, item1, i, side)) continue;
            if (!simulate) {
                inv.func_70299_a(slots[i], item1);
                inv.func_70296_d();
            }
            return null;
        }
        inv.func_70296_d();
        return item1;
    }

    public static ItemStack mergeItems(ItemStack main, ItemStack merge, boolean simulate) {
        if (ItemUtil.areItemsSameMatching(main, merge, ItemUtil.ItemMatchCriteria.ID, ItemUtil.ItemMatchCriteria.DAMAGE, ItemUtil.ItemMatchCriteria.NBT)) {
            if (main.field_77994_a >= main.func_77976_d()) {
                return merge;
            }
            int diff = main.func_77976_d() - main.field_77994_a;
            if (diff >= merge.field_77994_a) {
                if (!simulate) {
                    main.field_77994_a += merge.field_77994_a;
                }
                return null;
            }
            if (simulate) {
                merge = merge.func_77946_l();
            } else {
                main.field_77994_a += diff;
            }
            merge.field_77994_a -= diff;
            return merge;
        }
        return merge;
    }

    public static void clearInventory(IInventory inv) {
        for (int i = 0; i < inv.func_70302_i_(); ++i) {
            ItemStack item = inv.func_70301_a(i);
            if (item == null) continue;
            inv.func_70298_a(i, item.field_77994_a);
        }
    }

    public static int[] getAccessibleSlots(IInventory inv, ForgeDirection side) {
        if (inv == null) {
            return null;
        }
        if (inv instanceof ISidedInventory && side != null) {
            return ((ISidedInventory)inv).func_94128_d(side.ordinal());
        }
        int[] slots = new int[inv.func_70302_i_()];
        for (int i = 0; i < slots.length; ++i) {
            slots[i] = i;
        }
        return slots;
    }

    public static boolean canInsert(IInventory inv, ItemStack item, int slot, ForgeDirection side) {
        if (inv == null || item == null) {
            return false;
        }
        if (side == null) {
            return true;
        }
        if (inv instanceof ISidedInventory) {
            return ((ISidedInventory)inv).func_102007_a(slot, item, side.ordinal());
        }
        return true;
    }

    public static boolean canExtract(IInventory inv, ItemStack item, int slot, ForgeDirection side) {
        if (inv == null || item == null) {
            return false;
        }
        if (side == null) {
            return true;
        }
        if (inv instanceof ISidedInventory) {
            return ((ISidedInventory)inv).func_102008_b(slot, item, slot);
        }
        return true;
    }

    public static int getFirstItem(IInventory inv, Class<?> claSS) {
        return InvUtil.getFirstItem(inv, claSS, null);
    }

    public static int getFirstItem(IInventory inv, Class<?> claSS, ForgeDirection side) {
        return InvUtil.getFirstItem(inv, claSS, side, new DefaultFilter());
    }

    public static int getFirstItem(IInventory inv, Class<?> claSS, ForgeDirection side, IFilter filter) {
        int[] slots = InvUtil.getAccessibleSlots(inv, side);
        for (int i = 0; i < slots.length; ++i) {
            ItemStack item = inv.func_70301_a(slots[i]);
            if (item == null || !claSS.isInstance(item.func_77973_b()) || !filter.isOk(item)) continue;
            return slots[i];
        }
        return -1;
    }

    @Deprecated
    public static ItemStack getFirstItem(IInventory inv, ItemStack item) {
        return InvUtil.getFirstItem(inv, item, false);
    }

    public static ItemStack getFirstItem(IInventory inv, ItemStack item, boolean simulate) {
        return InvUtil.getFirstItem(inv, item, simulate, null);
    }

    public static ItemStack getFirstItem(IInventory inv, ItemStack item, boolean simulate, ForgeDirection side) {
        return InvUtil.getFirstItem(inv, item, simulate, side, new DefaultFilter());
    }

    public static ItemStack getFirstItem(IInventory inv, ItemStack item, boolean simulate, ForgeDirection side, IFilter filter) {
        int[] slots = InvUtil.getAccessibleSlots(inv, side);
        for (int i = 0; i < slots.length; ++i) {
            if (!InvUtil.canExtract(inv, item, slots[i], side) || !ItemUtil.areItemsSameMatching(item, inv.func_70301_a(slots[i]), ItemUtil.ItemMatchCriteria.ID, ItemUtil.ItemMatchCriteria.DAMAGE, ItemUtil.ItemMatchCriteria.NBT) || !filter.isOk(inv.func_70301_a(slots[i]))) continue;
            if (simulate) {
                return inv.func_70301_a(slots[i]);
            }
            return inv.func_70298_a(slots[i], Math.min(inv.func_70301_a((int)slots[i]).field_77994_a, item.field_77994_a));
        }
        return null;
    }

    public static boolean hasSpace(IInventory inv) {
        for (int i = 0; i < inv.func_70302_i_(); ++i) {
            if (inv.func_70301_a(i) != null) continue;
            return true;
        }
        return false;
    }

    private static class DefaultFilter
    implements IFilter {
        private DefaultFilter() {
        }

        @Override
        public boolean isOk(ItemStack items) {
            return true;
        }
    }

    public static interface IFilter {
        public boolean isOk(ItemStack var1);
    }
}

