/*
 * Decompiled with CFR 0.152.
 */
package aroma1997.core.misc;

import net.minecraft.nbt.NBTTagCompound;

public class EnergyObject {
    private int max;
    private int current;

    public EnergyObject setMax(int max) {
        this.max = max;
        return this;
    }

    public EnergyObject setCurrent(int num) {
        this.current = num;
        return this;
    }

    public int add(int amount) {
        if (amount <= 0) {
            return 0;
        }
        if (amount + this.current >= this.max) {
            int ret = this.max - this.current;
            this.current = this.max;
            return ret;
        }
        this.current += amount;
        return amount;
    }

    public int remove(int amount) {
        if (amount <= 0) {
            return 0;
        }
        if (amount >= this.current) {
            int ret = this.current;
            this.current = 0;
            return ret;
        }
        this.current -= amount;
        return amount;
    }

    public int getMax() {
        return this.max;
    }

    public int getCurrent() {
        return this.current;
    }

    public void saveToNBT(NBTTagCompound nbt) {
        nbt.func_74768_a("current", this.current);
        nbt.func_74768_a("max", this.max);
    }

    public void readFromNBT(NBTTagCompound nbt) {
        if (nbt.func_74764_b("current")) {
            this.current = nbt.func_74762_e("current");
        }
        if (nbt.func_74764_b("max")) {
            this.max = nbt.func_74762_e("max");
        }
    }

    public static class CreativeEnergyObject
    extends EnergyObject {
        @Override
        public EnergyObject setCurrent(int num) {
            return this;
        }

        @Override
        public int add(int amount) {
            return 0;
        }

        @Override
        public int remove(int amount) {
            return amount;
        }

        @Override
        public int getMax() {
            return Integer.MAX_VALUE;
        }

        @Override
        public int getCurrent() {
            return this.getMax();
        }
    }
}

