/*
 * Decompiled with CFR 0.152.
 */
package aroma1997.core.client.inventories;

import aroma1997.core.client.inventories.RenderHelper;
import aroma1997.core.inventories.IProgressable;
import net.minecraft.client.gui.Gui;
import net.minecraft.util.ResourceLocation;

public abstract class AbstractSpecialImage {
    private int x;
    private int y;

    public AbstractSpecialImage(int x, int y) {
        this.x = x;
        this.y = y;
    }

    public abstract float getProgress();

    protected abstract boolean progressX();

    protected abstract boolean inverted();

    public int getXOffset() {
        if (!this.progressX() || !this.inverted()) {
            return 0;
        }
        return (int)((float)this.getMaxSizeX() * (1.0f - this.getProgress()));
    }

    public int getYOffset() {
        if (this.progressX() || !this.inverted()) {
            return 0;
        }
        return (int)((float)this.getMaxSizeY() * (1.0f - this.getProgress()));
    }

    public int getStartX() {
        return this.getPosX() + this.getXOffset();
    }

    public int getStartY() {
        return this.getPosY() + this.getYOffset();
    }

    public int getSizeX() {
        return this.getMaxSizeX() - this.getXOffset();
    }

    public int getSizeY() {
        return this.getMaxSizeY() - this.getYOffset();
    }

    public void draw(Gui gui) {
        RenderHelper.bindTexture(this.getRL());
        if (this.getBackgroundX() != -1) {
            gui.func_73729_b(this.getPosX(), this.getPosY(), this.getBackgroundX(), this.getBackgroundY(), this.getMaxSizeX(), this.getMaxSizeY());
        }
        gui.func_73729_b(this.getStartX(), this.getStartY(), this.getMinX() + this.getXOffset(), this.getMinY() + this.getYOffset(), this.getSizeX(), this.getSizeY());
    }

    public int getPosX() {
        return this.x;
    }

    public int getPosY() {
        return this.y;
    }

    protected abstract int getMinX();

    protected abstract int getMaxSizeX();

    protected abstract int getMinY();

    protected abstract int getMaxSizeY();

    public abstract ResourceLocation getRL();

    public abstract int getBackgroundX();

    public abstract int getBackgroundY();

    public static abstract class ProgressableImage
    extends AbstractSpecialImage {
        private IProgressable prog;

        public ProgressableImage(int x, int y, IProgressable prog) {
            super(x, y);
            this.prog = prog;
        }

        @Override
        public float getProgress() {
            return this.prog.getProgress(this);
        }
    }
}

