/*
 * Decompiled with CFR 0.152.
 */
package aroma1997.core.config;

import aroma1997.core.config.Conf;
import aroma1997.core.modules.Module;
import aroma1997.core.util.Util;
import net.minecraft.client.Minecraft;
import net.minecraftforge.common.config.Configuration;
import net.minecraftforge.common.config.Property;
import net.minecraftforge.fml.relauncher.Side;
import net.minecraftforge.fml.relauncher.SideOnly;

public class Config {
    private static final String CATEGORY_MODULES = "Modules";
    public static boolean checkVersion;
    private static Configuration config;
    private static boolean showHidden;
    private static boolean debugEnabled;
    private static boolean tooltipsEnabled;

    public static void init() {
        config = Conf.getConfig("Aroma1997Core");
        Config.load(true);
    }

    public static void load(boolean first) {
        config.load();
        checkVersion = config.get("general", "checkVersion", true, "If Aroma1997Core should run a VersionCheck.").getBoolean(true);
        debugEnabled = config.get("DEBUG", "debuggingEnabled", false).getBoolean(false);
        if (Util.isClient()) {
            showHidden = config.hasKey("general", "showHidden") ? config.get("general", "showHidden", false, "If NEI should show hidden recipes").getBoolean(false) : false;
            tooltipsEnabled = config.getBoolean("tooltips", "general", Util.isDev(), "If this is enabled, Items will have a tooltip corresponding to their ItemRegistry name and their OreDictionary names.");
        }
        config.addCustomCategoryComment(CATEGORY_MODULES, "This is here to manually enable some Modules.\\r\\n They will be disabled by default to make it possible to connect to servers with Aroma1997Core with clients without it.\\r\\n It is disabled by default, but mods needing this module can override this config to still activate it. ");
        for (Module m : Module.values()) {
            Property p = config.get(CATEGORY_MODULES, m.toString(), false);
            if (m.isActive()) {
                p.set(true);
                continue;
            }
            boolean modEnabled = p.getBoolean();
            if (!modEnabled || !first) continue;
            Module.registerModuleIniternal(m);
        }
        if (config.hasChanged()) {
            config.save();
        }
    }

    public static boolean debugEnabled() {
        return debugEnabled;
    }

    public static boolean tooltipsEnabled() {
        return tooltipsEnabled || Util.isDev();
    }

    @SideOnly(value=Side.CLIENT)
    public static boolean shouldShowHiddenRecipes() {
        return Minecraft.func_71410_x().field_71439_g.func_70005_c_().equalsIgnoreCase("Aroma1997") || showHidden;
    }
}

