/*
 * Decompiled with CFR 0.152.
 */
package aroma1997.core.modules;

import aroma1997.core.log.LogHelper;
import aroma1997.core.modules.IModule;
import aroma1997.core.util.AromaRegistry;
import aroma1997.core.util.Util;
import net.minecraftforge.fml.common.Loader;
import net.minecraftforge.fml.common.LoaderState;

public enum Module {
    WRENCH("aroma1997.core.items.wrench.ItemsWrench");

    private String clazz;
    private IModule module;
    private boolean active;

    private Module(String clazz) {
        this.clazz = clazz;
    }

    public boolean isActive() {
        return this.active;
    }

    public static void registerModuleIniternal(Module m) {
        Util.onlyCore();
        m.active = true;
    }

    public static void registerActiveModules() {
        Util.onlyCore();
        for (Module m : Module.values()) {
            if (!m.active) continue;
            m.setModule();
            try {
                AromaRegistry.register(Class.forName(m.clazz), m.module);
            }
            catch (ClassNotFoundException e) {
                LogHelper.logException("Failed to initialize module " + (Object)((Object)m) + "This MAY work, but it also may crash.", e);
            }
        }
    }

    private void setModule() {
        if (this.module != null) {
            return;
        }
        try {
            this.module = (IModule)Class.forName(this.clazz).newInstance();
        }
        catch (Exception e) {
            LogHelper.logException("Failed to initialize some part of the module. This MAY work, but it also may crash.", e);
        }
    }

    public static void registerModule(Module m) {
        if (!Loader.instance().isInState(LoaderState.CONSTRUCTING)) {
            throw new RuntimeException("Enabling module outside of Construction. This is *NOT* the way you do it.");
        }
        m.active = true;
    }

    public static Module getFirstActiveModule() {
        for (Module m : Module.values()) {
            if (!m.active) continue;
            return m;
        }
        return null;
    }

    public IModule getModule() {
        return this.module;
    }

    public static void neiInit() {
        for (Module m : Module.values()) {
            m.module.neiInit();
        }
    }
}

