/*
 * Decompiled with CFR 0.152.
 */
package aroma1997.core.command;

import aroma1997.core.client.util.Colors;
import aroma1997.core.command.AromaBaseCommand;
import aroma1997.core.command.AromaSubCommand;
import aroma1997.core.util.ServerUtil;
import java.util.ArrayList;
import java.util.List;
import net.minecraft.command.ICommandSender;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.entity.player.EntityPlayerMP;
import net.minecraft.server.MinecraftServer;

public class SleepingCommand
extends AromaSubCommand {
    private final MinecraftServer server;

    public SleepingCommand(MinecraftServer server) {
        super("sleep", "sleeping");
        this.server = server;
        this.addSubCommand(new SleepingInformCommand());
        this.addSubCommand(new SleepingKickCommand());
    }

    private boolean shouldNotDo(EntityPlayerMP sender) {
        if (sender.field_71133_b.func_71218_a(sender.field_71093_bK).func_72935_r()) {
            sender.func_145747_a(ServerUtil.getChatForString((Object)((Object)Colors.YELLOW) + "No need to sleep in dimension " + sender.field_71093_bK + "!"));
            return true;
        }
        List<EntityPlayerMP> players = this.getPlayersNotSleeping(this.server, (EntityPlayer)sender);
        if (players.size() == 0) {
            sender.func_145747_a(ServerUtil.getChatForString("All players are sleeping."));
            return true;
        }
        return false;
    }

    @Override
    public void processCommandSelf(ICommandSender snd, String[] args) {
        if (this.shouldNotDo((EntityPlayerMP)snd)) {
            return;
        }
        EntityPlayerMP sender = (EntityPlayerMP)snd;
        List<EntityPlayerMP> players = this.getPlayersNotSleeping(this.server, (EntityPlayer)sender);
        if (players.size() == 0) {
            sender.func_145747_a(ServerUtil.getChatForString("All players are sleeping."));
            return;
        }
        String message = "The players, that are not sleeping are: ";
        boolean first = true;
        for (EntityPlayerMP player : players) {
            if (first) {
                message = message + player.func_70005_c_();
                first = false;
                continue;
            }
            message = message + ", " + player.func_70005_c_();
        }
        message = message + ".";
        sender.func_145747_a(ServerUtil.getChatForString(message));
    }

    @Override
    public String getSelfDescription(ICommandSender sender) {
        return "/sleep";
    }

    private List<EntityPlayerMP> getPlayersNotSleeping(MinecraftServer server, EntityPlayer player) {
        String[] users = server.func_71213_z();
        ArrayList<EntityPlayerMP> players = new ArrayList<EntityPlayerMP>();
        for (EntityPlayerMP user : server.func_184103_al().func_181057_v()) {
            if (user == null || user.func_70608_bn() || user.field_71093_bK != player.field_71093_bK || user == player) continue;
            players.add(user);
        }
        return players;
    }

    public boolean func_184882_a(MinecraftServer server, ICommandSender sender) {
        return sender != null && sender instanceof EntityPlayerMP;
    }

    private class SleepingKickCommand
    extends AromaBaseCommand {
        public SleepingKickCommand() {
            super("kick");
        }

        @Override
        public String func_71518_a(ICommandSender var1) {
            return "/sleep kick";
        }

        public void func_184881_a(MinecraftServer server, ICommandSender sender, String[] var2) {
            if (SleepingCommand.this.shouldNotDo((EntityPlayerMP)sender)) {
                return;
            }
            List players = SleepingCommand.this.getPlayersNotSleeping(server, (EntityPlayer)((EntityPlayerMP)sender));
            for (EntityPlayerMP player : players) {
                player.field_71135_a.func_147360_c((Object)((Object)Colors.YELLOW) + "You were not sleeping!");
            }
            sender.func_145747_a(ServerUtil.getChatForString((Object)((Object)Colors.YELLOW) + "" + players.size() + " players were kicked from the server!"));
        }

        public boolean func_184882_a(MinecraftServer server, ICommandSender sender) {
            return sender != null && sender instanceof EntityPlayerMP && ServerUtil.isPlayerAdmin(sender);
        }
    }

    private class SleepingInformCommand
    extends AromaBaseCommand {
        public SleepingInformCommand() {
            super("inform");
        }

        @Override
        public String func_71518_a(ICommandSender var1) {
            return "/sleep inform";
        }

        public boolean func_184882_a(MinecraftServer server, ICommandSender sender) {
            return sender != null && sender instanceof EntityPlayerMP;
        }

        public void func_184881_a(MinecraftServer server, ICommandSender sender, String[] var2) {
            if (SleepingCommand.this.shouldNotDo((EntityPlayerMP)sender)) {
                return;
            }
            List players = SleepingCommand.this.getPlayersNotSleeping(server, (EntityPlayer)((EntityPlayerMP)sender));
            for (EntityPlayerMP player : players) {
                player.func_145747_a(ServerUtil.getChatForString((Object)((Object)Colors.GREEN) + sender.func_70005_c_() + " wants you to sleep!"));
            }
            sender.func_145747_a(ServerUtil.getChatForString(Colors.YELLOW.toString() + players.size() + " players were informed about that you want to sleep!"));
        }
    }
}

