/*
 * Decompiled with CFR 0.152.
 */
package aroma1997.core.coremod.asm;

import java.lang.reflect.Method;

public class AsmUtils {
    private AsmUtils() {
    }

    public static int getReturnCodeForClass(Class c) {
        if (c == Void.TYPE) {
            return 177;
        }
        if (c.isPrimitive()) {
            if (c == Boolean.TYPE || c == Byte.TYPE || c == Short.TYPE || c == Character.TYPE || c == Integer.TYPE) {
                return 172;
            }
            if (c == Long.TYPE) {
                return 173;
            }
            if (c == Float.TYPE) {
                return 174;
            }
            if (c == Double.TYPE) {
                return 175;
            }
            throw new IllegalArgumentException(c + "");
        }
        return 176;
    }

    public static int getLoadCodeForClass(Class c) {
        if (c.isPrimitive()) {
            if (c == Boolean.TYPE || c == Byte.TYPE || c == Short.TYPE || c == Character.TYPE || c == Integer.TYPE) {
                return 21;
            }
            if (c == Long.TYPE) {
                return 22;
            }
            if (c == Float.TYPE) {
                return 23;
            }
            if (c == Double.TYPE) {
                return 24;
            }
            throw new IllegalArgumentException(c + "");
        }
        return 25;
    }

    public static String getDescriptorForClass(Class c) {
        if (c.isPrimitive()) {
            if (c == Byte.TYPE) {
                return "B";
            }
            if (c == Character.TYPE) {
                return "C";
            }
            if (c == Double.TYPE) {
                return "D";
            }
            if (c == Float.TYPE) {
                return "F";
            }
            if (c == Integer.TYPE) {
                return "I";
            }
            if (c == Long.TYPE) {
                return "J";
            }
            if (c == Short.TYPE) {
                return "S";
            }
            if (c == Boolean.TYPE) {
                return "Z";
            }
            if (c == Void.TYPE) {
                return "V";
            }
            throw new RuntimeException("Unrecognized primitive " + c);
        }
        if (c.isArray()) {
            return c.getName().replace('.', '/');
        }
        return ('L' + c.getName() + ';').replace('.', '/');
    }

    public static String getMethodDescriptor(Method m) {
        String s = "(";
        for (Class<?> clazz : m.getParameterTypes()) {
            s = s + AsmUtils.getDescriptorForClass(clazz);
        }
        s = s + ')';
        return s + AsmUtils.getDescriptorForClass(m.getReturnType());
    }
}

