/*
 * Decompiled with CFR 0.152.
 */
package aroma1997.core.recipes;

import aroma1997.core.recipes.BasicAromicRecipe;
import aroma1997.core.recipes.IAromicRecipe;
import aroma1997.core.recipes.IRecipePart;
import aroma1997.core.recipes.RecipeUtil;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Iterator;
import java.util.List;
import net.minecraft.inventory.InventoryCrafting;
import net.minecraft.item.ItemStack;
import net.minecraft.world.World;

public class ShapelessAromicRecipe
extends BasicAromicRecipe {
    private List<IRecipePart> input;

    public ShapelessAromicRecipe(ItemStack result, Object ... recipe) {
        super(result);
        IRecipePart[] input = new IRecipePart[recipe.length];
        for (int i = 0; i < recipe.length; ++i) {
            input[i] = RecipeUtil.getRecipePart(recipe[i]);
        }
        this.input = Arrays.asList(input);
    }

    public int func_77570_a() {
        return this.input.size();
    }

    public ItemStack func_77572_b(InventoryCrafting var1) {
        return this.adjustOutput(this.func_77571_b().func_77946_l(), var1);
    }

    public boolean func_77569_a(InventoryCrafting var1, World world) {
        ArrayList<IRecipePart> required = new ArrayList<IRecipePart>(this.input);
        for (int x = 0; x < var1.func_70302_i_(); ++x) {
            ItemStack slot = var1.func_70301_a(x);
            if (slot == null) continue;
            boolean inRecipe = false;
            Iterator<IRecipePart> req = required.iterator();
            while (req.hasNext()) {
                boolean match = false;
                IRecipePart next = req.next();
                match = next.doesItemMatch(slot);
                if (!match) continue;
                inRecipe = true;
                required.remove(next);
                break;
            }
            if (inRecipe) continue;
            return false;
        }
        return required.isEmpty();
    }

    @Override
    public IRecipePart[] getInput() {
        return this.input.toArray(new IRecipePart[0]);
    }

    @Override
    public boolean isMirrorOK() {
        return true;
    }

    @Override
    public IAromicRecipe setMirrorOK(boolean mirrorok) {
        if (!mirrorok) {
            throw new UnsupportedOperationException("Cannot disable Mirror on a Shapeless Recipe.");
        }
        return this;
    }
}

