/*
 * Decompiled with CFR 0.152.
 */
package aroma1997.core.coremod;

import aroma1997.core.coremod.CoreMod;
import aroma1997.core.log.LogHelperPre;
import com.google.common.base.Charsets;
import com.google.common.base.Splitter;
import com.google.common.collect.ImmutableMap;
import com.google.common.collect.Maps;
import com.google.common.io.Files;
import com.google.common.io.LineProcessor;
import java.io.File;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.net.URL;
import java.nio.channels.Channels;
import java.nio.channels.ReadableByteChannel;
import java.nio.charset.Charset;
import java.text.SimpleDateFormat;
import java.util.Date;
import java.util.Enumeration;
import java.util.Iterator;
import java.util.Map;
import java.util.NoSuchElementException;
import java.util.zip.ZipEntry;
import java.util.zip.ZipFile;
import org.apache.logging.log4j.Level;

public class MCPNames {
    private static final Map<String, String> fields;
    private static final Map<String, String> methods;

    private static void downloadMappings(File targetDir) throws IOException {
        if (!targetDir.exists()) {
            targetDir.mkdirs();
        }
        LogHelperPre.log(Level.INFO, "Downloading current MCP mappings.");
        String version = new SimpleDateFormat("YYYYMMdd").format(new Date()) + "-" + "1.11";
        LogHelperPre.log(Level.INFO, "Downloading snapshot mappings: " + version);
        String zipfile = "mcp_snapshot-" + version + ".zip";
        String download = "http://export.mcpbot.bspk.rs/mcp_snapshot/" + version + "/" + zipfile;
        URL website = new URL(download);
        ReadableByteChannel rbc = Channels.newChannel(website.openStream());
        File tmpZip = new File(targetDir, zipfile);
        tmpZip.deleteOnExit();
        FileOutputStream fos = new FileOutputStream(tmpZip);
        fos.getChannel().transferFrom(rbc, 0L, Long.MAX_VALUE);
        fos.close();
        ZipFile zip = new ZipFile(tmpZip);
        Enumeration<? extends ZipEntry> entries = zip.entries();
        while (entries.hasMoreElements()) {
            int len;
            ZipEntry entry = entries.nextElement();
            if (entry.isDirectory()) continue;
            InputStream in = zip.getInputStream(entry);
            FileOutputStream out = new FileOutputStream(targetDir + "/" + entry.getName());
            byte[] buffer = new byte[1024];
            while ((len = in.read(buffer)) >= 0) {
                ((OutputStream)out).write(buffer, 0, len);
            }
            in.close();
            ((OutputStream)out).close();
        }
        zip.close();
        tmpZip.delete();
    }

    public static boolean mcp() {
        return !CoreMod.runtimeDeobfuscationEnabled;
    }

    public static String field(String srgName) {
        if (MCPNames.mcp() && fields.containsKey(srgName)) {
            return fields.get(srgName);
        }
        return srgName;
    }

    public static String method(String srgName) {
        if (MCPNames.mcp() && methods.containsKey(srgName)) {
            return methods.get(srgName);
        }
        return srgName;
    }

    private static Map<String, String> readMappings(File file) {
        if (!file.isFile()) {
            throw new RuntimeException("Couldn't find MCP mappings at: " + file.getAbsolutePath());
        }
        try {
            return (Map)Files.readLines((File)file, (Charset)Charsets.UTF_8, (LineProcessor)new MCPFileParser());
        }
        catch (IOException e) {
            throw new RuntimeException("Couldn't read SRG->MCP mappings", e);
        }
    }

    static {
        if (MCPNames.mcp()) {
            String mappingDir = "./mcp/";
            LogHelperPre.log(Level.INFO, "Loading MCP mappings from: " + new File(mappingDir).getAbsolutePath());
            File fieldsFile = new File(mappingDir + "fields.csv");
            File methodsFile = new File(mappingDir + "methods.csv");
            if (!fieldsFile.exists() || !methodsFile.exists()) {
                try {
                    MCPNames.downloadMappings(new File(mappingDir));
                }
                catch (IOException e) {
                    throw new RuntimeException("Could not download current mcp mappings.", e);
                }
            }
            fields = MCPNames.readMappings(fieldsFile);
            methods = MCPNames.readMappings(methodsFile);
        } else {
            LogHelperPre.log(Level.INFO, "No need to load MCP mappings. We're in obfuscated environment.");
            methods = null;
            fields = null;
        }
    }

    private static class MCPFileParser
    implements LineProcessor<Map<String, String>> {
        private static final Splitter splitter = Splitter.on((char)',').trimResults();
        private final Map<String, String> map = Maps.newHashMap();
        private boolean foundFirst;

        private MCPFileParser() {
        }

        public boolean processLine(String line) throws IOException {
            if (!this.foundFirst) {
                this.foundFirst = true;
                return true;
            }
            Iterator splitted = splitter.split((CharSequence)line).iterator();
            try {
                String srg = (String)splitted.next();
                String mcp = (String)splitted.next();
                if (!this.map.containsKey(srg)) {
                    this.map.put(srg, mcp);
                } else {
                    LogHelperPre.log(Level.WARN, "Conflicxting srg name: " + srg + ": " + this.map.get(srg) + " and " + mcp + ".");
                }
            }
            catch (NoSuchElementException e) {
                throw new IOException("Invalid Mappings file!", e);
            }
            return true;
        }

        public Map<String, String> getResult() {
            return ImmutableMap.copyOf(this.map);
        }
    }
}

