/*
 * Decompiled with CFR 0.152.
 */
package aroma1997.core;

import aroma1997.core.CommonProxy;
import aroma1997.core.Reference;
import aroma1997.core.command.AromaCommand;
import aroma1997.core.command.SleepingCommand;
import aroma1997.core.config.Conf;
import aroma1997.core.config.Config;
import aroma1997.core.coremod.CoreMod;
import aroma1997.core.helper.Aroma1997CoreHelper;
import aroma1997.core.log.LogHelperPre;
import aroma1997.core.network.NetworkHelper;
import aroma1997.core.network.packets.CapePacket;
import aroma1997.core.recipes.ShapedAromicRecipe;
import aroma1997.core.recipes.ShapelessAromicRecipe;
import aroma1997.core.util.Util;
import com.google.common.eventbus.EventBus;
import com.google.common.eventbus.Subscribe;
import java.io.File;
import java.util.Arrays;
import java.util.Map;
import net.minecraft.command.ICommand;
import net.minecraftforge.fml.common.DummyModContainer;
import net.minecraftforge.fml.common.LoadController;
import net.minecraftforge.fml.common.Mod;
import net.minecraftforge.fml.common.ModMetadata;
import net.minecraftforge.fml.common.SidedProxy;
import net.minecraftforge.fml.common.event.FMLInitializationEvent;
import net.minecraftforge.fml.common.event.FMLPostInitializationEvent;
import net.minecraftforge.fml.common.event.FMLPreInitializationEvent;
import net.minecraftforge.fml.common.event.FMLServerStartingEvent;
import net.minecraftforge.fml.common.network.NetworkCheckHandler;
import net.minecraftforge.fml.relauncher.Side;
import net.minecraftforge.oredict.RecipeSorter;
import org.apache.logging.log4j.Level;

public class Aroma1997Core
extends DummyModContainer {
    public static Aroma1997Core instance;
    @Mod.Instance(value="Aroma1997CoreHelper")
    public static Aroma1997CoreHelper helper;
    @SidedProxy(clientSide="aroma1997.core.client.ClientProxy", serverSide="aroma1997.core.CommonProxy")
    public static CommonProxy proxy;

    public Aroma1997Core() {
        super(new ModMetadata());
        ModMetadata md = super.getMetadata();
        md.authorList = Arrays.asList("Aroma1997", "Schillaa");
        md.version = Reference.VERSION;
        md.name = "Aroma1997Core";
        md.modId = "aroma1997core";
        md.autogenerated = false;
        md.description = "This is basically a library that most of my mods are using.";
        md.useDependencyInformation = false;
        md.url = "http://www.minecraftforum.net/topic/1679684-";
        md.credits = "Code by Aroma1997, Textures by Schillaa";
        instance = this;
    }

    public boolean registerBus(EventBus bus, LoadController controller) {
        bus.register((Object)this);
        return true;
    }

    @Subscribe
    public void preInit(FMLPreInitializationEvent event) {
        LogHelperPre.init();
        LogHelperPre.debugLog("Loading Aroma1997Core version " + Reference.VERSION + " for MC " + Reference.MCVERSION);
        Conf.init(event.getModConfigurationDirectory());
        Config.init();
        RecipeSorter.register((String)"aroma1997core:shaped", ShapedAromicRecipe.class, (RecipeSorter.Category)RecipeSorter.Category.SHAPED, (String)"after:minecraft:shaped before:minecraft:shapeless");
        RecipeSorter.register((String)"aroma1997core:shapeless", ShapelessAromicRecipe.class, (RecipeSorter.Category)RecipeSorter.Category.SHAPELESS, (String)"after:minecraft:shapeless");
        NetworkHelper.getCorePacketHandler();
        LogHelperPre.log(Level.INFO, "Finished Pre-initialization.");
    }

    @Subscribe
    public void init(FMLInitializationEvent event) {
        proxy.init();
        NetworkHelper.getCorePacketHandler().registerMessage(CapePacket.class, CapePacket.class, 0, Side.CLIENT);
        proxy.registerRenderers();
        LogHelperPre.log(Level.INFO, "Finished Initialization.");
    }

    @Subscribe
    public void postInit(FMLPostInitializationEvent event) {
    }

    @Subscribe
    public void serverStartup(FMLServerStartingEvent event) {
        File file = new File(Util.getWorldFolder(), "aroma1997");
        if (!file.exists()) {
            file.mkdir();
        }
        event.registerServerCommand((ICommand)new SleepingCommand(event.getServer()));
        event.registerServerCommand((ICommand)new AromaCommand());
    }

    @NetworkCheckHandler
    public boolean checkModLists(Map<String, String> modList, Side side) {
        return true;
    }

    public File getSource() {
        if (CoreMod.coremodLocation != null) {
            return CoreMod.coremodLocation;
        }
        return super.getSource();
    }
}

