/*
 * Decompiled with CFR 0.152.
 */
package aroma1997.core.coremod.asm;

import aroma1997.core.coremod.asm.AsmUtils;
import aroma1997.core.coremod.asm.BasicTransformer;
import java.lang.reflect.GenericDeclaration;
import java.lang.reflect.Method;
import java.util.HashSet;
import java.util.LinkedList;
import java.util.Set;
import net.minecraft.launchwrapper.Launch;
import org.apache.logging.log4j.Level;
import org.objectweb.asm.tree.AbstractInsnNode;
import org.objectweb.asm.tree.ClassNode;
import org.objectweb.asm.tree.InsnList;
import org.objectweb.asm.tree.InsnNode;
import org.objectweb.asm.tree.MethodInsnNode;
import org.objectweb.asm.tree.MethodNode;
import org.objectweb.asm.tree.VarInsnNode;

public class InterfaceInsertionTransformer
extends BasicTransformer {
    private final String iface;
    private final String redirect;
    private String selfArg;
    private boolean includeDefaults;
    private HashSet<Method> methods;

    protected InterfaceInsertionTransformer(String iface, String redirect) {
        this.iface = iface.replace('.', '/');
        this.redirect = redirect.replace('.', '/');
        this.setSelfArg(AsmUtils.getDescriptorForClass(Object.class));
    }

    protected void setSelfArg(String str) {
        this.selfArg = str.replace('.', '/');
    }

    protected void overrideDefaults(boolean b) {
        this.includeDefaults = b;
    }

    @Override
    public void transform(ClassNode classNode) {
        if (this.methods == null) {
            try {
                Class clazz = Launch.classLoader.findClass(this.iface.replace('/', '.'));
                assert (clazz.isInterface());
                this.methods = new HashSet();
                LinkedList<GenericDeclaration> q = new LinkedList<GenericDeclaration>();
                q.add(clazz);
                while (!q.isEmpty()) {
                    Class current = (Class)q.poll();
                    if (current == null) continue;
                    for (Method method : current.getMethods()) {
                        if (method.isDefault() && !this.includeDefaults) continue;
                        this.methods.add(method);
                    }
                    for (GenericDeclaration genericDeclaration : current.getInterfaces()) {
                        q.add(genericDeclaration);
                    }
                }
            }
            catch (ClassNotFoundException e) {
                throw new RuntimeException("Loaded classes in wrong order. Thos won't work.", e);
            }
        }
        assert (!classNode.interfaces.contains(this.iface));
        classNode.interfaces.add(this.iface);
        logger.log(Level.INFO, "Adding interface " + this.iface + " to class " + classNode.name + " using redirect " + this.redirect);
        HashSet<String> methodsBuffer = new HashSet<String>();
        for (MethodNode mn : classNode.methods) {
            methodsBuffer.add(mn.name + mn.desc);
        }
        for (Method m : this.methods) {
            this.addMethodToClass(m, classNode, methodsBuffer);
        }
    }

    private void addMethodToClass(Method m, ClassNode classNode, Set<String> methodsBuffer) {
        String descriptor = AsmUtils.getMethodDescriptor(m);
        if (methodsBuffer.contains(m.getName() + descriptor)) {
            this.onDuplicateMethod(m, classNode.name, m.getName() + descriptor);
            return;
        }
        MethodNode mn = new MethodNode(1, m.getName(), descriptor, AsmUtils.getDescriptorForClass(m.getReturnType()), null);
        InsnList list = new InsnList();
        list.add((AbstractInsnNode)new VarInsnNode(25, 0));
        int i = 0;
        for (Class<?> arg : m.getParameterTypes()) {
            list.add((AbstractInsnNode)new VarInsnNode(AsmUtils.getLoadCodeForClass(arg), ++i));
        }
        list.add((AbstractInsnNode)new MethodInsnNode(184, this.redirect, m.getName(), "(L" + this.selfArg + ";" + descriptor.substring(1), false));
        list.add((AbstractInsnNode)new InsnNode(AsmUtils.getReturnCodeForClass(m.getReturnType())));
        mn.instructions.insert(list);
        classNode.methods.add(mn);
    }

    protected void onDuplicateMethod(Method m, String name, String method) {
        logger.log(Level.ERROR, "Failed to add interface " + this.iface + " to class " + name + ". Duplicate method " + method);
    }
}

