/*
 * Decompiled with CFR 0.152.
 */
package aroma1997.core.recipes;

import aroma1997.core.recipes.BasicAromicRecipe;
import aroma1997.core.recipes.IAromicRecipe;
import aroma1997.core.recipes.IRecipePart;
import aroma1997.core.recipes.RecipeUtil;
import java.util.HashMap;
import net.minecraft.inventory.InventoryCrafting;
import net.minecraft.item.ItemStack;
import net.minecraft.world.World;

public class ShapedAromicRecipe
extends BasicAromicRecipe {
    static final int MAX_CRAFT_GRID_WIDTH = 3;
    static final int MAX_CRAFT_GRID_HEIGHT = 3;
    IRecipePart[] input = null;
    int width = 0;
    int height = 0;
    private boolean enableMirror = true;

    ShapedAromicRecipe() {
        super(null);
    }

    public ShapedAromicRecipe(ItemStack result, Object ... recipe) {
        super(result);
        String shape = "";
        int idx = 0;
        if (recipe[idx] instanceof String[]) {
            String[] parts = (String[])recipe[idx++];
            for (String s : parts) {
                this.width = s.length();
                shape = shape + (String)s;
            }
            this.height = parts.length;
        } else {
            while (recipe[idx] instanceof String) {
                String s = (String)recipe[idx++];
                shape = shape + s;
                this.width = s.length();
                ++this.height;
            }
        }
        if (this.width * this.height != shape.length()) {
            String ret = "Invalid shaped aromic recipe: ";
            for (Object tmp : recipe) {
                ret = ret + tmp + ", ";
            }
            ret = ret + this.func_77571_b();
            throw new RuntimeException(ret);
        }
        HashMap<Character, IRecipePart> itemMap = new HashMap<Character, IRecipePart>();
        while (idx < recipe.length) {
            Character chr = (Character)recipe[idx];
            Object in = recipe[idx + 1];
            itemMap.put(chr, RecipeUtil.getRecipePart(in));
            idx += 2;
        }
        this.input = new IRecipePart[this.width * this.height];
        int x = 0;
        for (char chr : shape.toCharArray()) {
            this.input[x++] = (IRecipePart)itemMap.get(Character.valueOf(chr));
        }
    }

    public ItemStack func_77572_b(InventoryCrafting var1) {
        return this.adjustOutput(this.func_77571_b(), var1);
    }

    public int func_77570_a() {
        return this.input.length;
    }

    public boolean func_77569_a(InventoryCrafting inv, World world) {
        for (int x = 0; x <= 3 - this.width; ++x) {
            for (int y = 0; y <= 3 - this.height; ++y) {
                if (!this.checkMatch(inv, x, y, false) && (!this.enableMirror || !this.checkMatch(inv, x, y, true))) continue;
                return true;
            }
        }
        return false;
    }

    boolean checkMatch(InventoryCrafting inv, int startX, int startY, boolean mirror) {
        for (int x = 0; x < 3; ++x) {
            for (int y = 0; y < 3; ++y) {
                int subX = x - startX;
                int subY = y - startY;
                IRecipePart target = null;
                if (subX >= 0 && subY >= 0 && subX < this.width && subY < this.height) {
                    target = mirror ? this.input[this.width - subX - 1 + subY * this.width] : this.input[subX + subY * this.width];
                }
                ItemStack slot = inv.func_70463_b(x, y);
                if (target == null) {
                    if (slot.func_190926_b()) continue;
                    return false;
                }
                if (target.doesItemMatch(slot) && (target.getAmount(slot) <= slot.func_190916_E() || !this.checkStackSize())) continue;
                return false;
            }
        }
        return true;
    }

    @Override
    public IRecipePart[] getInput() {
        return this.input;
    }

    public int getRecipeWidth() {
        return this.width;
    }

    public int getRecipeHeight() {
        return this.height;
    }

    @Override
    public boolean isMirrorOK() {
        return this.enableMirror;
    }

    @Override
    public IAromicRecipe setMirrorOK(boolean mirrorok) {
        this.enableMirror = mirrorok;
        return this;
    }
}

