/*
 * Decompiled with CFR 0.152.
 */
package aroma1997.core.util;

import aroma1997.core.client.util.Colors;
import java.util.ArrayList;
import net.minecraft.block.Block;
import net.minecraft.init.Items;
import net.minecraft.item.Item;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.NBTBase;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.nbt.NBTTagList;
import net.minecraft.nbt.NBTTagString;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.text.translation.I18n;

public class ItemUtil {
    public static ItemStack getWrittenBook(String name, String author, boolean isLocalized, String ... pages) {
        if (pages == null || pages.length == 0) {
            return null;
        }
        ItemStack item = new ItemStack(Items.field_151164_bB);
        item.func_77983_a("author", (NBTBase)new NBTTagString(author));
        item.func_77983_a("title", (NBTBase)new NBTTagString(isLocalized ? I18n.func_74838_a((String)name) : name));
        NBTTagList pagesList = new NBTTagList();
        for (int i = 0; i < pages.length; ++i) {
            String str = null;
            str = !pages[i].contains("chapter") ? (isLocalized ? I18n.func_74838_a((String)pages[i]) : pages[i]) : Colors.BOLD.toString() + (Object)((Object)Colors.UNDERLINE) + (isLocalized ? I18n.func_74838_a((String)pages[i]) : pages[i]);
            pagesList.func_74742_a((NBTBase)new NBTTagString(str));
        }
        item.func_77983_a("pages", (NBTBase)pagesList);
        return item;
    }

    @Deprecated
    public static boolean areItemsSame(ItemStack item1, ItemStack item2) {
        return ItemUtil.areItemsSameMatching(item1, item2, IItemMatchCriteria.ID, IItemMatchCriteria.DAMAGE, IItemMatchCriteria.NBT);
    }

    public static boolean areItemsSameMatching(ItemStack item1, ItemStack item2, IItemMatchCriteria ... crits) {
        if (crits == null || crits.length <= 0) {
            return true;
        }
        if (item1 == null && item2 == null) {
            return true;
        }
        if (item1 == null || item2 == null) {
            return false;
        }
        for (IItemMatchCriteria crit : crits) {
            if (crit.checkFor(item1, item2)) continue;
            return false;
        }
        return true;
    }

    public static ArrayList<ItemStack> getItemsFromClass(Class<?> claSS) {
        ArrayList<ItemStack> list = new ArrayList<ItemStack>();
        for (Item item : Item.field_150901_e) {
            if (item == null || !claSS.isInstance(item)) continue;
            list.add(new ItemStack(item, 1, Short.MAX_VALUE));
        }
        for (Block block : Block.field_149771_c) {
            if (block == null || !claSS.isInstance(block)) continue;
            list.add(new ItemStack(block, 1, Short.MAX_VALUE));
        }
        return list;
    }

    public static BlockPos getPos(ItemStack stack) {
        if (!stack.func_77942_o() || !stack.func_77978_p().func_74764_b("position")) {
            return BlockPos.field_177992_a;
        }
        NBTTagCompound tag = stack.func_77978_p().func_74775_l("position");
        return new BlockPos(tag.func_74762_e("x"), tag.func_74762_e("y"), tag.func_74762_e("z"));
    }

    public static void setPos(ItemStack stack, BlockPos pos) {
        NBTTagCompound posTag = new NBTTagCompound();
        posTag.func_74768_a("x", pos.func_177958_n());
        posTag.func_74768_a("y", pos.func_177956_o());
        posTag.func_74768_a("z", pos.func_177952_p());
        if (!stack.func_77942_o()) {
            stack.func_77982_d(new NBTTagCompound());
        }
        stack.func_77978_p().func_74782_a("position", (NBTBase)posTag);
    }

    public static interface IItemMatchCriteria {
        public static final IItemMatchCriteria NBT = new MatchNBT();
        public static final IItemMatchCriteria ID = new MatchID();
        public static final IItemMatchCriteria CLASS = new MatchCLASS();
        public static final IItemMatchCriteria DAMAGE = new MatchDAMAGE();
        public static final IItemMatchCriteria WILDCARD = new MatchWILDCARD();
        public static final IItemMatchCriteria NBT_ADVANCED = new MatchNBTAdvanced();

        public boolean checkFor(ItemStack var1, ItemStack var2);

        public static class MatchNBTAdvanced
        implements IItemMatchCriteria {
            @Override
            public boolean checkFor(ItemStack item1, ItemStack item2) {
                if (!item2.func_77942_o() || item2.func_77978_p().func_82582_d()) {
                    return true;
                }
                if (!item1.func_77942_o() || item1.func_77978_p().func_82582_d()) {
                    return false;
                }
                for (String name : item2.func_77978_p().func_150296_c()) {
                    NBTBase nbt = item2.func_77978_p().func_74781_a(name);
                    if (!item1.func_77978_p().func_150297_b(name, (int)nbt.func_74732_a())) {
                        return false;
                    }
                    if (item1.func_77978_p().func_74781_a(name).equals((Object)nbt)) continue;
                    return false;
                }
                return true;
            }
        }

        public static class MatchWILDCARD
        implements IItemMatchCriteria {
            @Override
            public boolean checkFor(ItemStack item1, ItemStack item2) {
                return ID.checkFor(item1, item2) && (DAMAGE.checkFor(item1, item2) || item2.func_77960_j() == Short.MAX_VALUE);
            }
        }

        public static class MatchDAMAGE
        implements IItemMatchCriteria {
            @Override
            public boolean checkFor(ItemStack item1, ItemStack item2) {
                return item1.func_77960_j() == item2.func_77960_j();
            }
        }

        public static class MatchCLASS
        implements IItemMatchCriteria {
            @Override
            public boolean checkFor(ItemStack item1, ItemStack item2) {
                return item1.func_77973_b().getClass().equals(item2.func_77973_b().getClass());
            }
        }

        public static class MatchNBT
        implements IItemMatchCriteria {
            @Override
            public boolean checkFor(ItemStack item1, ItemStack item2) {
                return ItemStack.func_77970_a((ItemStack)item1, (ItemStack)item2);
            }
        }

        public static class MatchID
        implements IItemMatchCriteria {
            @Override
            public boolean checkFor(ItemStack item1, ItemStack item2) {
                return Item.field_150901_e.func_177774_c((Object)item1.func_77973_b()) == Item.field_150901_e.func_177774_c((Object)item2.func_77973_b());
            }
        }
    }
}

