/*
 * Decompiled with CFR 0.152.
 */
package aroma1997.betterchests;

import aroma1997.betterchests.BetterChests;
import aroma1997.betterchests.ItemUpgrade;
import aroma1997.betterchests.Upgrade;
import aroma1997.core.client.util.Colors;
import aroma1997.core.misc.FakePlayerFactory;
import java.util.HashMap;
import java.util.Random;
import net.minecraft.block.Block;
import net.minecraft.client.Minecraft;
import net.minecraft.entity.Entity;
import net.minecraft.entity.item.EntityItem;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.inventory.Container;
import net.minecraft.inventory.IInventory;
import net.minecraft.item.Item;
import net.minecraft.item.ItemStack;
import net.minecraft.item.crafting.FurnaceRecipes;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.network.INetworkManager;
import net.minecraft.network.packet.Packet;
import net.minecraft.network.packet.Packet132TileEntityData;
import net.minecraft.server.MinecraftServer;
import net.minecraft.tileentity.Hopper;
import net.minecraft.tileentity.TileEntityChest;
import net.minecraft.tileentity.TileEntityHopper;
import net.minecraft.util.DamageSource;
import net.minecraft.util.MathHelper;
import net.minecraft.world.World;

public class TileEntityBChest
extends TileEntityChest
implements Hopper {
    private String player = "";
    private int tick;
    private EntityPlayer fplayer;
    private HashMap<Upgrade, Integer> upgrades = new HashMap();

    public TileEntityBChest() {
        this.tick = new Random().nextInt(64);
        for (Upgrade upgrade : Upgrade.values()) {
            this.upgrades.put(upgrade, 0);
        }
    }

    public String func_70303_b() {
        if (this.isUpgradeInstalled(Upgrade.VOID)) {
            return Colors.RED + "Void Chest";
        }
        if (this.isUpgradeInstalled(Upgrade.PLAYER)) {
            return Colors.YELLOW + this.player + "'s Chest";
        }
        return "Adjustable Chest";
    }

    public ItemStack func_70301_a(int slot) {
        if (slot >= this.func_70302_i_()) {
            return null;
        }
        return super.func_70301_a(slot);
    }

    public void func_70312_q() {
        super.func_70312_q();
        if (!this.field_70331_k.field_72995_K) {
            this.fplayer = FakePlayerFactory.getFakePlayer((World)this.field_70331_k);
            this.fplayer.field_70165_t = this.field_70329_l;
            this.fplayer.field_70163_u = this.field_70330_m;
            this.fplayer.field_70161_v = this.field_70327_n;
        }
    }

    public void func_70316_g() {
        int i;
        int i2;
        super.func_70316_g();
        if (this.field_70331_k.field_72995_K) {
            return;
        }
        if (this.tick-- <= 0) {
            this.tick = 64;
            this.func_70296_d();
            this.updateBlock(this.field_70329_l + 1, this.field_70330_m, this.field_70327_n);
            this.updateBlock(this.field_70329_l - 1, this.field_70330_m, this.field_70327_n);
            this.updateBlock(this.field_70329_l, this.field_70330_m, this.field_70327_n + 1);
            this.updateBlock(this.field_70329_l, this.field_70330_m, this.field_70327_n - 1);
            this.updateBlock(this.field_70329_l, this.field_70330_m + 1, this.field_70327_n);
            this.updateBlock(this.field_70329_l, this.field_70330_m - 1, this.field_70327_n);
        }
        if (this.isUpgradeInstalled(Upgrade.VOID)) {
            for (i2 = 0; i2 < this.func_70302_i_(); ++i2) {
                if (this.func_70301_a(i2) == null) continue;
                this.func_70298_a(i2, this.func_70301_a((int)i2).field_77994_a);
            }
        }
        if (this.isUpgradeInstalled(Upgrade.RAIN) && this.field_70331_k.func_72937_j(this.field_70329_l, this.field_70330_m, this.field_70327_n) && this.field_70331_k.func_72896_J()) {
            Random random = new Random();
            if (random.nextFloat() > 0.8f && this.tick == 20) {
                int bucketEmpty = -1;
                int emptySpace = -1;
                for (int i3 = 0; i3 < this.func_70302_i_(); ++i3) {
                    if (this.func_70301_a(i3) != null && this.func_70301_a((int)i3).field_77993_c == Item.field_77788_aw.field_77779_bT && bucketEmpty == -1) {
                        bucketEmpty = i3;
                        if (this.func_70301_a((int)i3).field_77994_a != 1) continue;
                        emptySpace = i3;
                        break;
                    }
                    if (emptySpace != -1 || this.func_70301_a(i3) != null) continue;
                    emptySpace = i3;
                }
                if (bucketEmpty == -1 || emptySpace == -1) {
                    return;
                }
                this.func_70298_a(bucketEmpty, 1);
                this.func_70299_a(emptySpace, new ItemStack(Item.field_77786_ax));
            }
        }
        if (this.isUpgradeInstalled(Upgrade.COBBLEGEN) && this.tick == 30) {
            int bucketLava = -1;
            int bucketWater = -1;
            int empty = -1;
            for (i = 0; i < this.func_70302_i_(); ++i) {
                if (this.func_70301_a(i) != null && this.func_70301_a((int)i).field_77993_c == Item.field_77786_ax.field_77779_bT && bucketWater == -1) {
                    bucketWater = i;
                    continue;
                }
                if (this.func_70301_a(i) != null && bucketLava == -1 && this.func_70301_a((int)i).field_77993_c == Item.field_77775_ay.field_77779_bT) {
                    bucketLava = i;
                    continue;
                }
                if (empty != -1 || this.func_70301_a(i) != null && (this.func_70301_a(i) == null || this.func_70301_a((int)i).field_77993_c != Block.field_71978_w.field_71990_ca || this.func_70301_a((int)i).field_77994_a >= this.func_70301_a(i).func_77976_d())) continue;
                empty = i;
            }
            if (bucketLava == -1 || bucketWater == -1 || empty == -1) {
                return;
            }
            int amount = this.func_70301_a(empty) == null ? 1 : 1 + this.func_70301_a((int)empty).field_77994_a;
            this.func_70299_a(empty, new ItemStack(Block.field_71978_w, amount));
        }
        if (this.isUpgradeInstalled(Upgrade.FURNACE) && this.tick == 40 && this.hasEnergy()) {
            int cooking = -1;
            for (int i4 = 0; i4 < this.func_70302_i_(); ++i4) {
                ItemStack stack = this.func_70301_a(i4);
                if (stack == null || FurnaceRecipes.func_77602_a().getSmeltingResult(stack) == null) continue;
                cooking = i4;
                break;
            }
            if (cooking != -1) {
                ItemStack smelted = FurnaceRecipes.func_77602_a().getSmeltingResult(this.func_70301_a(cooking)).func_77946_l();
                if (smelted.field_77994_a <= 0) {
                    smelted.field_77994_a = 1;
                }
                int result = -1;
                for (i = 0; i < this.func_70302_i_(); ++i) {
                    if (this.func_70301_a(i) != null && (!smelted.func_77969_a(this.func_70301_a(i)) || smelted.field_77994_a + this.func_70301_a((int)i).field_77994_a > 64)) continue;
                    result = i;
                    break;
                }
                if (result != -1) {
                    this.func_70298_a(cooking, 1);
                    ItemStack put = this.func_70301_a(result);
                    if (put != null) {
                        put.field_77994_a += smelted.field_77994_a;
                    } else {
                        put = smelted;
                    }
                    this.func_70299_a(result, put);
                }
            }
        }
        if (this.isUpgradeInstalled(Upgrade.COLLECTOR) && this.tick == 50) {
            for (i2 = -this.getAmountUpgrade(Upgrade.COLLECTOR); i2 <= this.getAmountUpgrade(Upgrade.COLLECTOR); ++i2) {
                for (int j = -this.getAmountUpgrade(Upgrade.COLLECTOR); j <= this.getAmountUpgrade(Upgrade.COLLECTOR); ++j) {
                    for (int k = 0; k <= 1; ++k) {
                        EntityItem entityitem = TileEntityHopper.func_96119_a((World)this.field_70331_k, (double)(this.field_70329_l + i2), (double)((double)this.field_70330_m + (double)k), (double)(this.field_70327_n + j));
                        if (entityitem == null) continue;
                        TileEntityHopper.func_96114_a((IInventory)this, (EntityItem)entityitem);
                    }
                }
            }
        }
        if (this.isUpgradeInstalled(Upgrade.TICKING) && this.tick % 8 == 0) {
            for (i2 = 0; i2 < this.func_70302_i_(); ++i2) {
                ItemStack item = this.func_70301_a(i2);
                if (item == null || item.func_77973_b() == null) continue;
                this.fplayer.field_71071_by.field_70462_a[0] = this.func_70301_a(i2);
                this.fplayer.field_71071_by.func_70296_d();
                item.func_77973_b().func_77663_a(item, this.field_70331_k, (Entity)this.fplayer, 0, false);
                this.func_70296_d();
            }
        }
    }

    public Packet func_70319_e() {
        NBTTagCompound nbt = new NBTTagCompound();
        this.func_70310_b(nbt);
        Packet132TileEntityData packet = new Packet132TileEntityData();
        packet.field_73331_e = nbt;
        return packet;
    }

    public void onDataPacket(INetworkManager net, Packet132TileEntityData packet) {
        this.func_70307_a(packet.field_73331_e);
    }

    public int func_70302_i_() {
        return 9 + this.getAmountUpgrade(Upgrade.SLOT) * 9;
    }

    public boolean func_70300_a(EntityPlayer par1EntityPlayer) {
        if (!super.func_70300_a(par1EntityPlayer)) {
            return false;
        }
        if (!this.isUpgradeInstalled(Upgrade.PLAYER)) {
            return true;
        }
        if (!MinecraftServer.func_71276_C().func_71262_S() && par1EntityPlayer.field_71092_bJ.equalsIgnoreCase(Minecraft.func_71410_x().field_71439_g.field_71092_bJ)) {
            return true;
        }
        return MinecraftServer.func_71196_a((MinecraftServer)MinecraftServer.func_71276_C()).func_72376_i().contains(par1EntityPlayer.field_71092_bJ) || this.player.equalsIgnoreCase(par1EntityPlayer.field_71092_bJ);
    }

    public boolean upgrade(EntityPlayer player) {
        if (!(player.func_70694_bm().func_77973_b() instanceof ItemUpgrade) || !this.func_70300_a(player)) {
            return false;
        }
        ItemStack item = player.func_70694_bm();
        Upgrade upgrade = Upgrade.values()[item.func_77960_j()];
        if (this.getAmountUpgrade(upgrade) < upgrade.getMaxAmount() && (upgrade.getRequirement() == null || this.isUpgradeInstalled(upgrade.getRequirement()))) {
            this.setAmountUpgrade(upgrade, this.getAmountUpgrade(upgrade) + 1);
            if (upgrade == Upgrade.PLAYER) {
                this.player = player.field_71092_bJ;
            }
            this.onUpgradeInserted(player);
            return true;
        }
        return false;
    }

    private int getAmountUpgrade(Upgrade upgrade) {
        return this.upgrades.get((Object)upgrade);
    }

    public void func_70307_a(NBTTagCompound nbt) {
        if (nbt.func_74764_b("slotLimit")) {
            this.readFromNBTOld(nbt);
            return;
        }
        for (Upgrade upgrade : Upgrade.values()) {
            this.setAmountUpgrade(upgrade, nbt.func_74762_e(upgrade.toString()));
        }
        this.player = nbt.func_74779_i("player");
        super.func_70307_a(nbt);
    }

    private void readFromNBTOld(NBTTagCompound par1NBTTagCompound) {
        this.setAmountUpgrade(Upgrade.SLOT, par1NBTTagCompound.func_74765_d("slotLimit"));
        this.setAmountUpgrade(Upgrade.REDSTONE, par1NBTTagCompound.func_74767_n("redstoneUpgrade") ? 1 : 0);
        this.setAmountUpgrade(Upgrade.LIGHT, par1NBTTagCompound.func_74767_n("light") ? 1 : 0);
        this.setAmountUpgrade(Upgrade.COMPARATOR, par1NBTTagCompound.func_74767_n("comparator") ? 1 : 0);
        this.setAmountUpgrade(Upgrade.PLAYER, par1NBTTagCompound.func_74767_n("playerUpgrade") ? 1 : 0);
        this.setAmountUpgrade(Upgrade.VOID, par1NBTTagCompound.func_74767_n("voidU") ? 1 : 0);
        this.setAmountUpgrade(Upgrade.UNBREAKABLE, par1NBTTagCompound.func_74767_n("indestructable") ? 1 : 0);
        this.setAmountUpgrade(Upgrade.RAIN, par1NBTTagCompound.func_74767_n("rain") ? 1 : 0);
        this.setAmountUpgrade(Upgrade.COBBLEGEN, par1NBTTagCompound.func_74767_n("cobbleGen") ? 1 : 0);
        this.setAmountUpgrade(Upgrade.SOLAR, par1NBTTagCompound.func_74767_n("solar") ? 1 : 0);
        this.setAmountUpgrade(Upgrade.FURNACE, par1NBTTagCompound.func_74767_n("furnace") ? 1 : 0);
        this.setAmountUpgrade(Upgrade.COLLECTOR, par1NBTTagCompound.func_74767_n("suckItems") ? 1 : 0);
        this.setAmountUpgrade(Upgrade.TICKING, par1NBTTagCompound.func_74767_n("ticking") ? 1 : 0);
        this.player = par1NBTTagCompound.func_74779_i("player");
        super.func_70307_a(par1NBTTagCompound);
    }

    public void func_70310_b(NBTTagCompound nbt) {
        super.func_70310_b(nbt);
        for (Upgrade upgrade : Upgrade.values()) {
            nbt.func_74768_a(upgrade.toString(), this.getAmountUpgrade(upgrade));
        }
        nbt.func_74778_a("player", this.player);
    }

    private void onUpgradeInserted(EntityPlayer player) {
        --player.field_71071_by.field_70462_a[player.field_71071_by.field_70461_c].field_77994_a;
        NBTTagCompound nbttagcompound = new NBTTagCompound();
        this.func_70310_b(nbttagcompound);
        this.func_70307_a(nbttagcompound);
        this.func_70296_d();
    }

    public int getLightValue() {
        return this.isUpgradeInstalled(Upgrade.LIGHT) ? 15 : 0;
    }

    public int getComparatorOutput() {
        if (!this.isUpgradeInstalled(Upgrade.COMPARATOR)) {
            return 0;
        }
        if (this.isUpgradeInstalled(Upgrade.RAIN)) {
            int w = 0;
            int e = 0;
            for (int i = 0; i < this.func_70302_i_(); ++i) {
                if (this.func_70301_a(i) != null && this.func_70301_a((int)i).field_77993_c == Item.field_77786_ax.field_77779_bT) {
                    ++w;
                }
                if (this.func_70301_a(i) == null || this.func_70301_a((int)i).field_77993_c != Item.field_77788_aw.field_77779_bT) continue;
                e += this.func_70301_a((int)i).field_77994_a;
            }
            if (w == 0) {
                return 0;
            }
            if (e == 0) {
                return 15;
            }
            return (int)((float)w / ((float)e + (float)w) * 15.0f);
        }
        return Container.func_94526_b((IInventory)this);
    }

    public void playerOpenChest(EntityPlayer player) {
        if (!this.isUpgradeInstalled(Upgrade.PLAYER)) {
            return;
        }
        if (this.func_70300_a(player)) {
            return;
        }
        player.func_70097_a(DamageSource.field_76380_i, 5.0f);
    }

    public ItemStack[] getItemUpgrades() {
        int amount = 0;
        for (Upgrade upgrade : Upgrade.values()) {
            if (!this.isUpgradeInstalled(upgrade)) continue;
            ++amount;
        }
        ItemStack[] items = new ItemStack[amount];
        int pos = 0;
        for (Upgrade upgrade : Upgrade.values()) {
            if (!this.isUpgradeInstalled(upgrade)) continue;
            items[pos] = new ItemStack((Item)BetterChests.upgrade, this.getAmountUpgrade(upgrade), upgrade.ordinal());
            ++pos;
        }
        return items;
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    private boolean hasEnergy() {
        if (!this.isUpgradeInstalled(Upgrade.SOLAR)) return false;
        if (this.field_70331_k.func_72937_j(this.field_70329_l, this.field_70330_m, this.field_70327_n)) {
            if (this.field_70331_k.func_72935_r()) return true;
        }
        Random random = new Random();
        if (!(random.nextFloat() > 0.8f)) return false;
        return true;
    }

    public double func_96107_aA() {
        return this.field_70329_l;
    }

    public double func_96109_aB() {
        return this.field_70330_m;
    }

    public double func_96108_aC() {
        return this.field_70327_n;
    }

    public int getRedstoneOutput() {
        if (!this.isUpgradeInstalled(Upgrade.REDSTONE)) {
            return 0;
        }
        if (this.isUpgradeInstalled(Upgrade.RAIN)) {
            if (this.field_70331_k.func_72911_I()) {
                return 2;
            }
            if (this.field_70331_k.func_72896_J()) {
                return 1;
            }
            return 0;
        }
        return MathHelper.func_76125_a((int)this.field_70427_h, (int)0, (int)15);
    }

    private void updateBlock(int x, int y, int z) {
        if (this.field_70331_k.func_72799_c(x, y, z)) {
            return;
        }
        Block.field_71973_m[this.field_70331_k.func_72798_a(x, y, z)].func_71863_a(this.field_70331_k, x, y, z, BetterChests.chest.field_71990_ca);
    }

    public boolean isUpgradeInstalled(Upgrade upgrade) {
        return this.getAmountUpgrade(upgrade) > 0;
    }

    private void setAmountUpgrade(Upgrade upgrade, int amount) {
        this.upgrades.remove((Object)upgrade);
        this.upgrades.put(upgrade, amount);
    }
}

