/*
 * Decompiled with CFR 0.152.
 */
package aroma1997.betterchests;

import aroma1997.betterchests.BetterChests;
import aroma1997.core.client.util.Colors;
import cpw.mods.fml.common.registry.GameRegistry;
import net.minecraft.block.Block;
import net.minecraft.item.Item;
import net.minecraft.item.ItemStack;

public enum Upgrade {
    SLOT("Slot Upgrade", "Gives you 9 more Slots.", null, 5),
    COBBLEGEN("Cobblestone Generator", "This lets your chest create Cobblestone with Lava and Water", null, 1),
    REDSTONE("Redstone Upgrade", "Outputs a redstone signal, when somebody opens the chest.", null, 1),
    LIGHT("Light Upgrade", "Makes the Chest emit light. " + Colors.RED + "Does not work yet.", null, 1),
    BASIC("Upgrade Case", "This is only needed to craft the other upgrades.", null, 0),
    COMPARATOR("Comparator Upgrade", "This Upgrade will enable the usage of the Comparators.", null, 1),
    VOID("Void Upgrade", "This will destroy all Items that enter the Chest.", null, 1),
    UNBREAKABLE("Unbreakable Upgrade", "This will make Entitys no longer able to destroy the chest. (Wither,...)", null, 1),
    PLAYER("Player Upgrade", "This will make the chest accessable only for you.", UNBREAKABLE, 1),
    RAIN("Rain Upgrade", "This will fill buckets in the Chest with Water.", null, 1),
    SOLAR("Solar Upgrade", "This will supply your chest Power.", null, 1),
    FURNACE("Furnace Upgrade", "With this Upgrade, your chest will smelt.", SOLAR, 1),
    COLLECTOR("Collector Upgrade", "Lets the chest collect Items around it. Radius increase by 1.", SOLAR, 8),
    TICKING("Ticking Upgrade", "Ticks the Items as in a Player Inventory.", SOLAR, 1);

    private String name;
    private String tooltip;
    private Upgrade requirement;
    private int max;

    private Upgrade(String name, String tooltip, Upgrade requirement, int max) {
        this.name = name;
        this.tooltip = tooltip;
        this.requirement = requirement;
        this.max = max;
    }

    public String getName() {
        return this.name;
    }

    public String getTooltip() {
        return this.tooltip;
    }

    public String getTexture() {
        return "BetterChests:" + this.toString().toLowerCase();
    }

    public Upgrade getRequirement() {
        return this.requirement;
    }

    public static void generateRecipes() {
        int itemID = BetterChests.upgrade.field_77779_bT;
        ItemStack itemUpgrade = new ItemStack(itemID, 1, BASIC.ordinal());
        GameRegistry.addRecipe((ItemStack)new ItemStack(itemID, 8, BASIC.ordinal()), (Object[])new Object[]{"WIW", "ISI", "WIW", Character.valueOf('W'), new ItemStack(Block.field_71988_x, 1, Short.MAX_VALUE), Character.valueOf('I'), new ItemStack(Block.field_72002_bp), Character.valueOf('S'), new ItemStack(Item.field_77669_D)});
        GameRegistry.addRecipe((ItemStack)new ItemStack(itemID, 1, SLOT.ordinal()), (Object[])new Object[]{" W ", "WUW", " W ", Character.valueOf('W'), new ItemStack(Block.field_71988_x, 1, Short.MAX_VALUE), Character.valueOf('U'), itemUpgrade});
        GameRegistry.addRecipe((ItemStack)new ItemStack(itemID, 1, REDSTONE.ordinal()), (Object[])new Object[]{"RRR", "RUR", "RRR", Character.valueOf('R'), new ItemStack(Item.field_77767_aC), Character.valueOf('U'), itemUpgrade});
        GameRegistry.addRecipe((ItemStack)new ItemStack(itemID, 1, COMPARATOR.ordinal()), (Object[])new Object[]{" Q ", "RUR", " Q ", Character.valueOf('Q'), new ItemStack(Item.field_94583_ca), Character.valueOf('R'), new ItemStack(Item.field_77767_aC), Character.valueOf('U'), itemUpgrade});
        GameRegistry.addRecipe((ItemStack)new ItemStack(itemID, 1, COMPARATOR.ordinal()), (Object[])new Object[]{" R ", "QUQ", " R ", Character.valueOf('Q'), new ItemStack(Item.field_94583_ca), Character.valueOf('R'), new ItemStack(Item.field_77767_aC), Character.valueOf('U'), itemUpgrade});
        GameRegistry.addRecipe((ItemStack)new ItemStack(itemID, 1, PLAYER.ordinal()), (Object[])new Object[]{"OQO", "QUQ", "OQO", Character.valueOf('Q'), new ItemStack(Item.field_94583_ca), Character.valueOf('O'), new ItemStack(Block.field_72089_ap), Character.valueOf('U'), itemUpgrade});
        GameRegistry.addRecipe((ItemStack)new ItemStack(itemID, 1, COBBLEGEN.ordinal()), (Object[])new Object[]{"CCC", "LUW", "BBB", Character.valueOf('C'), new ItemStack(Block.field_71978_w), Character.valueOf('L'), new ItemStack(Item.field_77775_ay), Character.valueOf('U'), itemUpgrade, Character.valueOf('W'), new ItemStack(Item.field_77786_ax), Character.valueOf('B'), new ItemStack(Item.field_77788_aw)});
        GameRegistry.addRecipe((ItemStack)new ItemStack(itemID, 1, VOID.ordinal()), (Object[])new Object[]{" E ", "RUR", " E ", Character.valueOf('E'), new ItemStack(Item.field_77730_bn), Character.valueOf('R'), new ItemStack(Item.field_77767_aC), Character.valueOf('U'), itemUpgrade});
        GameRegistry.addRecipe((ItemStack)new ItemStack(itemID, 1, UNBREAKABLE.ordinal()), (Object[])new Object[]{"OOO", "OUO", "OOO", Character.valueOf('O'), new ItemStack(Block.field_72089_ap), Character.valueOf('U'), itemUpgrade});
        GameRegistry.addRecipe((ItemStack)new ItemStack(itemID, 1, RAIN.ordinal()), (Object[])new Object[]{" B ", "BUB", " B ", Character.valueOf('B'), new ItemStack(Item.field_77788_aw), Character.valueOf('U'), itemUpgrade});
        GameRegistry.addRecipe((ItemStack)new ItemStack(itemID, 1, SOLAR.ordinal()), (Object[])new Object[]{"QSQ", "RUR", "QCQ", Character.valueOf('S'), new ItemStack((Block)Block.field_94344_cp), Character.valueOf('R'), new ItemStack(Item.field_77767_aC), Character.valueOf('C'), new ItemStack(Item.field_77742_bb), Character.valueOf('Q'), new ItemStack(Item.field_94583_ca), Character.valueOf('R'), new ItemStack(Item.field_77767_aC), Character.valueOf('U'), itemUpgrade});
        GameRegistry.addRecipe((ItemStack)new ItemStack(itemID, 1, FURNACE.ordinal()), (Object[])new Object[]{"RFR", "FUF", "RFR", Character.valueOf('R'), new ItemStack(Item.field_77767_aC), Character.valueOf('F'), new ItemStack(Block.field_72051_aB), Character.valueOf('U'), itemUpgrade});
        GameRegistry.addRecipe((ItemStack)new ItemStack(itemID, 1, COLLECTOR.ordinal()), (Object[])new Object[]{" H ", "HUH", "RER", Character.valueOf('H'), new ItemStack((Block)Block.field_94340_cs), Character.valueOf('R'), new ItemStack(Item.field_77767_aC), Character.valueOf('E'), new ItemStack(Item.field_77730_bn), Character.valueOf('U'), itemUpgrade});
        GameRegistry.addRecipe((ItemStack)new ItemStack(itemID, 1, TICKING.ordinal()), (Object[])new Object[]{"QCQ", "RUR", "QCQ", Character.valueOf('Q'), new ItemStack(Item.field_94583_ca), Character.valueOf('C'), new ItemStack(Item.field_77752_aS), Character.valueOf('R'), new ItemStack(Item.field_94585_bY), Character.valueOf('U'), itemUpgrade});
        for (Upgrade upgr : Upgrade.values()) {
            if (upgr == BASIC) continue;
            GameRegistry.addShapelessRecipe((ItemStack)itemUpgrade, (Object[])new Object[]{new ItemStack(itemID, 1, upgr.ordinal())});
        }
    }

    public int getMaxAmount() {
        return this.max;
    }
}

