/*
 * Decompiled with CFR 0.152.
 */
package aroma1997.betterchests;

import aroma1997.betterchests.BetterChests;
import aroma1997.betterchests.Upgrade;
import aroma1997.betterchests.UpgradeHelper;
import aroma1997.betterchests.api.IBetterChest;
import aroma1997.betterchests.api.IUpgrade;
import aroma1997.core.client.util.Colors;
import aroma1997.core.util.InvUtil;
import aroma1997.core.util.ItemUtil;
import cpw.mods.fml.relauncher.Side;
import cpw.mods.fml.relauncher.SideOnly;
import java.util.ArrayList;
import java.util.List;
import net.minecraft.client.gui.inventory.GuiContainer;
import net.minecraft.client.renderer.texture.IconRegister;
import net.minecraft.creativetab.CreativeTabs;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.inventory.Container;
import net.minecraft.inventory.IInventory;
import net.minecraft.item.Item;
import net.minecraft.item.ItemStack;
import net.minecraft.util.Icon;
import net.minecraft.util.StatCollector;
import net.minecraft.world.World;

public class ItemUpgrade
extends Item
implements IUpgrade {
    private Icon[] itemIcons;

    public ItemUpgrade(int id) {
        super(id);
        this.func_77637_a(BetterChests.creativeTabBC);
        this.func_77627_a(true);
    }

    public void func_77624_a(ItemStack par1ItemStack, EntityPlayer par2EntityPlayer, List par3List, boolean par4) {
        Upgrade upgrade = Upgrade.values()[par1ItemStack.func_77960_j()];
        if (upgrade.getRequirement() != null) {
            par3List.add(StatCollector.func_74837_a((String)"info.betterchests:tooltip.requires", (Object[])new Object[]{Colors.YELLOW + upgrade.getRequirement().getName()}));
        }
        if (upgrade.getMaxAmount() != 0) {
            par3List.add(StatCollector.func_74837_a((String)"info.betterchests:tooltip.maxamount", (Object[])new Object[]{upgrade.getMaxAmount()}));
        }
        if (upgrade.canBagTakeUpgrade() || upgrade.canChestTakeUpgrade()) {
            if (!upgrade.canChestTakeUpgrade()) {
                par3List.add(StatCollector.func_74838_a((String)"info.betterchests:tooltip.nochest"));
            } else if (!upgrade.canBagTakeUpgrade()) {
                par3List.add(StatCollector.func_74838_a((String)"info.betterchests:tooltip.nobag"));
            }
        }
    }

    public void func_77633_a(int par1, CreativeTabs par2CreativeTabs, List par3List) {
        for (int i = 0; i < Upgrade.values().length; ++i) {
            par3List.add(new ItemStack(this.field_77779_bT, 1, i));
        }
    }

    @SideOnly(value=Side.CLIENT)
    public void func_94581_a(IconRegister iconRegister) {
        this.itemIcons = new Icon[Upgrade.values().length];
        for (int i = 0; i < this.itemIcons.length; ++i) {
            this.itemIcons[i] = iconRegister.func_94245_a(Upgrade.values()[i].getTexture());
        }
    }

    @SideOnly(value=Side.CLIENT)
    public Icon func_77617_a(int par1) {
        return this.itemIcons[par1];
    }

    public String func_77628_j(ItemStack par1ItemStack) {
        return Upgrade.values()[par1ItemStack.func_77960_j()].getName();
    }

    @Override
    public boolean canChestTakeUpgrade(ItemStack item) {
        if (item == null) {
            return false;
        }
        return Upgrade.values()[item.func_77960_j()].canChestTakeUpgrade();
    }

    @Override
    public boolean canBagTakeUpgrade(ItemStack item) {
        if (item == null) {
            return false;
        }
        Upgrade upgrade = Upgrade.values()[item.func_77960_j()];
        return upgrade.canBagTakeUpgrade();
    }

    @Override
    public List<ItemStack> getRequiredUpgrade(ItemStack item) {
        if (item == null) {
            return null;
        }
        Upgrade upgrade = Upgrade.values()[item.func_77960_j()];
        if (upgrade.getRequirement() == null) {
            return null;
        }
        ArrayList<ItemStack> list = new ArrayList<ItemStack>();
        list.add(upgrade.getRequirement().getItem());
        return list;
    }

    @Override
    public void update(IBetterChest chest, int tick, World world, ItemStack item) {
        if (!UpgradeHelper.isUpgrade(item)) {
            return;
        }
        Upgrade.values()[item.func_77960_j()].getUpgrade().updateChest(chest, tick, world, item);
    }

    @Override
    public int getMaxUpgrades(ItemStack item) {
        if (item == null) {
            return 0;
        }
        return Upgrade.values()[item.func_77960_j()].getMaxAmount();
    }

    @Override
    public String getName(ItemStack item) {
        if (item == null || !UpgradeHelper.isUpgrade(item)) {
            return "UNKNOWN NAME";
        }
        return Upgrade.values()[item.func_77960_j()].getName();
    }

    @Override
    public void onUpgradeInstalled(ItemStack item, IBetterChest chest) {
        if (ItemUtil.areItemsSame((ItemStack)item, (ItemStack)Upgrade.VOID.getItem())) {
            InvUtil.clearInventory((IInventory)chest);
        }
    }

    @Override
    @SideOnly(value=Side.CLIENT)
    public void drawGuiContainerForegroundLayer(GuiContainer gui, Container container, int par1, int par2, ItemStack item) {
    }
}

