/*
 * Decompiled with CFR 0.152.
 */
package aroma1997.betterchests;

import aroma1997.betterchests.BetterChests;
import aroma1997.betterchests.ContainerUpgrades;
import aroma1997.betterchests.Upgrade;
import aroma1997.betterchests.UpgradeHelper;
import aroma1997.betterchests.api.IBetterChest;
import aroma1997.betterchests.api.IUpgrade;
import aroma1997.core.client.inventories.GUIContainer;
import aroma1997.core.inventories.AromaContainer;
import aroma1997.core.inventories.ContainerBasic;
import aroma1997.core.inventories.ISpecialInventory;
import aroma1997.core.inventories.Inventories;
import aroma1997.core.misc.FakePlayerFactory;
import aroma1997.core.util.FileUtil;
import aroma1997.core.util.ItemUtil;
import cpw.mods.fml.relauncher.Side;
import cpw.mods.fml.relauncher.SideOnly;
import java.util.ArrayList;
import java.util.List;
import java.util.Random;
import net.minecraft.block.Block;
import net.minecraft.client.Minecraft;
import net.minecraft.client.gui.inventory.GuiContainer;
import net.minecraft.entity.Entity;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.inventory.Container;
import net.minecraft.inventory.IInventory;
import net.minecraft.inventory.Slot;
import net.minecraft.item.Item;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.NBTBase;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.nbt.NBTTagList;
import net.minecraft.network.INetworkManager;
import net.minecraft.network.packet.Packet;
import net.minecraft.network.packet.Packet132TileEntityData;
import net.minecraft.server.MinecraftServer;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.util.AxisAlignedBB;
import net.minecraft.util.MathHelper;
import net.minecraft.world.World;

public class TileEntityBChest
extends TileEntity
implements IBetterChest,
ISpecialInventory {
    String player = "";
    private int tick;
    private EntityPlayer fplayer;
    private int ticksSinceSync = -1;
    boolean pickedUp = false;
    private ArrayList<ItemStack> upgrades = new ArrayList();
    private boolean firstInit = false;
    private int numUsingPlayers;
    public float prevLidAngle;
    public float lidAngle;
    private ItemStack[] items;

    public TileEntityBChest() {
        this.tick = new Random().nextInt(64);
        this.items = new ItemStack[9];
    }

    public String func_70303_b() {
        return "inv.betterchests:chest.name";
    }

    public ItemStack func_70301_a(int slot) {
        if (slot < 0 || slot >= this.items.length) {
            return null;
        }
        return this.items[slot];
    }

    public void func_70312_q() {
        super.func_70312_q();
        if (!this.field_70331_k.field_72995_K) {
            this.fplayer = FakePlayerFactory.getFakePlayer((World)this.field_70331_k);
            this.fplayer.field_70165_t = this.field_70329_l;
            this.fplayer.field_70163_u = this.field_70330_m;
            this.fplayer.field_70161_v = this.field_70327_n;
        }
    }

    public void func_70316_g() {
        super.func_70316_g();
        this.doNormalChestUpdate();
        if (this.firstInit) {
            this.field_70331_k.func_72845_h(this.field_70329_l, this.field_70330_m, this.field_70327_n);
        }
        if (this.field_70331_k.field_72995_K) {
            return;
        }
        UpgradeHelper.updateChest(this, this.tick, this.field_70331_k);
        if (this.tick-- <= 0) {
            this.tick = 64;
            this.func_70296_d();
        }
        if (this.isUpgradeInstalled(Upgrade.TICKING.getItem()) && this.tick % 8 == 0) {
            for (int i = 0; i < this.func_70302_i_(); ++i) {
                ItemStack item = this.func_70301_a(i);
                if (item == null || item.func_77973_b() == null) continue;
                this.fplayer.field_71071_by.field_70462_a[0] = this.func_70301_a(i);
                this.fplayer.field_71071_by.func_70296_d();
                item.func_77973_b().func_77663_a(item, this.field_70331_k, (Entity)this.fplayer, 0, false);
                this.func_70296_d();
            }
        }
        if (this.isUpgradeInstalled(Upgrade.RAIN.getItem()) && this.field_70331_k.func_72937_j(this.field_70329_l, this.field_70330_m, this.field_70327_n) && this.field_70331_k.func_72896_J()) {
            Random random = new Random();
            if (random.nextFloat() > 0.8f && this.tick == 20) {
                int bucketEmpty = -1;
                int emptySpace = -1;
                for (int i = 0; i < this.func_70302_i_(); ++i) {
                    if (this.func_70301_a(i) != null && this.func_70301_a((int)i).field_77993_c == Item.field_77788_aw.field_77779_bT && bucketEmpty == -1) {
                        bucketEmpty = i;
                        if (this.func_70301_a((int)i).field_77994_a != 1) continue;
                        emptySpace = i;
                        break;
                    }
                    if (emptySpace != -1 || this.func_70301_a(i) != null) continue;
                    emptySpace = i;
                }
                if (bucketEmpty == -1 || emptySpace == -1) {
                    return;
                }
                this.func_70298_a(bucketEmpty, 1);
                this.func_70299_a(emptySpace, new ItemStack(Item.field_77786_ax));
            }
        }
    }

    public Packet func_70319_e() {
        NBTTagCompound nbt = new NBTTagCompound();
        this.func_70310_b(nbt);
        Packet132TileEntityData packet = new Packet132TileEntityData();
        packet.field_73331_e = nbt;
        packet.field_73334_a = this.field_70329_l;
        packet.field_73332_b = this.field_70330_m;
        packet.field_73333_c = this.field_70327_n;
        packet.field_73330_d = 1;
        return packet;
    }

    public void onDataPacket(INetworkManager net, Packet132TileEntityData packet) {
        this.func_70307_a(packet.field_73331_e);
    }

    public int func_70302_i_() {
        return this.getAmountUpgrade(Upgrade.SLOT.getItem()) * 9 + 9;
    }

    public boolean func_70300_a(EntityPlayer par1EntityPlayer) {
        if (!this.isUpgradeInstalled(Upgrade.PLAYER.getItem()) || par1EntityPlayer == null) {
            return true;
        }
        if (par1EntityPlayer.field_70170_p.field_72995_K) {
            return false;
        }
        if (!MinecraftServer.func_71276_C().func_71262_S() && par1EntityPlayer.field_71092_bJ.equalsIgnoreCase(Minecraft.func_71410_x().field_71439_g.field_71092_bJ)) {
            return true;
        }
        return MinecraftServer.func_71276_C().func_71203_ab().func_72376_i().contains(par1EntityPlayer.field_71092_bJ.toLowerCase()) || this.player.equalsIgnoreCase(par1EntityPlayer.field_71092_bJ);
    }

    public boolean upgrade(EntityPlayer player) {
        if (player == null || !this.func_70300_a(player)) {
            return false;
        }
        ItemStack itemUpgrade = player.func_70694_bm();
        if (itemUpgrade == null || !UpgradeHelper.isUpgrade(itemUpgrade)) {
            return false;
        }
        if (!UpgradeHelper.areRequirementsInstalled(this, itemUpgrade)) {
            return false;
        }
        IUpgrade upgrade = (IUpgrade)itemUpgrade.func_77973_b();
        if (upgrade.canChestTakeUpgrade(itemUpgrade) && UpgradeHelper.areRequirementsInstalled(this, itemUpgrade) && upgrade.getMaxUpgrades(itemUpgrade) > this.getAmountUpgrade(itemUpgrade)) {
            this.setAmountUpgrade(itemUpgrade, this.getAmountUpgrade(itemUpgrade) + 1);
            if (ItemUtil.areItemsSame((ItemStack)itemUpgrade, (ItemStack)Upgrade.PLAYER.getItem())) {
                this.player = player.field_71092_bJ;
            }
            this.onUpgradeInserted(player);
            return true;
        }
        return false;
    }

    public void func_70307_a(NBTTagCompound nbt) {
        this.upgrades.clear();
        for (Upgrade upgrade : Upgrade.values()) {
            int amount = nbt.func_74762_e(upgrade.toString());
            if (amount == 0) continue;
            this.setAmountUpgrade(upgrade.getItem(), amount);
        }
        NBTTagList list = nbt.func_74761_m("upgrades");
        for (int i = 0; i < list.func_74745_c(); ++i) {
            NBTTagCompound upgradenbt = (NBTTagCompound)list.func_74743_b(i);
            ItemStack item = ItemStack.func_77949_a((NBTTagCompound)upgradenbt);
            this.upgrades.add(item);
        }
        this.items = new ItemStack[this.func_70302_i_()];
        FileUtil.readFromNBT((IInventory)this, (NBTTagCompound)nbt);
        this.player = nbt.func_74779_i("player");
        super.func_70307_a(nbt);
        if (this.field_70331_k != null && this.field_70331_k.field_72995_K) {
            this.field_70331_k.func_72902_n(this.field_70329_l, this.field_70330_m, this.field_70327_n);
        }
    }

    public void func_70310_b(NBTTagCompound nbt) {
        super.func_70310_b(nbt);
        nbt.func_74778_a("player", this.player);
        FileUtil.writeToNBT((IInventory)this, (NBTTagCompound)nbt);
        NBTTagList list = new NBTTagList();
        for (ItemStack item : this.upgrades) {
            NBTTagCompound upgradesbt = new NBTTagCompound();
            item.func_77955_b(upgradesbt);
            list.func_74742_a((NBTBase)upgradesbt);
        }
        nbt.func_74782_a("upgrades", (NBTBase)list);
    }

    private void onUpgradeInserted(EntityPlayer player) {
        if (!player.field_71075_bZ.field_75098_d) {
            --player.field_71071_by.field_70462_a[player.field_71071_by.field_70461_c].field_77994_a;
        }
        NBTTagCompound nbttagcompound = new NBTTagCompound();
        this.func_70310_b(nbttagcompound);
        this.func_70307_a(nbttagcompound);
        this.func_70296_d();
    }

    public int getLightValue() {
        return this.isUpgradeInstalled(Upgrade.LIGHT.getItem()) ? 15 : 0;
    }

    public int getComparatorOutput() {
        if (!this.isUpgradeInstalled(Upgrade.COMPARATOR.getItem())) {
            return 0;
        }
        if (this.isUpgradeInstalled(Upgrade.RAIN.getItem())) {
            int w = 0;
            int e = 0;
            for (int i = 0; i < this.func_70302_i_(); ++i) {
                if (this.func_70301_a(i) != null && this.func_70301_a((int)i).field_77993_c == Item.field_77786_ax.field_77779_bT) {
                    ++w;
                }
                if (this.func_70301_a(i) == null || this.func_70301_a((int)i).field_77993_c != Item.field_77788_aw.field_77779_bT) continue;
                e += this.func_70301_a((int)i).field_77994_a;
            }
            if (w == 0) {
                return 0;
            }
            if (e == 0) {
                return 15;
            }
            return (int)((float)w / ((float)e + (float)w) * 15.0f);
        }
        return Container.func_94526_b((IInventory)this);
    }

    public ItemStack[] getItems() {
        ArrayList<ItemStack> list = new ArrayList<ItemStack>();
        for (int i = 0; i < this.func_70302_i_(); ++i) {
            if (this.func_70301_a(i) == null) continue;
            list.add(this.func_70301_a(i));
        }
        return list.toArray(new ItemStack[list.size()]);
    }

    @Override
    public boolean hasEnergy() {
        return this.isUpgradeInstalled(Upgrade.ENERGY.getItem());
    }

    @Override
    public double getXPos() {
        return (float)this.field_70329_l + 0.5f;
    }

    @Override
    public double getYPos() {
        return (float)this.field_70330_m + 0.5f;
    }

    @Override
    public double getZPos() {
        return (float)this.field_70327_n + 0.5f;
    }

    public int getRedstoneOutput() {
        if (!this.isUpgradeInstalled(Upgrade.REDSTONE.getItem())) {
            return 0;
        }
        if (this.isUpgradeInstalled(Upgrade.RAIN.getItem())) {
            if (this.field_70331_k.func_72911_I()) {
                return 2;
            }
            if (this.field_70331_k.func_72896_J()) {
                return 1;
            }
            return 0;
        }
        return MathHelper.func_76125_a((int)this.numUsingPlayers, (int)0, (int)15);
    }

    private void updateNearbyBlocks() {
        this.updateBlock(this.field_70329_l + 1, this.field_70330_m, this.field_70327_n);
        this.updateBlock(this.field_70329_l - 1, this.field_70330_m, this.field_70327_n);
        this.updateBlock(this.field_70329_l, this.field_70330_m, this.field_70327_n + 1);
        this.updateBlock(this.field_70329_l, this.field_70330_m, this.field_70327_n - 1);
        this.updateBlock(this.field_70329_l, this.field_70330_m + 1, this.field_70327_n);
        this.updateBlock(this.field_70329_l, this.field_70330_m - 1, this.field_70327_n);
    }

    private void updateBlock(int x, int y, int z) {
        if (this.field_70331_k.func_72799_c(x, y, z)) {
            return;
        }
        Block.field_71973_m[this.field_70331_k.func_72798_a(x, y, z)].func_71863_a(this.field_70331_k, x, y, z, BetterChests.chest.field_71990_ca);
    }

    private void doNormalChestUpdate() {
        if (this.field_70331_k != null && !this.field_70331_k.field_72995_K && this.numUsingPlayers > 0 && (this.ticksSinceSync + this.field_70329_l + this.field_70330_m + this.field_70327_n) % 200 == 0) {
            this.numUsingPlayers = 0;
            float var1 = 5.0f;
            List var2 = this.field_70331_k.func_72872_a(EntityPlayer.class, AxisAlignedBB.func_72332_a().func_72299_a((double)((float)this.field_70329_l - var1), (double)((float)this.field_70330_m - var1), (double)((float)this.field_70327_n - var1), (double)((float)(this.field_70329_l + 1) + var1), (double)((float)(this.field_70330_m + 1) + var1), (double)((float)(this.field_70327_n + 1) + var1)));
            for (EntityPlayer var4 : var2) {
                if (!(var4.field_71070_bA instanceof ContainerBasic)) continue;
                ++this.numUsingPlayers;
            }
        }
        if (this.field_70331_k != null && !this.field_70331_k.field_72995_K && this.ticksSinceSync < 0) {
            this.field_70331_k.func_72965_b(this.field_70329_l, this.field_70330_m, this.field_70327_n, BetterChests.chest.field_71990_ca, 1, this.numUsingPlayers);
        }
        ++this.ticksSinceSync;
        this.prevLidAngle = this.lidAngle;
        float f = 0.1f;
        if (this.numUsingPlayers > 0 && this.lidAngle == 0.0f) {
            this.field_70331_k.func_72908_a((double)this.field_70329_l + 0.5, (double)this.field_70330_m + 0.5, (double)this.field_70327_n + 0.5, "BetterChests:bchestopen", 0.5f, this.field_70331_k.field_73012_v.nextFloat() * 0.1f + 0.9f);
            this.updateNearbyBlocks();
        }
        if (this.numUsingPlayers <= 0 && this.lidAngle > 0.0f || this.numUsingPlayers > 0 && this.lidAngle < 1.0f) {
            float f2;
            float f1 = this.lidAngle;
            this.lidAngle = this.numUsingPlayers > 0 ? (this.lidAngle += f) : (this.lidAngle -= f);
            if (this.lidAngle > 1.0f) {
                this.lidAngle = 1.0f;
            }
            if (this.lidAngle < (f2 = 0.5f) && f1 >= f2) {
                this.field_70331_k.func_72908_a((double)this.field_70329_l + 0.5, (double)this.field_70330_m + 0.5, (double)this.field_70327_n + 0.5, "BetterChests:bchestclose", 0.5f, this.field_70331_k.field_73012_v.nextFloat() * 0.1f + 0.9f);
                this.updateNearbyBlocks();
            }
            if (this.lidAngle < 0.0f) {
                this.lidAngle = 0.0f;
            }
        }
    }

    public void func_70296_d() {
        super.func_70296_d();
        this.field_70331_k.func_72845_h(this.field_70329_l, this.field_70330_m, this.field_70327_n);
    }

    public ItemStack func_70298_a(int par1, int par2) {
        if (this.items[par1] != null) {
            if (this.items[par1].field_77994_a <= par2) {
                ItemStack itemstack = this.items[par1];
                this.items[par1] = null;
                this.func_70296_d();
                return itemstack;
            }
            ItemStack itemstack = this.items[par1].func_77979_a(par2);
            if (this.items[par1].field_77994_a == 0) {
                this.items[par1] = null;
            }
            this.func_70296_d();
            return itemstack;
        }
        return null;
    }

    public ItemStack func_70304_b(int i) {
        if (i < 0 || i >= this.items.length || this.isUpgradeInstalled(Upgrade.VOID.getItem())) {
            return null;
        }
        return this.items[i];
    }

    public void func_70299_a(int i, ItemStack itemstack) {
        if (i < 0 || i >= this.items.length || this.isUpgradeInstalled(Upgrade.VOID.getItem())) {
            return;
        }
        this.items[i] = itemstack;
    }

    public boolean func_94042_c() {
        return false;
    }

    public int func_70297_j_() {
        return 64;
    }

    public void func_70295_k_() {
        ++this.numUsingPlayers;
        this.updateNearbyBlocks();
    }

    public void func_70305_f() {
        --this.numUsingPlayers;
        this.updateNearbyBlocks();
    }

    public boolean func_94041_b(int i, ItemStack itemstack) {
        return true;
    }

    public boolean func_70315_b(int par1, int par2) {
        if (par1 == 1) {
            this.numUsingPlayers = par2;
            return true;
        }
        return super.func_70315_b(par1, par2);
    }

    @Override
    public int getAmountUpgrade(ItemStack upgrade) {
        if (!UpgradeHelper.isUpgrade(upgrade)) {
            return 0;
        }
        for (ItemStack item : this.upgrades) {
            if (!ItemUtil.areItemsSame((ItemStack)item, (ItemStack)upgrade)) continue;
            return item.field_77994_a;
        }
        return 0;
    }

    @Override
    public boolean isUpgradeInstalled(ItemStack upgrade) {
        return this.getAmountUpgrade(upgrade) > 0;
    }

    @Override
    public void setAmountUpgrade(ItemStack upgrade, int amount) {
        for (ItemStack item : this.upgrades) {
            if (!ItemUtil.areItemsSame((ItemStack)item, (ItemStack)upgrade)) continue;
            if (amount <= 0) {
                this.upgrades.remove(item);
                return;
            }
            item.field_77994_a = amount;
            return;
        }
        upgrade = upgrade.func_77946_l();
        upgrade.field_77994_a = amount;
        this.upgrades.add(upgrade);
    }

    public Slot getSlot(int slot, int index, int x, int y) {
        return new Slot((IInventory)this, index, x, y);
    }

    @SideOnly(value=Side.CLIENT)
    public void drawGuiContainerForegroundLayer(GUIContainer gui, ContainerBasic container, int par1, int par2) {
        for (ItemStack item : this.upgrades) {
            if (!UpgradeHelper.isUpgrade(item)) continue;
            ((IUpgrade)item.func_77973_b()).drawGuiContainerForegroundLayer((GuiContainer)gui, (Container)container, par1, par2, item);
        }
    }

    @SideOnly(value=Side.CLIENT)
    public void drawGuiContainerBackgroundLayer(GUIContainer gui, ContainerBasic container, float f, int i, int j) {
    }

    public ItemStack getDroppedFullItem() {
        ItemStack item = new ItemStack((Block)BetterChests.chest);
        item.func_77982_d(new NBTTagCompound());
        this.func_70310_b(item.field_77990_d);
        return item;
    }

    public static TileEntityBChest loadTEFromNBT(NBTTagCompound nbt) {
        TileEntityBChest te = new TileEntityBChest();
        te.func_70307_a(nbt);
        return te;
    }

    public AromaContainer getContainer(EntityPlayer player, int i) {
        if (i == Inventories.ID_GUI_BLOCK) {
            return new ContainerBasic(player.field_71071_by, (ISpecialInventory)this);
        }
        return new ContainerUpgrades(this, player);
    }

    @Override
    public ArrayList<ItemStack> getUpgrades() {
        return (ArrayList)this.upgrades.clone();
    }
}

