/*
 * Decompiled with CFR 0.152.
 */
package aroma1997.betterchests;

import aroma1997.betterchests.BetterChests;
import aroma1997.betterchests.upgrades.BasicUpgrade;
import aroma1997.betterchests.upgrades.CobbleGen;
import aroma1997.betterchests.upgrades.Collector;
import aroma1997.betterchests.upgrades.Feeding;
import aroma1997.betterchests.upgrades.Furnace;
import aroma1997.betterchests.upgrades.Null;
import aroma1997.betterchests.upgrades.PlayerFeeding;
import aroma1997.betterchests.upgrades.Rain;
import aroma1997.betterchests.upgrades.Resupply;
import aroma1997.betterchests.upgrades.Ticking;
import aroma1997.core.util.AromaRegistry;
import java.util.ArrayList;
import net.minecraft.block.Block;
import net.minecraft.item.Item;
import net.minecraft.item.ItemFood;
import net.minecraft.item.ItemStack;
import net.minecraft.util.StatCollector;

public enum Upgrade {
    SLOT(null, 9, true, true, Null.class),
    COBBLEGEN(null, 1, true, true, CobbleGen.class),
    REDSTONE(null, 1, true, false, Null.class),
    LIGHT(null, 1, true, false, Null.class),
    BASIC(null, 0, false, false, Null.class),
    COMPARATOR(null, 1, true, false, Null.class),
    VOID(null, 1, true, true, Null.class),
    UNBREAKABLE(null, 1, true, false, Null.class),
    PLAYER(UNBREAKABLE, 1, true, false, Null.class),
    RAIN(null, 1, true, false, Rain.class),
    ENERGY(null, 1, true, true, Null.class),
    FURNACE(ENERGY, 1, true, true, Furnace.class),
    COLLECTOR(ENERGY, 8, true, true, Collector.class),
    TICKING(ENERGY, 1, true, false, Ticking.class),
    FEEDING(null, 1, true, false, Feeding.class),
    PLAYERFOOD(null, 1, false, true, PlayerFeeding.class),
    RESUPPLY(null, 1, false, true, Resupply.class);

    private final Upgrade requirement;
    private final int max;
    private final boolean canChest;
    private final boolean canBag;
    private BasicUpgrade upgrade;

    private Upgrade(Upgrade requirement, int max, boolean canChest, boolean canBag, Class<? extends BasicUpgrade> claSS) {
        this.requirement = requirement;
        this.max = max;
        this.canChest = canChest;
        this.canBag = canBag;
        try {
            this.upgrade = claSS.newInstance();
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }

    public String getName() {
        return StatCollector.func_74838_a((String)("item.betterchests:upgrade." + this.toString() + ".name"));
    }

    public String getTexture() {
        return "BetterChests:" + this.toString().toLowerCase();
    }

    public Upgrade getRequirement() {
        return this.requirement;
    }

    public static void generateRecipes() {
        int itemID = BetterChests.upgrade.field_77779_bT;
        ItemStack itemUpgrade = new ItemStack(itemID, 1, BASIC.ordinal());
        AromaRegistry.registerShapedAromicRecipe((ItemStack)new ItemStack(itemID, 8, BASIC.ordinal()), (boolean)false, (Object[])new Object[]{"WIW", "ISI", "WIW", Character.valueOf('W'), "plankWood", Character.valueOf('I'), new ItemStack(Block.field_72002_bp), Character.valueOf('S'), "stickWood"});
        AromaRegistry.registerShapedAromicRecipe((ItemStack)new ItemStack(itemID, 1, SLOT.ordinal()), (boolean)false, (Object[])new Object[]{" W ", "WUW", " W ", Character.valueOf('W'), "plankWood", Character.valueOf('U'), itemUpgrade});
        AromaRegistry.registerShapedAromicRecipe((ItemStack)new ItemStack(itemID, 1, REDSTONE.ordinal()), (boolean)false, (Object[])new Object[]{"RRR", "RUR", "RRR", Character.valueOf('R'), new ItemStack(Item.field_77767_aC), Character.valueOf('U'), itemUpgrade});
        AromaRegistry.registerShapedAromicRecipe((ItemStack)new ItemStack(itemID, 1, LIGHT.ordinal()), (boolean)false, (Object[])new Object[]{" G ", "GUG", " G ", Character.valueOf('G'), new ItemStack(Item.field_77751_aT), Character.valueOf('U'), itemUpgrade});
        AromaRegistry.registerShapedAromicRecipe((ItemStack)new ItemStack(itemID, 1, COMPARATOR.ordinal()), (boolean)false, (Object[])new Object[]{" Q ", "RUR", " Q ", Character.valueOf('Q'), new ItemStack(Item.field_94583_ca), Character.valueOf('R'), new ItemStack(Item.field_77767_aC), Character.valueOf('U'), itemUpgrade});
        AromaRegistry.registerShapedAromicRecipe((ItemStack)new ItemStack(itemID, 1, COMPARATOR.ordinal()), (boolean)false, (Object[])new Object[]{" R ", "QUQ", " R ", Character.valueOf('Q'), new ItemStack(Item.field_94583_ca), Character.valueOf('R'), new ItemStack(Item.field_77767_aC), Character.valueOf('U'), itemUpgrade});
        AromaRegistry.registerShapedAromicRecipe((ItemStack)new ItemStack(itemID, 1, PLAYER.ordinal()), (boolean)false, (Object[])new Object[]{"OQO", "QUQ", "OQO", Character.valueOf('Q'), new ItemStack(Item.field_94583_ca), Character.valueOf('O'), new ItemStack(Block.field_72089_ap), Character.valueOf('U'), itemUpgrade});
        AromaRegistry.registerShapedAromicRecipe((ItemStack)new ItemStack(itemID, 1, COBBLEGEN.ordinal()), (boolean)false, (Object[])new Object[]{"CCC", "BUB", "CCC", Character.valueOf('C'), "cobblestone", Character.valueOf('U'), itemUpgrade, Character.valueOf('B'), new ItemStack(Item.field_77788_aw)});
        AromaRegistry.registerShapedAromicRecipe((ItemStack)new ItemStack(itemID, 1, VOID.ordinal()), (boolean)false, (Object[])new Object[]{" E ", "RUR", " E ", Character.valueOf('E'), new ItemStack(Item.field_77730_bn), Character.valueOf('R'), new ItemStack(Item.field_77767_aC), Character.valueOf('U'), itemUpgrade});
        AromaRegistry.registerShapedAromicRecipe((ItemStack)new ItemStack(itemID, 1, UNBREAKABLE.ordinal()), (boolean)false, (Object[])new Object[]{"OOO", "OUO", "OOO", Character.valueOf('O'), new ItemStack(Block.field_72089_ap), Character.valueOf('U'), itemUpgrade});
        AromaRegistry.registerShapedAromicRecipe((ItemStack)new ItemStack(itemID, 1, RAIN.ordinal()), (boolean)false, (Object[])new Object[]{" B ", "BUB", " B ", Character.valueOf('B'), new ItemStack(Item.field_77788_aw), Character.valueOf('U'), itemUpgrade});
        AromaRegistry.registerShapedAromicRecipe((ItemStack)new ItemStack(itemID, 1, ENERGY.ordinal()), (boolean)false, (Object[])new Object[]{"BRB", "CUC", "BRB", Character.valueOf('B'), new ItemStack(Block.field_111034_cE), Character.valueOf('R'), new ItemStack(Item.field_77767_aC), Character.valueOf('C'), new ItemStack(Item.field_77742_bb), Character.valueOf('U'), itemUpgrade});
        AromaRegistry.registerShapedAromicRecipe((ItemStack)new ItemStack(itemID, 1, ENERGY.ordinal()), (boolean)false, (Object[])new Object[]{"BCB", "RUR", "BCB", Character.valueOf('B'), new ItemStack(Block.field_111034_cE), Character.valueOf('R'), new ItemStack(Item.field_77767_aC), Character.valueOf('C'), new ItemStack(Item.field_77742_bb), Character.valueOf('U'), itemUpgrade});
        AromaRegistry.registerShapedAromicRecipe((ItemStack)new ItemStack(itemID, 1, FURNACE.ordinal()), (boolean)false, (Object[])new Object[]{"RFR", "FUF", "RFR", Character.valueOf('R'), new ItemStack(Item.field_77767_aC), Character.valueOf('F'), new ItemStack(Block.field_72051_aB), Character.valueOf('U'), itemUpgrade});
        AromaRegistry.registerShapedAromicRecipe((ItemStack)new ItemStack(itemID, 1, COLLECTOR.ordinal()), (boolean)false, (Object[])new Object[]{" H ", "HUH", "RER", Character.valueOf('H'), new ItemStack((Block)Block.field_94340_cs), Character.valueOf('R'), new ItemStack(Item.field_77767_aC), Character.valueOf('E'), new ItemStack(Item.field_77730_bn), Character.valueOf('U'), itemUpgrade});
        AromaRegistry.registerShapedAromicRecipe((ItemStack)new ItemStack(itemID, 1, TICKING.ordinal()), (boolean)false, (Object[])new Object[]{"QCQ", "RUR", "QCQ", Character.valueOf('Q'), new ItemStack(Item.field_94583_ca), Character.valueOf('C'), new ItemStack(Item.field_77752_aS), Character.valueOf('R'), new ItemStack(Item.field_94585_bY), Character.valueOf('U'), itemUpgrade});
        AromaRegistry.registerShapedAromicRecipe((ItemStack)new ItemStack(itemID, 1, FEEDING.ordinal()), (boolean)false, (Object[])new Object[]{" W ", "WUW", " W ", Character.valueOf('W'), new ItemStack(Item.field_77685_T), Character.valueOf('U'), itemUpgrade});
        AromaRegistry.registerShapedAromicRecipe((ItemStack)new ItemStack(itemID, 1, PLAYERFOOD.ordinal()), (boolean)false, (Object[])new Object[]{"FFF", "FUF", "FFF", Character.valueOf('F'), ItemFood.class, Character.valueOf('U'), itemUpgrade});
        AromaRegistry.registerShapedAromicRecipe((ItemStack)new ItemStack(itemID, 1, RESUPPLY.ordinal()), (boolean)false, (Object[])new Object[]{"CUC", " H ", Character.valueOf('C'), new ItemStack((Block)Block.field_72077_au), Character.valueOf('H'), new ItemStack((Block)Block.field_94340_cs), Character.valueOf('U'), itemUpgrade});
        AromaRegistry.registerShapelessAromicRecipe((ItemStack)BASIC.getItem(), (boolean)true, (Object[])new Object[]{new ItemStack(itemID, 1, Short.MAX_VALUE)});
    }

    public int getMaxAmount() {
        return this.max;
    }

    public boolean canChestTakeUpgrade() {
        return this.canChest;
    }

    public boolean canBagTakeUpgrade() {
        return this.canBag;
    }

    public static void addBagBookDescription(ArrayList<String> list) {
        for (Upgrade upgrade : Upgrade.values()) {
            list.add("book.betterchests:upgrade." + (Object)((Object)upgrade));
        }
    }

    public ItemStack getItem() {
        return new ItemStack((Item)BetterChests.upgrade, 1, this.ordinal());
    }

    public BasicUpgrade getUpgrade() {
        return this.upgrade;
    }
}

