/*
 * Decompiled with CFR 0.152.
 */
package aroma1997.betterchests;

import aroma1997.betterchests.api.IBetterChest;
import aroma1997.betterchests.api.IUpgrade;
import aroma1997.core.util.ItemUtil;
import java.util.ArrayList;
import java.util.List;
import net.minecraft.item.ItemStack;
import net.minecraft.world.World;

public class UpgradeHelper {
    static void updateChest(IBetterChest inv, int tick, World world) {
        if (world.field_72995_K) {
            return;
        }
        ArrayList<ItemStack> upgrades = inv.getUpgrades();
        if (upgrades == null) {
            return;
        }
        for (ItemStack item : upgrades) {
            if (!UpgradeHelper.isUpgrade(item) || inv.isUpgradeDisabled(item)) continue;
            ((IUpgrade)item.func_77973_b()).update(inv, tick, world, item);
        }
    }

    public static boolean isRequirement(ItemStack req, ItemStack up) {
        if (!UpgradeHelper.isUpgrade(req) || !UpgradeHelper.isUpgrade(up)) {
            return false;
        }
        IUpgrade iup = (IUpgrade)up.func_77973_b();
        List<ItemStack> reqlist = iup.getRequiredUpgrade(up);
        if (reqlist == null) {
            return false;
        }
        for (ItemStack item : reqlist) {
            if (!UpgradeHelper.isUpgrade(item) || !ItemUtil.areItemsSameMatching((ItemStack)item, (ItemStack)req, (ItemUtil.ItemMatchCriteria[])new ItemUtil.ItemMatchCriteria[]{ItemUtil.ItemMatchCriteria.ID, ItemUtil.ItemMatchCriteria.DAMAGE})) continue;
            return true;
        }
        return false;
    }

    public static boolean isUpgrade(ItemStack item) {
        return item != null && item.func_77973_b() instanceof IUpgrade;
    }

    public static ItemStack getDefaultItem(ItemStack item) {
        if (!UpgradeHelper.isUpgrade(item)) {
            return null;
        }
        item = item.func_77946_l();
        item.field_77994_a = 1;
        return item;
    }

    public static boolean areRequirementsInstalled(IBetterChest chest, ItemStack item) {
        if (chest == null || item == null || !UpgradeHelper.isUpgrade(item)) {
            return false;
        }
        IUpgrade upgrade = (IUpgrade)item.func_77973_b();
        if (upgrade == null) {
            return false;
        }
        if (upgrade.getRequiredUpgrade(item) == null) {
            return true;
        }
        for (ItemStack req : upgrade.getRequiredUpgrade(item)) {
            if (chest.isUpgradeInstalled(req)) continue;
            return false;
        }
        return true;
    }

    public static boolean isRequirement(ItemStack item, IBetterChest inv) {
        if (item == null || !UpgradeHelper.isUpgrade(item)) {
            return false;
        }
        for (int i = 0; i < inv.getUpgrades().size(); ++i) {
            ItemStack itemtmp = inv.getUpgrades().get(i);
            if (itemtmp == null || !UpgradeHelper.isUpgrade(itemtmp) || !UpgradeHelper.isRequirement(item, itemtmp)) continue;
            return true;
        }
        return false;
    }

    public static void enableUpgrade(ItemStack upgrade) {
        if (UpgradeHelper.isUpgrade(upgrade) && upgrade.func_77942_o() && upgrade.field_77990_d.func_74767_n("disabled")) {
            upgrade.field_77990_d.func_82580_o("disabled");
            if (upgrade.field_77990_d.func_82582_d()) {
                upgrade.field_77990_d = null;
            }
        }
    }
}

