/*
 * Decompiled with CFR 0.152.
 */
package aroma1997.betterchests;

import aroma1997.betterchests.BetterChestsItems;
import aroma1997.betterchests.ItemUpgrade;
import aroma1997.betterchests.upgrades.Animal;
import aroma1997.betterchests.upgrades.BasicUpgrade;
import aroma1997.betterchests.upgrades.Blocking;
import aroma1997.betterchests.upgrades.CobbleGen;
import aroma1997.betterchests.upgrades.Collector;
import aroma1997.betterchests.upgrades.Feeding;
import aroma1997.betterchests.upgrades.Furnace;
import aroma1997.betterchests.upgrades.Harvesting;
import aroma1997.betterchests.upgrades.Killing;
import aroma1997.betterchests.upgrades.LightWeight;
import aroma1997.betterchests.upgrades.Mining;
import aroma1997.betterchests.upgrades.Null;
import aroma1997.betterchests.upgrades.Planting;
import aroma1997.betterchests.upgrades.PlayerFeeding;
import aroma1997.betterchests.upgrades.Rain;
import aroma1997.betterchests.upgrades.Resupply;
import aroma1997.betterchests.upgrades.Ticking;
import aroma1997.betterchests.upgrades.VoidUpgrade;
import aroma1997.core.util.AromaRegistry;
import java.util.ArrayList;
import net.minecraft.block.Block;
import net.minecraft.block.BlockOre;
import net.minecraft.block.BlockWall;
import net.minecraft.init.Blocks;
import net.minecraft.init.Items;
import net.minecraft.item.Item;
import net.minecraft.item.ItemFood;
import net.minecraft.item.ItemStack;
import net.minecraft.item.ItemSword;
import net.minecraft.item.ItemTool;
import net.minecraft.util.StatCollector;
import net.minecraftforge.common.IPlantable;

public enum Upgrade {
    SLOT(null, 7, true, true, Null.class, false, false),
    COBBLEGEN(null, 1, true, true, CobbleGen.class, true, true),
    REDSTONE(null, 1, true, false, Null.class, false, false),
    LIGHT(null, 1, true, false, Null.class, false, false),
    BASIC(null, 0, false, false, Null.class, false, false),
    COMPARATOR(null, 1, true, false, Null.class, false, false),
    VOID(null, 1, true, true, VoidUpgrade.class, false, true),
    UNBREAKABLE(null, 1, true, true, Null.class, false, false),
    PLAYER(UNBREAKABLE, 1, true, false, Null.class, false, false),
    RAIN(null, 1, true, false, Rain.class, true, false),
    ENERGY(null, 1, true, true, Null.class, false, false),
    FURNACE(ENERGY, 1, true, true, Furnace.class, true, true),
    COLLECTOR(ENERGY, 8, true, true, Collector.class, true, true),
    TICKING(ENERGY, 1, true, false, Ticking.class, true, true),
    FEEDING(null, 1, true, false, Feeding.class, true, true),
    PLAYERFOOD(null, 1, false, true, PlayerFeeding.class, true, true),
    RESUPPLY(null, 1, false, true, Resupply.class, true, true),
    PLANTING(ENERGY, 5, true, false, Planting.class, true, true),
    HARVESTING(ENERGY, 5, true, false, Harvesting.class, true, true),
    ANIMAL(ENERGY, 1, true, false, Animal.class, true, false),
    AI(null, 1, true, true, Null.class, false, false),
    MINING(AI, 1, true, false, Mining.class, true, true),
    KILLING(ENERGY, 1, true, false, Killing.class, true, false),
    BLOCKER(SLOT, 4, true, false, Blocking.class, false, false),
    LIGHTWEIGHT(null, 1, false, true, LightWeight.class, true, false);

    private final Upgrade requirement;
    private final int max;
    private final boolean canChest;
    private final boolean canBag;
    private BasicUpgrade upgrade;
    private final boolean disableable;
    private final boolean filter;

    private Upgrade(Upgrade requirement, int max, boolean canChest, boolean canBag, Class<? extends BasicUpgrade> claSS, boolean disablable, boolean filter) {
        this.requirement = requirement;
        this.max = max;
        this.canChest = canChest;
        this.canBag = canBag;
        this.disableable = disablable;
        this.filter = filter;
        try {
            this.upgrade = claSS.newInstance();
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }

    public String getName() {
        return StatCollector.func_74838_a((String)("item.betterchests:upgrade." + this.toString() + ".name"));
    }

    public String getTexture() {
        return "BetterChests:" + this.toString().toLowerCase();
    }

    public Upgrade getRequirement() {
        return this.requirement;
    }

    public static void generateRecipes() {
        ItemUpgrade item = BetterChestsItems.upgrade;
        ItemStack itemUpgrade = new ItemStack((Item)item, 1, BASIC.ordinal());
        AromaRegistry.registerShapedAromicRecipe((ItemStack)new ItemStack((Item)item, 8, BASIC.ordinal()), (boolean)false, (Object[])new Object[]{"WIW", "ISI", "WIW", Character.valueOf('W'), "plankWood", Character.valueOf('I'), new ItemStack(Blocks.field_150411_aY), Character.valueOf('S'), "stickWood"});
        AromaRegistry.registerShapedAromicRecipe((ItemStack)new ItemStack((Item)item, 1, SLOT.ordinal()), (boolean)false, (Object[])new Object[]{" W ", "WUW", " W ", Character.valueOf('W'), "plankWood", Character.valueOf('U'), itemUpgrade});
        AromaRegistry.registerShapedAromicRecipe((ItemStack)new ItemStack((Item)item, 1, REDSTONE.ordinal()), (boolean)false, (Object[])new Object[]{"RRR", "RUR", "RRR", Character.valueOf('R'), new ItemStack(Items.field_151137_ax), Character.valueOf('U'), itemUpgrade});
        AromaRegistry.registerShapedAromicRecipe((ItemStack)new ItemStack((Item)item, 1, LIGHT.ordinal()), (boolean)false, (Object[])new Object[]{" G ", "GUG", " G ", Character.valueOf('G'), new ItemStack(Items.field_151114_aO), Character.valueOf('U'), itemUpgrade});
        AromaRegistry.registerShapedAromicRecipe((ItemStack)new ItemStack((Item)item, 1, COMPARATOR.ordinal()), (boolean)false, (Object[])new Object[]{" Q ", "RUR", " Q ", Character.valueOf('Q'), new ItemStack(Items.field_151128_bU), Character.valueOf('R'), new ItemStack(Items.field_151137_ax), Character.valueOf('U'), itemUpgrade});
        AromaRegistry.registerShapedAromicRecipe((ItemStack)new ItemStack((Item)item, 1, COMPARATOR.ordinal()), (boolean)false, (Object[])new Object[]{" R ", "QUQ", " R ", Character.valueOf('Q'), new ItemStack(Items.field_151128_bU), Character.valueOf('R'), new ItemStack(Items.field_151137_ax), Character.valueOf('U'), itemUpgrade});
        AromaRegistry.registerShapedAromicRecipe((ItemStack)new ItemStack((Item)item, 1, PLAYER.ordinal()), (boolean)false, (Object[])new Object[]{"OQO", "QUQ", "OQO", Character.valueOf('Q'), new ItemStack(Items.field_151128_bU), Character.valueOf('O'), new ItemStack(Blocks.field_150343_Z), Character.valueOf('U'), itemUpgrade});
        AromaRegistry.registerShapedAromicRecipe((ItemStack)new ItemStack((Item)item, 1, COBBLEGEN.ordinal()), (boolean)false, (Object[])new Object[]{"CCC", "BUB", "CCC", Character.valueOf('C'), "cobblestone", Character.valueOf('U'), itemUpgrade, Character.valueOf('B'), new ItemStack(Items.field_151133_ar)});
        AromaRegistry.registerShapedAromicRecipe((ItemStack)new ItemStack((Item)item, 1, VOID.ordinal()), (boolean)false, (Object[])new Object[]{" E ", "RUR", " E ", Character.valueOf('E'), new ItemStack(Items.field_151079_bi), Character.valueOf('R'), new ItemStack(Items.field_151137_ax), Character.valueOf('U'), itemUpgrade});
        AromaRegistry.registerShapedAromicRecipe((ItemStack)new ItemStack((Item)item, 1, UNBREAKABLE.ordinal()), (boolean)false, (Object[])new Object[]{"OOO", "OUO", "OOO", Character.valueOf('O'), new ItemStack(Blocks.field_150343_Z), Character.valueOf('U'), itemUpgrade});
        AromaRegistry.registerShapedAromicRecipe((ItemStack)new ItemStack((Item)item, 1, RAIN.ordinal()), (boolean)false, (Object[])new Object[]{" B ", "BUB", " B ", Character.valueOf('B'), new ItemStack(Items.field_151133_ar), Character.valueOf('U'), itemUpgrade});
        AromaRegistry.registerShapedAromicRecipe((ItemStack)new ItemStack((Item)item, 1, ENERGY.ordinal()), (boolean)false, (Object[])new Object[]{"BRB", "CUC", "BRB", Character.valueOf('B'), new ItemStack(Blocks.field_150402_ci), Character.valueOf('R'), new ItemStack(Items.field_151137_ax), Character.valueOf('C'), new ItemStack(Items.field_151107_aW), Character.valueOf('U'), itemUpgrade});
        AromaRegistry.registerShapedAromicRecipe((ItemStack)new ItemStack((Item)item, 1, ENERGY.ordinal()), (boolean)false, (Object[])new Object[]{"BCB", "RUR", "BCB", Character.valueOf('B'), new ItemStack(Blocks.field_150402_ci), Character.valueOf('R'), new ItemStack(Items.field_151137_ax), Character.valueOf('C'), new ItemStack(Items.field_151107_aW), Character.valueOf('U'), itemUpgrade});
        AromaRegistry.registerShapedAromicRecipe((ItemStack)new ItemStack((Item)item, 1, FURNACE.ordinal()), (boolean)false, (Object[])new Object[]{"RFR", "FUF", "RFR", Character.valueOf('R'), new ItemStack(Items.field_151137_ax), Character.valueOf('F'), new ItemStack(Blocks.field_150460_al), Character.valueOf('U'), itemUpgrade});
        AromaRegistry.registerShapedAromicRecipe((ItemStack)new ItemStack((Item)item, 1, COLLECTOR.ordinal()), (boolean)false, (Object[])new Object[]{" H ", "HUH", "RER", Character.valueOf('H'), new ItemStack((Block)Blocks.field_150438_bZ), Character.valueOf('R'), new ItemStack(Items.field_151137_ax), Character.valueOf('E'), new ItemStack(Items.field_151079_bi), Character.valueOf('U'), itemUpgrade});
        AromaRegistry.registerShapedAromicRecipe((ItemStack)new ItemStack((Item)item, 1, TICKING.ordinal()), (boolean)false, (Object[])new Object[]{"QCQ", "RUR", "QCQ", Character.valueOf('Q'), new ItemStack(Items.field_151128_bU), Character.valueOf('C'), new ItemStack(Items.field_151113_aN), Character.valueOf('R'), new ItemStack(Items.field_151132_bS), Character.valueOf('U'), itemUpgrade});
        AromaRegistry.registerShapedAromicRecipe((ItemStack)new ItemStack((Item)item, 1, FEEDING.ordinal()), (boolean)false, (Object[])new Object[]{" W ", "WUW", " W ", Character.valueOf('W'), new ItemStack(Items.field_151015_O), Character.valueOf('U'), itemUpgrade});
        AromaRegistry.registerShapedAromicRecipe((ItemStack)new ItemStack((Item)item, 1, PLAYERFOOD.ordinal()), (boolean)false, (Object[])new Object[]{"FFF", "FUF", "FFF", Character.valueOf('F'), ItemFood.class, Character.valueOf('U'), itemUpgrade});
        AromaRegistry.registerShapedAromicRecipe((ItemStack)new ItemStack((Item)item, 1, RESUPPLY.ordinal()), (boolean)false, (Object[])new Object[]{"CUC", " H ", Character.valueOf('C'), new ItemStack((Block)Blocks.field_150486_ae), Character.valueOf('H'), new ItemStack((Block)Blocks.field_150438_bZ), Character.valueOf('U'), itemUpgrade});
        AromaRegistry.registerShapedAromicRecipe((ItemStack)new ItemStack((Item)item, 1, PLANTING.ordinal()), (boolean)false, (Object[])new Object[]{"SHS", "HUH", "SHS", Character.valueOf('S'), IPlantable.class, Character.valueOf('H'), new ItemStack(Items.field_151019_K), Character.valueOf('U'), itemUpgrade});
        AromaRegistry.registerShapedAromicRecipe((ItemStack)new ItemStack((Item)item, 1, HARVESTING.ordinal()), (boolean)false, (Object[])new Object[]{"WWW", "WUW", "WWW", Character.valueOf('W'), new ItemStack(Items.field_151015_O), Character.valueOf('U'), itemUpgrade});
        AromaRegistry.registerShapedAromicRecipe((ItemStack)new ItemStack((Item)item, 1, ANIMAL.ordinal()), (boolean)false, (Object[])new Object[]{" S ", "BUB", " S ", Character.valueOf('S'), new ItemStack((Item)Items.field_151097_aZ), Character.valueOf('B'), new ItemStack(Items.field_151133_ar), Character.valueOf('U'), itemUpgrade});
        AromaRegistry.registerShapedAromicRecipe((ItemStack)new ItemStack((Item)item, 1, AI.ordinal()), (boolean)false, (Object[])new Object[]{"QDQ", "GUG", "QDQ", Character.valueOf('Q'), new ItemStack(Items.field_151128_bU), Character.valueOf('D'), new ItemStack(Items.field_151045_i), Character.valueOf('G'), new ItemStack(Items.field_151043_k), Character.valueOf('U'), itemUpgrade});
        AromaRegistry.registerShapedAromicRecipe((ItemStack)new ItemStack((Item)item, 1, AI.ordinal()), (boolean)false, (Object[])new Object[]{"QGQ", "DUD", "QGQ", Character.valueOf('Q'), new ItemStack(Items.field_151128_bU), Character.valueOf('D'), new ItemStack(Items.field_151045_i), Character.valueOf('G'), new ItemStack(Items.field_151043_k), Character.valueOf('U'), itemUpgrade});
        AromaRegistry.registerShapedAromicRecipe((ItemStack)new ItemStack((Item)item, 1, MINING.ordinal()), (boolean)false, (Object[])new Object[]{"OTO", "TUT", "OTO", Character.valueOf('O'), BlockOre.class, Character.valueOf('T'), ItemTool.class, Character.valueOf('U'), itemUpgrade});
        AromaRegistry.registerShapedAromicRecipe((ItemStack)new ItemStack((Item)item, 1, KILLING.ordinal()), (boolean)false, (Object[])new Object[]{" S ", "SUS", " S ", Character.valueOf('S'), ItemSword.class, Character.valueOf('U'), itemUpgrade});
        AromaRegistry.registerShapedAromicRecipe((ItemStack)new ItemStack((Item)item, 1, BLOCKER.ordinal()), (boolean)false, (Object[])new Object[]{"WWW", "WUW", "WWW", Character.valueOf('W'), BlockWall.class, Character.valueOf('U'), itemUpgrade});
        AromaRegistry.registerShapedAromicRecipe((ItemStack)new ItemStack((Item)item, 1, LIGHTWEIGHT.ordinal()), (boolean)false, (Object[])new Object[]{"GFG", "FUF", "GFG", Character.valueOf('G'), new ItemStack(Items.field_151074_bl), Character.valueOf('F'), new ItemStack(Items.field_151008_G), Character.valueOf('U'), itemUpgrade});
        AromaRegistry.registerShapedAromicRecipe((ItemStack)new ItemStack((Item)item, 1, LIGHTWEIGHT.ordinal()), (boolean)false, (Object[])new Object[]{"FGF", "GUG", "FGF", Character.valueOf('G'), new ItemStack(Items.field_151074_bl), Character.valueOf('F'), new ItemStack(Items.field_151008_G), Character.valueOf('U'), itemUpgrade});
        AromaRegistry.registerShapelessAromicRecipe((ItemStack)BASIC.getItem(), (boolean)true, (Object[])new Object[]{new ItemStack((Item)item, 1, Short.MAX_VALUE)});
    }

    public int getMaxAmount() {
        return this.max;
    }

    public boolean canChestTakeUpgrade() {
        return this.canChest;
    }

    public boolean canBagTakeUpgrade() {
        return this.canBag;
    }

    public static void addBagBookDescription(ArrayList<String> list) {
        for (Upgrade upgrade : Upgrade.values()) {
            list.add("book.betterchests:upgrade." + (Object)((Object)upgrade));
        }
    }

    public ItemStack getItem() {
        return new ItemStack((Item)BetterChestsItems.upgrade, 1, this.ordinal());
    }

    public BasicUpgrade getUpgrade() {
        return this.upgrade;
    }

    public boolean canBeDisabled() {
        return this.disableable;
    }

    public boolean canUseFilter() {
        return this.filter;
    }
}

