/*
 * Decompiled with CFR 0.152.
 */
package bspkrs.floatingruins;

import bspkrs.util.config.Property;

public enum ConfigElement {
    ENABLED("enabled", "general", "bspkrs.fr.configgui.enabled", "Enables or disables Floating Ruins generation.", Property.Type.BOOLEAN),
    ALLOW_DEBUG_LOGGING("allowDebugLogging", "general", "bspkrs.fr.configgui.allowDebugLogging", "Set to true if you want FloatingRuins to log info about what it's doing, false to disable", Property.Type.BOOLEAN),
    ALLOW_IN_SUPERFLAT("allowInSuperFlat", "general", "bspkrs.fr.configgui.allowInSuperFlat", "Set to true to allow generation of floating ruins on superflat maps, false to disable.", Property.Type.BOOLEAN),
    ALLOW_MULTI_MOB_SPAWNERS("allowMultiMobSpawners", "general.dungeon_settings", "bspkrs.fr.configgui.allowMultiMobSpawners", "When set to true spawners will be able to spawn any of the mobs for the biome the floating island generated in, set to false to use the old logic of randomly picking just one mob.", Property.Type.BOOLEAN),
    HARDER_DUNGEONS("harderDungeons", "general.dungeon_settings", "bspkrs.fr.configgui.harderDungeons", "Set to true to generate harder dungeons (roof is bedrock, chest is harder to get to, mobs spawn more aggressively), set to false to generate normal dungeons.", Property.Type.BOOLEAN),
    RARITY("rarity", "general.island_settings", "bspkrs.fr.configgui.rarity", "The probability of a floating island generating is 1 in each 'rarity' number of chunks.", Property.Type.INTEGER),
    RARITY_DUNGEON("rarityDungeon", "general.dungeon_settings", "bspkrs.fr.configgui.rarityDungeon", "The probability of a floating island having a dungeon on it is 1 in each 'rarityDungeon' number of islands.", Property.Type.INTEGER),
    HEIGHT_MAX("heightMax", "general.island_settings.island_size", "bspkrs.fr.configgui.heightMax", "The maximum world height for floating ruins (Min=heightMean, Max=225).", Property.Type.INTEGER),
    HEIGHT_MEAN("heightMean", "general.island_settings.island_size", "bspkrs.fr.configgui.heightMean", "The average island height. Half of the islands will be below heightMean, half of the islands will be above heightMean. (Min=heightMin, Max=heightMax).", Property.Type.INTEGER),
    HEIGHT_MIN("heightMin", "general.island_settings.island_size", "bspkrs.fr.configgui.heightMin", "The minimum world height for floating ruins (Min=80, Max=heightMax).", Property.Type.INTEGER),
    HEIGHT_NORM("heightNorm", "general.island_settings.island_size", "bspkrs.fr.configgui.heightNorm", "How strongly island height should tend to lie around heightMean. (Min=1, Max=10).", Property.Type.INTEGER),
    RADIUS_MAX("radiusMax", "general.island_settings.island_size", "bspkrs.fr.configgui.radiusMax", "The maximum radius of each island.  Making this value too large will result in very large chunks of your world turning into floating islands (Min=radiusMean, Max=50).", Property.Type.INTEGER),
    RADIUS_MEAN("radiusMean", "general.island_settings.island_size", "bspkrs.fr.configgui.radiusMean", "The average island radius. Half of the islands will be smaller than radiusMean, half of the islands will be larger than radiusMean. (Min=radiusMin, Max=radiusMax).", Property.Type.INTEGER),
    RADIUS_MIN("radiusMin", "general.island_settings.island_size", "bspkrs.fr.configgui.radiusMin", "The minimum radius of each island.  I recommend keeping this at 7 or more (Min=5, Max=radiusMean).", Property.Type.INTEGER),
    RADIUS_NORM("radiusNorm", "general.island_settings.island_size", "bspkrs.fr.configgui.radiusNorm", "How strongly island radius should tend to lie around radiusMean. (Min=1, Max=10).", Property.Type.INTEGER),
    DEPTH_MAX("depthMax", "general.island_settings.island_size", "bspkrs.fr.configgui.depthMax", "The maximum depth/thickness of islands (Min=depthMean, Max=50).", Property.Type.INTEGER),
    DEPTH_MEAN("depthMean", "general.island_settings.island_size", "bspkrs.fr.configgui.depthMean", "The average island depth. Half of the islands will be shallower than depthMean, half of the islands will be deeper than depthMean. (Min=depthMin, Max=depthMax).", Property.Type.INTEGER),
    DEPTH_MIN("depthMin", "general.island_settings.island_size", "bspkrs.fr.configgui.depthMin", "The minimum depth/thickness of islands (Min=2, Max=depthMean).", Property.Type.INTEGER),
    DEPTH_NORM("depthNorm", "general.island_settings.island_size", "bspkrs.fr.configgui.depthNorm", "How strongly island depth should tend to lie around depthMean. (Min=1, Max=10).", Property.Type.INTEGER),
    SHAPE_SPHEROID_WEIGHT("shapeSpheroidWeight", "general.island_settings", "bspkrs.fr.configgui.shapeSpheroidWeight", "The relative chance of an island having the spheroid shape.", Property.Type.INTEGER),
    SHAPE_CONE_WEIGHT("shapeConeWeight", "general.island_settings", "bspkrs.fr.configgui.shapeConeWeight", "The relative chance of an island having the cone shape.", Property.Type.INTEGER),
    SHAPE_JETSONS_WEIGHT("shapeJetsonsWeight", "general.island_settings", "bspkrs.fr.configgui.shapeJetsonsWeight", "The relative chance of an island having the jetsons shape.", Property.Type.INTEGER),
    NUMBER_OF_ITEMS("numberOfItems", "general.dungeon_settings", "bspkrs.fr.configgui.numberOfItems", "The number of items in a ruin's chest.", Property.Type.INTEGER),
    BLOCK_ID_BLACKLIST("blockIDBlacklist", "general", "bspkrs.fr.configgui.blockIDBlacklist", "Add block IDs to this list if you don't want them to be moved when a floating island is generated.  Format used: \",\" separates between id and metadata and \";\" separates between each block.", Property.Type.BLOCK_LIST),
    DIMENSION_ID_BLACKLIST("dimensionIDBlacklist", "general", "bspkrs.fr.configgui.dimensionIDBlacklist", "Add dimension IDs where you do not want Floating Ruins to generate.  Format used: \";\" separates between each dimension ID.", Property.Type.DIMENSION_LIST),
    BIOME_ID_BLACKLIST("biomeIDBlacklist", "general", "bspkrs.fr.configgui.biomeIDBlacklist", "Add biome IDs where you do not want Floating Ruins to generate.  Format used: \";\" separates between each biome ID.", Property.Type.BIOME_LIST),
    USE_CUSTOM_ITEM_LIST("useCustomItemList", "general.dungeon_settings", "bspkrs.fr.configgui.useCustomItemList", "Whether or not to use the custom list of items. When true the custom list below will be used, when false items will be chosen from the various lists used to choose random chest items for regular dungeons/desert ruins/etc.", Property.Type.BOOLEAN),
    STRING_OF_IDS("stringOfIds", "general.dungeon_settings", "bspkrs.fr.configgui.stringOfIds", "The ids for items found in chests. Format used: \",\" separates between item id, quantity, and metadata and \";\" separates between each item.", Property.Type.ITEMSTACK_LIST),
    SPAWNER_DEFAULT("spawnerDefault", "general.dungeon_settings", "bspkrs.fr.configgui.spawnerDefault", "Mob spawners can be configured using the mobs' names, each separated by a comma. Using \"Default\" will make the specified biome use the same settings as 'spawnerDefault'.", Property.Type.ENTITY_LIST),
    SPAWNER_DESERT("spawnerDesert", "general.dungeon_settings", "bspkrs.fr.configgui.spawnerDesert", "", Property.Type.ENTITY_LIST),
    SPAWNER_FOREST("spawnerForest", "general.dungeon_settings", "bspkrs.fr.configgui.spawnerForest", "", Property.Type.ENTITY_LIST),
    SPAWNER_PLAINS("spawnerPlains", "general.dungeon_settings", "bspkrs.fr.configgui.spawnerPlains", "", Property.Type.ENTITY_LIST),
    SPAWNER_SWAMPLAND("spawnerSwampland", "general.dungeon_settings", "bspkrs.fr.configgui.spawnerSwampland", "", Property.Type.ENTITY_LIST),
    SPAWNER_TAIGA("spawnerTaiga", "general.dungeon_settings", "bspkrs.fr.configgui.spawnerTaiga", "", Property.Type.ENTITY_LIST),
    SPAWNER_HILLS("spawnerHills", "general.dungeon_settings", "bspkrs.fr.configgui.spawnerHills", "", Property.Type.ENTITY_LIST),
    SPAWNER_OCEAN("spawnerOcean", "general.dungeon_settings", "bspkrs.fr.configgui.spawnerOcean", "", Property.Type.ENTITY_LIST),
    SPAWNER_RIVER("spawnerRiver", "general.dungeon_settings", "bspkrs.fr.configgui.spawnerRiver", "", Property.Type.ENTITY_LIST),
    SPAWNER_JUNGLE("spawnerJungle", "general.dungeon_settings", "bspkrs.fr.configgui.spawnerJungle", "", Property.Type.ENTITY_LIST),
    SPAWNER_ICE_BIOMES("spawnerIceBiomes", "general.dungeon_settings", "bspkrs.fr.configgui.spawnerIceBiomes", "", Property.Type.ENTITY_LIST),
    SPAWNER_MUSHROOM("spawnerMushroom", "general.dungeon_settings", "bspkrs.fr.configgui.spawnerMushroom", "", Property.Type.ENTITY_LIST),
    SPAWNER_NEAR_LAVA("spawnerNearLava", "general.dungeon_settings", "bspkrs.fr.configgui.spawnerNearLava", "If the dungeon is close enough to lava, the spawner will use these mobs.", Property.Type.ENTITY_LIST);

    private String key;
    private String ctgy;
    private String langKey;
    private String desc;
    private Property.Type propertyType;
    private String[] validStrings;

    private ConfigElement(String key, String ctgy, String langKey, String desc, Property.Type propertyType, String[] validStrings) {
        this.key = key;
        this.ctgy = ctgy;
        this.langKey = langKey;
        this.desc = desc;
        this.propertyType = propertyType;
        this.validStrings = validStrings;
    }

    private ConfigElement(String key, String ctgy, String langKey, String desc, Property.Type propertyType) {
        this(key, ctgy, langKey, desc, propertyType, new String[0]);
    }

    public String key() {
        return this.key;
    }

    public String ctgy() {
        return this.ctgy;
    }

    public String languageKey() {
        return this.langKey;
    }

    public String desc() {
        return this.desc;
    }

    public Property.Type propertyType() {
        return this.propertyType;
    }

    public String[] validStrings() {
        return this.validStrings;
    }
}

