/*
 * Decompiled with CFR 0.152.
 */
package bspkrs.floatingruins;

import bspkrs.floatingruins.FloatingRuins;
import bspkrs.util.CommonUtils;
import net.minecraftforge.common.config.Configuration;
import net.minecraftforge.common.config.Property;
import org.apache.logging.log4j.Level;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;

public enum FRLog {
    INSTANCE;

    private Logger logger;

    public Logger getLogger() {
        if (this.logger == null) {
            this.init();
        }
        return this.logger;
    }

    private void init() {
        if (this.logger != null) {
            return;
        }
        this.logger = LogManager.getLogger((String)"FloatingRuins");
    }

    public static void info(String format, Object ... args) {
        INSTANCE.log(Level.INFO, format, args);
    }

    public static void log(Level level, Throwable exception, String format, Object ... args) {
        if (args != null && args.length > 0) {
            INSTANCE.getLogger().log(level, String.format(format, args), exception);
        } else {
            INSTANCE.getLogger().log(level, format, exception);
        }
    }

    public static void severe(String format, Object ... args) {
        INSTANCE.log(Level.ERROR, format, args);
    }

    public static void warning(String format, Object ... args) {
        INSTANCE.log(Level.WARN, format, args);
    }

    public static void config(String format, Object ... args) {
        if (FloatingRuins.allowDebugLogging) {
            INSTANCE.log(Level.INFO, format, args);
        }
    }

    public static void config(Property prop) {
        if (FloatingRuins.allowDebugLogging) {
            if (prop.isList()) {
                INSTANCE.log(Level.INFO, "%s: %s", prop.getName(), CommonUtils.stringArrayToString((String[])prop.getStringList(), (String)"; "));
            } else {
                INSTANCE.log(Level.INFO, "%s: %s", prop.getName(), prop.getString());
            }
        }
    }

    public static void configs(Configuration config, String category) {
        if (FloatingRuins.allowDebugLogging) {
            FRLog.config("Logging config category %s:", category);
            for (Property prop : config.getCategory(category).getValues().values()) {
                FRLog.config(prop);
            }
        }
    }

    private void log(Level level, String format, Object ... data) {
        if (data != null && data.length > 0) {
            this.getLogger().log(level, String.format(format, data));
        } else {
            this.getLogger().log(level, format);
        }
    }

    public static void debug(String format, Object ... args) {
        if (FloatingRuins.allowDebugLogging) {
            FRLog.info("[DEBUG] " + format, args);
        }
    }
}

